/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.ext.opplugin.budget;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.isc.IscHelper;
import kd.fi.er.business.servicehelper.ErExceptionServiceHelper;

public class BillCheckBudgetEASWithReturnValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(BillCheckBudgetEASWithReturnValidator.class);

    public void validate() {
        try {
            ExtendedDataEntity[] billEntitys;
            for (ExtendedDataEntity billEntity : billEntitys = this.getDataEntities()) {
                DynamicObject srcBill = billEntity.getDataEntity();
                try {
                    String targetJson;
                    Object response = null;
                    String flowNumber = IscHelper.getISCSettingValue((String)"eas_check_bg_flownum");
                    String easBgIscNumber = IscHelper.getEasBgIscNumber((DynamicObject)srcBill);
                    if (IscHelper.isEasShareBudget((String)easBgIscNumber)) {
                        return;
                    }
                    if (StringUtils.isNotBlank((CharSequence)flowNumber)) {
                        targetJson = IscHelper.buildTargetBillJson((DynamicObject)srcBill, (String)easBgIscNumber);
                        response = IscHelper.execBudgetService((String)flowNumber, (String)"checkEASBillBudgetReturn", (String)targetJson);
                    } else {
                        targetJson = IscHelper.buildTargetBillJson((DynamicObject)srcBill, (String)easBgIscNumber);
                        response = IscHelper.doEASFacade((String)"checkEASBillBudgetReturn", (Object)targetJson);
                    }
                    if (response == null) continue;
                    JSONObject responseJson = (JSONObject)SerializationUtils.fromJsonString((String)response.toString(), JSONObject.class);
                    srcBill.set("isoverbudget", (Object)responseJson.getBoolean("isOverBudget"));
                }
                catch (KDBizException kdBizExcepetion) {
                    logger.info("EAS\u96c6\u6210,\u82cd\u7a79\u5355\u636e\u8fdb\u884cEAS\u8d39\u7528\u9884\u7b97\u68c0\u67e5\u5931\u8d251:" + kdBizExcepetion.getMessage());
                    this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"\u661f\u701a\u8d39\u7528\u5355\u636e\u8fdb\u884cEAS\u8d39\u7528\u9884\u7b97\u68c0\u67e5\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EM-W-831271", (String)"fi-er-opplugin", (Object[])new Object[0]), new Object[0]));
                    break;
                }
                catch (Exception exception) {
                    logger.info("EAS\u96c6\u6210,\u82cd\u7a79\u5355\u636e\u8fdb\u884cEAS\u8d39\u7528\u9884\u7b97\u68c0\u67e5\u5931\u8d252:" + exception.getMessage());
                    String detail = ErExceptionServiceHelper.getStackTrace((Throwable)exception);
                    int start = detail.lastIndexOf("BgControlException:");
                    if (start == -1) {
                        this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EM-W-051134", (String)"fi-er-opplugin", (Object[])new Object[0]), new Object[0]));
                    } else {
                        this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4e0d\u8db3,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!\u8be6\u7ec6\u4fe1\u606f\u4e3a:%s", (String)"BillCheckBudgetEASValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]), IscHelper.getExceptionDescription((String)detail)));
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("EAS\u96c6\u6210,\u82cd\u7a79\u5355\u636e\u8fdb\u884cEAS\u8d39\u7528\u9884\u7b97\u68c0\u67e5\u5931\u8d253:", (Throwable)e);
            throw e;
        }
    }
}

