/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.ext.opplugin.budget;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BillCheckBudgetXKValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(BillCheckBudgetXKValidator.class);
    private static final Map<String, String> SYN_START_SCHEMA_MAP;
    private static final Map<String, String> PAYER_TYPE_SUFIX_MAP;
    public static final Set<String> VALIDATE_BILL_SET;

    public void validate() {
        ExtendedDataEntity[] billEntitys;
        for (ExtendedDataEntity billEntity : billEntitys = this.getDataEntities()) {
            DynamicObject srcBill = billEntity.getDataEntity();
            String entityName = srcBill.getDynamicObjectType().getName();
            if (this.isSkipValidate(entityName) || "er_tripreqbill".equals(entityName) && !srcBill.getBoolean("isloan")) continue;
            List<String> startSchemaNumbers = this.getStartSchemaNumbers(srcBill);
            if (startSchemaNumbers.isEmpty()) {
                this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"\u661f\u7a7a\u96c6\u6210\uff0c%1$s\u83b7\u53d6\u661f\u7a7a\u542f\u52a8\u65b9\u6848\u4e3a\u7a7a\u3002", (String)"BillCheckBudgetXKValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]), entityName));
                logger.info(String.format("\u661f\u7a7a\u96c6\u6210,%1$s\u9884\u7b97\u540c\u6b65\u542f\u52a8\u65b9\u6848\u4e3a\u7a7a", entityName));
                continue;
            }
            if (StringUtils.equals((CharSequence)entityName, (CharSequence)"er_tripreimbursebill")) {
                boolean encashSynFlag = true;
                boolean monthSynFlag = true;
                if (startSchemaNumbers.size() < 2) {
                    this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5dee\u65c5\u62a5\u9500\u5355\u542f\u52a8\u65b9\u6848\u5931\u8d25\u3002", (String)"BillCheckBudgetXKValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]), entityName));
                }
                if (srcBill.getBigDecimal("encashamount").compareTo(BigDecimal.ZERO) != 0 || srcBill.getDynamicObjectCollection("clearloanentry").size() > 0) {
                    encashSynFlag = this.synBill(billEntity, startSchemaNumbers.get(0));
                }
                if (srcBill.getBigDecimal("monthsettleamount").compareTo(BigDecimal.ZERO) != 0) {
                    monthSynFlag = this.synBill(billEntity, startSchemaNumbers.get(1));
                }
                if (!encashSynFlag || !monthSynFlag) {
                    logger.info(String.format("\u5dee\u65c5\u62a5\u9500\u5355\u540c\u6b65\u661f\u7a7a\u5360\u7528\u9884\u7b97\u5931\u8d25\uff0c \u4ed8\u73b0\u540c\u6b65\u6210\u529f:%1$s \u4ed8\u73b0 %2$s  \u6708\u7ed3\u540c\u6b65\u6210\u529f:%3$s \u6708\u7ed3%4$s  ", encashSynFlag, srcBill.getBigDecimal("encashamount").toString(), monthSynFlag, srcBill.getBigDecimal("monthsettleamount").toString()));
                    this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u5355\u540c\u6b65\u661f\u7a7a\u5360\u7528\u9884\u7b97\u5931\u8d25\u3002\u4ed8\u73b0\u540c\u6b65\u6210\u529f\uff1a%1$s\uff0c\u6708\u7ed3\u540c\u6b65\u6210\u529f\uff1a%2$s\u3002", (String)"BillCheckBudgetXKValidator_6", (String)"fi-er-opplugin", (Object[])new Object[0]), encashSynFlag, monthSynFlag));
                    continue;
                }
            } else if (!this.synBill(billEntity, startSchemaNumbers.get(0))) continue;
            logger.info("\u540c\u6b65\u6210\u529f\uff0c\u5360\u7528\u661f\u7a7a\u9884\u7b97");
        }
    }

    private boolean synBill(ExtendedDataEntity billEntity, String startSchemaNumber) {
        long billid = billEntity.getDataEntity().getLong("id");
        Map<String, Object> filterParam = Stream.of(new Object[][]{{"id", billid}}).collect(Collectors.toMap(item -> (String)item[0], item -> item[1]));
        Map response = null;
        try {
            response = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"syncExecute", (Object[])new Object[]{startSchemaNumber, filterParam});
        }
        catch (Exception e) {
            this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5360\u7528\u661f\u7a7a\u9884\u7b97\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"BillCheckBudgetXKValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]), e.getMessage()));
            return false;
        }
        if (response == null) {
            this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"BillCheckBudgetXKValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (!((Boolean)response.get("success")).booleanValue()) {
            String msg = (String)response.get("msg");
            int satrtIndex = msg.indexOf("{");
            int endInex = msg.indexOf("}");
            if (endInex > satrtIndex + 1 && satrtIndex > -1) {
                msg = msg.substring(satrtIndex + 1, endInex);
            }
            this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5360\u7528\u661f\u7a7a\u9884\u7b97\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"BillCheckBudgetXKValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]), msg));
            return false;
        }
        String executionState = (String)response.get("execution_state");
        if (!StringUtils.equals((CharSequence)"S", (CharSequence)executionState)) {
            String triggerNumber = (String)response.get("trigger_number");
            String executionNUmber = (String)response.get("execution_number");
            this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5360\u7528\u661f\u7a7a\u9884\u7b97\u5931\u8d25\uff0c \u89e6\u53d1\u542f\u52a8\u65b9\u6848\uff1a%1$s\uff0c\u6267\u884c\u7ed3\u679c\u7f16\u7801\uff1a%2$s\uff0c\u6267\u884c\u7ed3\u679c\u72b6\u6001\uff1a%3$s\uff0c \u5177\u4f53\u539f\u56e0\u8bf7\u5728\u96c6\u6210\u5e73\u53f0\u6570\u636e\u96c6\u6210\u6267\u884c\u65e5\u5fd7\u5904\u67e5\u8be2\u3002", (String)"BillCheckBudgetXKValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]), triggerNumber, executionNUmber, executionState));
            return false;
        }
        return true;
    }

    protected List<String> getStartSchemaNumbers(DynamicObject entry) {
        String entryId = entry.getDynamicObjectType().getName();
        String startSuffix = String.join((CharSequence)"", entryId, "_");
        String endSuffix = "_xk_buget";
        ArrayList<String> list = new ArrayList<String>();
        switch (entryId) {
            case "er_tripreqbill": {
                list.add(SYN_START_SCHEMA_MAP.get("er_tripreqbill_payeer_xk_buget"));
                break;
            }
            case "er_dailyreimbursebill": {
                list.add(SYN_START_SCHEMA_MAP.get("er_dailyreimbursebill_payeer_xk_buget"));
                break;
            }
            case "er_repaymentbill": {
                String billpayertype = entry.getString("payertype");
                list.add(SYN_START_SCHEMA_MAP.get(String.join((CharSequence)"", startSuffix, PAYER_TYPE_SUFIX_MAP.get(billpayertype), endSuffix)));
                break;
            }
            case "er_publicreimbursebill": 
            case "er_dailyloanbill": {
                String billpayertype = ((DynamicObject)entry.getDynamicObjectCollection("accountentry").get(0)).getString("payertype");
                list.add(SYN_START_SCHEMA_MAP.get(String.join((CharSequence)"", startSuffix, PAYER_TYPE_SUFIX_MAP.get(billpayertype), endSuffix)));
                break;
            }
            case "er_tripreimbursebill": {
                list.add(SYN_START_SCHEMA_MAP.get("er_tripreimbursebill_cash_xk_buget"));
                list.add(SYN_START_SCHEMA_MAP.get("er_tripreimbursebill_monthly_xk_buget"));
                break;
            }
            default: {
                return Collections.EMPTY_LIST;
            }
        }
        return list.stream().filter(item -> item != null).collect(Collectors.toList());
    }

    protected boolean isSkipValidate(String entryId) {
        return !VALIDATE_BILL_SET.contains(entryId);
    }

    static {
        DynamicObject setting = BusinessDataServiceHelper.loadSingleFromCache((String)"er_isc_setting", (String)"id,entryentity.key,entryentity.value", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"setting")});
        Map<String, String> map = setting.getDynamicObjectCollection("entryentity").stream().filter(row -> {
            String key = row.getString("key");
            return key != null && key.startsWith("er_") && key.endsWith("_xk_buget");
        }).collect(Collectors.toMap(row -> row.getString("key"), row -> row.getString("value")));
        Set set = Stream.of("er_publicreimbursebill", "er_repaymentbill", "er_dailyreimbursebill", "er_dailyloanbill", "er_tripreqbill", "er_tripreimbursebill").collect(Collectors.toSet());
        Map<String, String> mapTwo = Stream.of({"bd_supplier", "supplier"}, {"bd_customer", "customer"}, {"er_payeer", "payeer"}).collect(Collectors.toMap(item -> item[0], item -> item[1]));
        SYN_START_SCHEMA_MAP = Collections.unmodifiableMap(map);
        PAYER_TYPE_SUFIX_MAP = Collections.unmodifiableMap(mapTwo);
        VALIDATE_BILL_SET = Collections.unmodifiableSet(set);
    }
}

