/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class UnAuditMsgOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String Interaction_Sponore = "kd.fi.er.opplugin.UnAuditMsgOpPlugin";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("unauditmsg");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        boolean success = this.showInteractionForm(e);
        if (!success) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u7528\u6237\u53d6\u6d88\u64cd\u4f5c\u3002", (String)"UnAuditMsgOpPlugin_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        e.cancel = !success;
    }

    private boolean showInteractionForm(BeforeOperationArgs e) {
        String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        if (confirmResult.getResults().containsKey(Interaction_Sponore)) {
            String rawResult = (String)confirmResult.getResults().get(Interaction_Sponore);
            if (StringUtils.isBlank((CharSequence)rawResult)) {
                return false;
            }
            Map result = (Map)SerializationUtils.fromJsonString((String)rawResult, Map.class);
            if ("btncancel".equals(result.get("OP"))) {
                return false;
            }
            String msg = (String)result.get("msg");
            for (DynamicObject bill : e.getDataEntities()) {
                bill.set("unauditmsg", (Object)this.handleMsg(msg, bill));
            }
            SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
            return true;
        }
        InteractionContext interactionContext = new InteractionContext();
        interactionContext.setCustShowFormId("er_unauditmsg");
        throw new KDInteractionException(Interaction_Sponore, interactionContext);
    }

    private String handleMsg(String msg, DynamicObject bill) {
        StringBuilder msgBuilder = new StringBuilder();
        Date now = new Date();
        String time = SDF.format(now);
        Map currUserInfo = UserServiceHelper.getUserInfoByID((long)RequestContext.get().getCurrUserId());
        String currUserName = (String)currUserInfo.get("name");
        msg = String.format(ResManager.loadKDString((String)"%1$s%2$s%3$s%4$s\u53cd\u5ba1\u6838\u610f\u89c1\uff1a%5$s", (String)"UnAuditMsgOpPlugin_0", (String)"fi-er-opplugin", (Object[])new Object[0]), time, " ", currUserName, " ", msg);
        msgBuilder.append(msg);
        String preMsg = bill.getString("unauditmsg");
        if (preMsg != null && !preMsg.equals("")) {
            msgBuilder.append("\r\n").append(preMsg);
            if (msgBuilder.length() > 1000) {
                int i;
                ArrayList<String> msgs = new ArrayList<String>(Arrays.asList(preMsg.split("\r\n")));
                StringBuilder result = new StringBuilder(msg);
                int lenDiff = msgBuilder.length() - 1000;
                int cutLen = 0;
                int size = msgs.size();
                for (i = size - 1; i >= 0; --i) {
                    String currStr = msgs.get(i);
                    msgs.remove(i);
                    if ((cutLen += currStr.length() + 2) >= lenDiff) break;
                }
                for (i = 0; i < msgs.size(); ++i) {
                    result.append("\r\n").append(msgs.get(i));
                }
                msgBuilder = result;
            }
        }
        return msgBuilder.toString();
    }
}

