/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.amount.control;

import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.validator.amount.control.AmountFreedSaveValidator;

public class AmountFreedSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AmountFreedSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("name");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            this.setExpenseItemStrValue(dataEntity);
        }
    }

    private void setExpenseItemStrValue(DynamicObject dataEntity) {
        String baseDataNames = this.getMultiBaseDataNames(dataEntity, "expenseitem");
        if (baseDataNames != null && baseDataNames.length() > 200) {
            baseDataNames = baseDataNames.substring(0, 200);
        }
        dataEntity.set("expenseitemstr", (Object)baseDataNames);
    }

    private String getMultiBaseDataNames(DynamicObject dataEntity, String propName) {
        DynamicObjectCollection coll = (DynamicObjectCollection)dataEntity.get(propName);
        String baseDataNames = coll.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue()).collect(Collectors.joining(","));
        return baseDataNames;
    }
}

