/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.billingpool;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.opplugin.billingpool.BillingPoolOp;
import kd.fi.er.validator.invoicecloud.billingpool.BillingPoolControlValidator;
import kd.fi.er.validator.invoicecloud.billingpool.BillingPoolSubmitValidator;
import org.apache.commons.lang3.StringUtils;

public class BillingPoolSubmitOp
extends AbstractOperationServicePlugIn
implements BillingPoolOp {
    private static final Log logger = LogFactory.getLog(BillingPoolSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("invoicetype.uniquecondition");
        fieldKeys.add("invoicetype.js");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BillingPoolSubmitValidator());
        Function<ExtendedDataEntity, List<BillingPoolControlValidator.BillingPoolControlValidatorArgs>> controlValidatorFunc = extendedDataEntity -> {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Long accountOrg = (Long)dataEntity.getDynamicObject("costcompany").getPkValue();
            Date invoiceDate = dataEntity.getDate("invoicedate");
            String invoiceNo = dataEntity.getString("invoiceno");
            Long billingId = (Long)dataEntity.getPkValue();
            BillingPoolControlValidator.BillingPoolControlValidatorArgs args = new BillingPoolControlValidator.BillingPoolControlValidatorArgs(accountOrg, invoiceDate, invoiceNo, billingId, false);
            return Lists.newArrayList((Object[])new BillingPoolControlValidator.BillingPoolControlValidatorArgs[]{args});
        };
        e.addValidator((AbstractValidator)new BillingPoolControlValidator(controlValidatorFunc));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject bill : e.getDataEntities()) {
            bill.set("receiptdate", bill.get("invoicedate"));
            if (StringUtils.isBlank((CharSequence)bill.getString("invoiceno"))) {
                bill.set("invoiceno", (Object)"-");
            }
            if (StringUtils.isBlank((CharSequence)bill.getString("invoicecode"))) {
                bill.set("invoicecode", (Object)"-");
            }
            this.genName(bill);
            this.genSerialNo(bill);
        }
    }
}

