/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.utils.ErStdConfig;

public class BuildVouchersOp
extends AbstractOperationServicePlugIn {
    private boolean disabled = ErStdConfig.getBoolean((String)"BuildVouchersOp_disabled");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keyList = e.getFieldKeys();
        keyList.add("hasvoucher");
        keyList.add("sharerule");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        if (this.disabled) {
            return;
        }
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    boolean hasvoucher = dataEntity.getBoolean("hasvoucher");
                    boolean monthrule = "monthrule".equals(dataEntity.getString("sharerule"));
                    if (!hasvoucher || monthrule) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u975e\u6309\u6708\u5206\u644a\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210\u51ed\u8bc1\u3002", (String)"BuildVouchersOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if (this.disabled) {
            return;
        }
        this.getOption().setVariableValue("ignoretemplateunique", "true");
    }
}

