/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.util.HeadInvoiceStatusUtil;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.validator.invoicecloud.checkInvoice.ReimSubmitCheckInvoiceValidator;

public class ErConfirmChangeInvoiceOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ErConfirmChangeInvoiceOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        long starttime = System.currentTimeMillis();
        for (DynamicObject dataEntity : dataEntities) {
            try {
                DynamicObjectCollection expList = dataEntity.getDynamicObjectCollection("expenseentryentity");
                if (expList != null && expList.size() > 0 && ((DynamicObject)expList.get(0)).containsProperty("expischangeinvoice")) {
                    List dynamicObjects = expList.stream().filter(t -> t.get("expischangeinvoice") != null && t.getBoolean("expischangeinvoice")).collect(Collectors.toList());
                    if (dynamicObjects != null && dynamicObjects.size() > 0) {
                        dataEntity.set("ischangeinvoice", (Object)true);
                    } else {
                        dataEntity.set("ischangeinvoice", (Object)false);
                    }
                } else {
                    dataEntity.set("ischangeinvoice", (Object)false);
                }
                String res = InvoiceUtils.unbindInvoiceAefTicket((DynamicObject)dataEntity);
                if (!"ok".equals(res)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u786e\u8ba4\u6362\u7968\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u53d1\u7968\u89e3\u7ed1\u5931\u8d25\u3002", (String)"ChangeInvoiceOpPlugin_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
                HeadInvoiceStatusUtil.needScanSetting((DynamicObject)dataEntity);
                DynamicObjectCollection invoiceitemList = dataEntity.getDynamicObjectCollection("invoiceitementry");
                DynamicObjectCollection invoiceexpList = dataEntity.getDynamicObjectCollection("invoiceandexpense");
                if (invoiceitemList != null && invoiceitemList.size() > 0) {
                    invoiceitemList.removeIf(v -> v.containsProperty("invoiceitemisunbind") && v.getBoolean("invoiceitemisunbind"));
                }
                if (invoiceexpList == null || invoiceexpList.size() <= 0) continue;
                invoiceexpList.removeIf(v -> v.containsProperty("invoiceexpisunbind") && v.getBoolean("invoiceexpisunbind"));
            }
            catch (Exception exception) {
                logger.error("---\u6362\u53d1\u7968\u5931\u8d25\u539f\u56e0---", (Throwable)exception);
                throw new KDBizException(ResManager.loadKDString((String)"\u786e\u8ba4\u6362\u7968\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u53d1\u7968\u89e3\u7ed1\u5931\u8d25\u3002", (String)"ChangeInvoiceOpPlugin_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        }
        logger.info("----ErConfirmChangeInvoiceOP\u82b1\u8d39\u65f6\u95f4\u4e3a----" + (System.currentTimeMillis() - starttime) / 1000L);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ReimSubmitCheckInvoiceValidator());
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        DynamicObject[] dataEntities;
        super.rollbackOperation(e);
        logger.info("----ErConfirmChangeInvoiceOP \u8fdb\u5165rollbackOperation\u65b9\u6cd5----");
        for (DynamicObject dataEntity : dataEntities = e.getDataEntitys()) {
            try {
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)dataEntity.getDataEntityType().getName(), (String)"id,billno,costcompany,company,noinvoice,invoiceentry.id,invoiceentry.serialno,invoiceentry.invoicefrom,expenseentryentity.id,expenseentryentity.itemfrom,expenseentryentity.expenseitem,needuploadinvoice,is_all_einvoice,needimagescan,invoiceandexpense.id,invoiceandexpense.expenseentryid,invoiceandexpense.invoiceentryid,invoiceandexpense.invoiceexpserialno,invoiceitementry.invoiceitemserialno,invoiceentry.invoicetype");
                if (bill == null) continue;
                String res = InvoiceUtils.unbindInvoiceAefTicket((DynamicObject)bill);
                logger.info("----rollbackOperation \u8fdb\u5165 unbindInvoiceAefTicket\u65b9\u6cd5----" + res);
                HeadInvoiceStatusUtil.needScanSetting((DynamicObject)bill);
            }
            catch (Exception exception) {
                logger.error("---\u6362\u53d1\u7968\u5931\u8d25\u539f\u56e0---", (Object)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u786e\u8ba4\u6362\u7968\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u53d1\u7968\u89e3\u7ed1\u5931\u8d25\u3002", (String)"ChangeInvoiceOpPlugin_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

