/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily.web.importplugin;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class ErPayeerImportDataPlugin
extends BatchImportPlugin {
    private Set<Long> hasDefautPayer = Sets.newHashSetWithExpectedSize((int)4);
    private String isgetaccountcurrency = null;

    protected void importData() throws Throwable {
        super.importData();
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        while (iterator.hasNext()) {
            JSONObject jsonObject;
            ImportBillData data = iterator.next();
            String errorMsg = this.validate(data);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                logger.log(Integer.valueOf(data.getStartIndex()), errorMsg);
                logger.fail();
                iterator.remove();
            }
            if ((jsonObject = data.getData()) == null || !StringUtils.isEmpty((CharSequence)jsonObject.getString("payeraccountname"))) continue;
            if (!Boolean.TRUE.equals(jsonObject.getBoolean("isemployee")) && StringUtils.isNotEmpty((CharSequence)jsonObject.getString("outpayer"))) {
                jsonObject.put("payeraccountname", jsonObject.get((Object)"outpayer"));
                continue;
            }
            if (!Boolean.TRUE.equals(jsonObject.getBoolean("isemployee")) || jsonObject.getJSONObject("payer") == null || !StringUtils.isNotEmpty((CharSequence)jsonObject.getJSONObject("payer").getString("name"))) continue;
            jsonObject.put("payeraccountname", (Object)jsonObject.getJSONObject("payer").getString("name"));
        }
        return super.save(rowdatas, logger);
    }

    private String validate(ImportBillData data) {
        if (this.hasDefaultPayee(data)) {
            return ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5df2\u5b58\u5728\u9ed8\u8ba4\u6536\u6b3e\u4fe1\u606f\uff0c\u65e0\u6cd5\u518d\u8bbe\u7f6e\u3002", (String)"BankCardManagementPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
        }
        JSONObject jsonObject = data.getData();
        if (Boolean.TRUE.equals(jsonObject.getBoolean("isdefault")) && !Boolean.TRUE.equals(jsonObject.getBoolean("isemployee"))) {
            return ResManager.loadKDString((String)"\u975e\u804c\u5458\u7684\u6536\u6b3e\u4fe1\u606f\u4e0d\u80fd\u8bbe\u7f6e\u6210\u9ed8\u8ba4\u3002", (String)"PayerList_4", (String)"fi-er-formplugin", (Object[])new Object[0]);
        }
        if (this.isgetaccountcurrency == null) {
            Long currentUserID = CommonServiceHelper.getCurrentUserID();
            Long createOrgId = CommonServiceHelper.getCompanyIdByUserId((Long)currentUserID);
            if (createOrgId == null && (createOrgId = Long.valueOf(UserServiceHelper.getUserMainOrgId((long)currentUserID))).floatValue() == 0.0f) {
                createOrgId = RequestContext.get().getOrgId();
            }
            this.isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)createOrgId);
        }
        if ("1".equals(this.isgetaccountcurrency) && jsonObject.get((Object)"currency") == null) {
            return ResManager.loadKDString((String)"\u6536\u6b3e\u5206\u5f55\u53d6\u8d26\u6237\u5e01\u79cd\u503c\uff0c\u8bf7\u8f93\u5165\u201c\u5e01\u79cd\u201d\u3002", (String)"PayeeSaveOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private boolean hasDefaultPayee(ImportBillData data) {
        String importValue;
        String importprop;
        DynamicObject payer;
        JSONObject payerInfo;
        JSONObject jsonObject = data.getData();
        if (Boolean.TRUE.equals(jsonObject.getBoolean("isdefault")) && Boolean.TRUE.equals(jsonObject.getBoolean("isemployee")) && (payerInfo = jsonObject.getJSONObject("payer")) != null && (payer = QueryServiceHelper.queryOne((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter(importprop = payerInfo.getString("importprop"), "=", (Object)(importValue = payerInfo.getString(importprop)))})) != null) {
            Long payerId = payer.getLong("id");
            if (this.hasDefautPayer.add(payerId)) {
                List otherDefaultAccountByPayerID = PayeeServiceHelper.getOtherDefaultAccountByPayerID((Long)payerId, (Object)0, (boolean)false);
                if (!otherDefaultAccountByPayerID.isEmpty()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

