/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily.web.importplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.opplugin.daily.web.importplugin.utils.ImportUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class LoanBillImportDataOp
extends AbstractOperationServicePlugIn
implements IImportPlugin {
    private static final Log logger = LogFactory.getLog(LoanBillImportDataOp.class);
    private static final String AMTPRECISION = "amtprecision";
    private static final String BOSORG = "bos_org";
    private static final String BOSUSER = "bos_user";
    private static final String NUMBER = "number";
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        super.beforeImportData(data, option, importlogs);
        String errormsg = null;
        try {
            String bizdate = (String)data.get("bizdate");
            if (StringUtils.isEmpty((CharSequence)bizdate)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a\u7533\u8bf7\u65e5\u671f\u3002", (String)"LoanBillImportDataOp_46", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            if (this.checkBizdate(bizdate)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002", (String)"LoanBillImportDataOp_12", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            data.put("bizdate", StringUtils.isEmpty((CharSequence)bizdate) ? null : DateUtils.parseDate((String)bizdate, (String[])new String[]{"yyyy-MM-dd"}));
            this.handleHeadField(data);
            this.handleExpenseEntry(data, (JSONObject)data.get("company"), (JSONObject)data.get("costdept"));
            this.handleAccountEntry(data);
        }
        catch (KDBizException e1) {
            errormsg = e1.getMessage();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            errormsg = ResManager.loadKDString((String)"\u6570\u636e\u5904\u7406\u5f02\u5e38", (String)"LoanBillImportDataOp_13", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        if (errormsg != null) {
            importlogs.add(new ImportLogger.ImportLog(errormsg));
            return false;
        }
        return true;
    }

    private void handleHeadField(Map<String, Object> data) {
        QFilter userFilter;
        DynamicObject applier;
        Object billstatus = data.get("billstatus");
        if (!ErBillStatusEnum.E.toString().equals(billstatus) && !ErBillStatusEnum.G.toString().equals(billstatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u53ea\u80fd\u4e3a\u201c\u5ba1\u6838\u901a\u8fc7\u201d\u6216\u201c\u5df2\u4ed8\u6b3e\u201d\u3002", (String)"LoanBillImportDataOp_14", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        if (data.get("auditdate") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5ba1\u6838\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"LoanBillImportDataOp_54", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        if (ErBillStatusEnum.G.toString().equals(billstatus) && data.get("head_paydate") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e3a\u5df2\u4ed8\u6b3e\u72b6\u6001\uff0c\u4ed8\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanBillImportDataOp_52", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        JSONObject jsonObject = (JSONObject)data.get("applier");
        if (jsonObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a\u7533\u8bf7\u4eba\u5de5\u53f7\u3002", (String)"LoanBillImportDataOp_48", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        if (data.containsKey("billpayertype") && data.get("billpayertype") == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165,\u5b57\u6bb5\u6807\u8bc6\uff1a%s", (String)"LoanBillImportDataOp_55", (String)"fi-er-opplugin", (Object[])new Object[0]), "billpayertype"));
        }
        if (data.containsKey("billpayerid") && data.get("billpayerid") == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165,\u5b57\u6bb5\u6807\u8bc6\uff1a%s", (String)"LoanBillImportDataOp_55", (String)"fi-er-opplugin", (Object[])new Object[0]), "billpayerid"));
        }
        if (data.containsKey("detailtype") && data.get("detailtype") == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165,\u5b57\u6bb5\u6807\u8bc6\uff1a%s", (String)"LoanBillImportDataOp_55", (String)"fi-er-opplugin", (Object[])new Object[0]), "detailtype"));
        }
        Object applierNum = jsonObject.get((Object)NUMBER);
        if (applierNum instanceof Double) {
            String numStr = applierNum.toString();
            if (numStr.contains(".")) {
                numStr = numStr.substring(0, numStr.lastIndexOf(46));
                applier = new JSONObject();
                applier.put(NUMBER, (Object)numStr);
                data.put("applier", applier);
            }
            applierNum = numStr;
        }
        if ((applier = BusinessDataServiceHelper.loadSingleFromCache((String)BOSUSER, (String)"id, number, name, enable", (QFilter[])new QFilter[]{userFilter = new QFilter(NUMBER, "=", applierNum)})) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u5de5\u53f7\u4e0d\u5b58\u5728\u3002", (String)"LoanBillImportDataOp_15", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        if (this.checkBaseDataDisenable(applier)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba%s\u5df2\u88ab\u7981\u7528\u3002", (String)"LoanBillImportDataOp_16", (String)"fi-er-opplugin", (Object[])new Object[0]), applierNum));
        }
        ((JSONObject)data.get("applier")).put("id", applier.getPkValue());
        DynamicObject userMap = LoanBillImportDataOp.getUser(applier.getLong("id"));
        data.put("tel", userMap.get("phone"));
        DynamicObject userOrg = userMap.getDynamicObjectCollection("entryentity").stream().filter(e -> !e.getBoolean("ispartjob")).findFirst().orElse(null);
        if (userOrg == null || userOrg.get("dpt") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u4e3b\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanBillImportDataOp_17", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        data.put("applierpositionstr", userOrg.getString("position"));
        ImportUtils.setProjectOwer(data);
        JSONObject org = new JSONObject();
        org.put("id", userOrg.get("dpt.id"));
        org.put(NUMBER, userOrg.get("dpt.number"));
        if (data.get("org") != null && StringUtils.isNotEmpty((CharSequence)((JSONObject)data.get("org")).getString(NUMBER))) {
            DynamicObject chooseOrg = userMap.getDynamicObjectCollection("entryentity").stream().filter(e -> e.getString("dpt.number").equals(((JSONObject)data.get("org")).getString(NUMBER))).findFirst().orElse(null);
            if (chooseOrg == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u90e8\u95e8\u4e0e\u7533\u8bf7\u4eba\u4e0d\u5339\u914d\u3002", (String)"LoanBillImportDataOp_18", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            if (this.orgFreeze(chooseOrg.getLong("dpt.id"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u90e8\u95e8%s\u5df2\u5c01\u5b58\u3002", (String)"LoanBillImportDataOp_19", (String)"fi-er-opplugin", (Object[])new Object[0]), chooseOrg.get("dpt.number")));
            }
            org.put("id", chooseOrg.get("dpt.id"));
            org.put(NUMBER, chooseOrg.get("dpt.number"));
        }
        data.put("org", org);
        Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)org.getLong("id"));
        if (company.get("id") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LoanBillImportDataOp_20", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        JSONObject jsonObjectCompany = new JSONObject();
        data.put("company", jsonObjectCompany);
        jsonObjectCompany.put("id", company.get("id"));
        jsonObjectCompany.put(NUMBER, company.get(NUMBER));
        if (data.get("costdept") == null || StringUtils.isEmpty((CharSequence)((JSONObject)data.get("costdept")).getString(NUMBER))) {
            data.put("costdept", org);
        } else {
            DynamicObject costOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_adminorg", (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)((JSONObject)data.get("costdept")).getString(NUMBER))});
            if (costOrg == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e0d\u5b58\u5728\u6216\u5df2\u5c01\u5b58\u3002", (String)"LoanBillImportDataOp_44", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            ((JSONObject)data.get("costdept")).put("id", costOrg.getPkValue());
            if (this.orgFreeze((Long)costOrg.getPkValue())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e0d\u5b58\u5728\u6216\u5df2\u5c01\u5b58\u3002", (String)"LoanBillImportDataOp_44", (String)"fi-er-opplugin", (Object[])new Object[0]), ((JSONObject)data.get("costdept")).getString(NUMBER)));
            }
        }
        String msg = ImportUtils.checkCostDeptSelectInRange((long)((Long)applier.getPkValue()), (long)((Long)company.get("id")), (long)((JSONObject)data.get("costdept")).getLong("id"));
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            throw new KDBizException(msg);
        }
        JSONObject jsonObjectCostCompany = new JSONObject();
        if (data.get("costcompany") != null && StringUtils.isNotEmpty((CharSequence)((JSONObject)data.get("costcompany")).getString(NUMBER))) {
            String costCompanyNumber = ((JSONObject)data.get("costcompany")).getString(NUMBER);
            DynamicObject costCompany = ImportUtils.getOrgByNumber((String)costCompanyNumber);
            if (costCompany == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e0d\u5b58\u5728\u6216\u5df2\u5c01\u5b58\u3002", (String)"LoanBillImportDataOp_45", (String)"fi-er-opplugin", (Object[])new Object[0]), costCompanyNumber));
            }
            if (ImportUtils.orgFreeze((Long)ErCommonUtils.getPk((Object)costCompany))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e0d\u5b58\u5728\u6216\u5df2\u5c01\u5b58\u3002", (String)"LoanBillImportDataOp_45", (String)"fi-er-opplugin", (Object[])new Object[0]), costCompanyNumber));
            }
            jsonObjectCostCompany.put(NUMBER, (Object)((JSONObject)data.get("costcompany")).getString(NUMBER));
            jsonObjectCostCompany.put("id", costCompany.getPkValue());
        } else {
            String costcompanyNum = this.getOneEntryCostCompanyByDeptId(((JSONObject)data.get("costdept")).getLong("id"), jsonObjectCostCompany);
            jsonObjectCostCompany.put(NUMBER, (Object)costcompanyNum);
        }
        data.put("costcompany", jsonObjectCostCompany);
        Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((boolean)false, (Long)((JSONObject)data.get("costdept")).getLong("id"));
        DynamicObject currencyDym = BaseCurrencyServiceHelper.getBaseCurrencyObject((Object)Long.valueOf(company.get("id").toString()), (Object)costCompanyId);
        if (currencyDym == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u4e3a\u7a7a", (String)"LoanBillImportDataOp_24", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        JSONObject currency = new JSONObject();
        currency.put("id", currencyDym.getPkValue());
        currency.put(NUMBER, (Object)currencyDym.getString(NUMBER));
        data.put("currency", currency);
        data.put(AMTPRECISION, currencyDym.getInt(AMTPRECISION));
        String description = (String)data.get("description");
        if (StringUtils.isEmpty((CharSequence)description)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e8b\u7531\u4e0d\u80fd\u4e3a\u7a7a", (String)"LoanBillImportDataOp_47", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        if (!StringUtils.isEmpty((CharSequence)description) && description.length() > 600) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e8b\u7531\u5b57\u7b26\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7600\u4e2a\u5b57\u7b26\u3002", (String)"LoanBillImportDataOp_25", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        String payDateString = (String)data.get("head_paydate");
        if (ErBillStatusEnum.G.toString().equals(billstatus) && StringUtils.isBlank((CharSequence)payDateString)) {
            payDateString = dateFormatter.format(new Date());
            data.put("head_paydate", payDateString);
        }
        Date bizDate = (Date)data.get("bizdate");
        if (data.get("repaymentdate") != null) {
            String formatType = (String)data.get("repaymentdate");
            Date repaymentdate = new Date();
            try {
                repaymentdate = new SimpleDateFormat("yyyy-MM-dd").parse(formatType);
            }
            catch (ParseException e2) {
                throw new RuntimeException(e2);
            }
            if (repaymentdate.before(bizDate)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8fd8\u6b3e\u65e5\u671f/\u9884\u8ba1\u51b2\u9500\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u7533\u8bf7\u65e5\u671f\u3002", (String)"LoanBillImportDataOp_26", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        } else {
            long companyId = ((JSONObject)data.get("company")).getLong("id");
            int months = SystemParamterUtil.getExpectedRepaymentDate((long)companyId);
            Date payDate = null;
            try {
                if (StringUtils.isNotBlank((CharSequence)payDateString)) {
                    payDate = dateFormatter.parse(payDateString);
                }
            }
            catch (ParseException e3) {
                throw new RuntimeException(e3);
            }
            Date repaymentDate = CoreBaseBillServiceHelper.computeRepaymentDate((Date)bizDate, (Date)payDate, (long)companyId);
            data.put("repaymentdate", dateFormatter.format(repaymentDate));
        }
    }

    private boolean orgFreeze(Long orgId) {
        String selectFields = "isfreeze";
        QFilter treeTypeFilter = new QFilter("view.number", "=", (Object)"01");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{treeTypeFilter, orgFilter};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        return dynamicObject != null && dynamicObject.getBoolean("isfreeze");
    }

    private String getOneEntryCostCompanyByDeptId(long costDeptId, JSONObject jsonObjectCostCompany) {
        Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((boolean)false, (Long)costDeptId);
        DynamicObject company = BusinessDataServiceHelper.loadSingleFromCache((String)BOSORG, (String)NUMBER, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costCompanyId)});
        if (company != null) {
            jsonObjectCostCompany.put("id", company.getPkValue());
            return company.getString(NUMBER);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u7684\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d39\u7528\u627f\u62c5\u516c\u53f8\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"LoanBillImportDataOp_11", (String)"fi-er-opplugin", (Object[])new Object[0]));
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        data.put("isimport", Boolean.TRUE);
        return super.importData(data, option, importlogs);
    }

    private void handleExpenseEntry(Map<String, Object> data, JSONObject company, JSONObject costdept) {
        String errStr = "";
        Object costDeptShow = ErCommonUtils.getEMParameter((long)company.getLongValue("id"), (String)"expensesassumeshowtypes");
        JSONArray expenseentryentitys = (JSONArray)data.get("expenseentryentity");
        Set entryCostDepts = expenseentryentitys.stream().map(e -> ((JSONObject)e).get((Object)"entrycostdept") == null ? null : ((JSONObject)((JSONObject)e).get((Object)"entrycostdept")).getString(NUMBER)).filter(m -> m != null).collect(Collectors.toSet());
        Set entryCostCompanys = expenseentryentitys.stream().map(e -> ((JSONObject)e).get((Object)"entrycostcompany") == null ? null : ((JSONObject)((JSONObject)e).get((Object)"entrycostcompany")).getString(NUMBER)).filter(m -> m != null).collect(Collectors.toSet());
        if ("1".equals(costDeptShow)) {
            if (entryCostDepts.size() > 1 || entryCostDepts.size() == 1 && !entryCostDepts.contains(costdept.getString(NUMBER)) || entryCostCompanys.size() > 1 || entryCostCompanys.size() == 1 && !entryCostCompanys.contains(((JSONObject)data.get("costcompany")).getString(NUMBER))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e0e\u516c\u53f8\u5728\u5355\u5934\u5c55\u793a\uff0c\u5206\u5f55\u627f\u62c5\u90e8\u95e8\u4e0e\u516c\u53f8\u548c\u5355\u5934\u4e0d\u4e00\u81f4\u3002", (String)"LoanBillImportDataOp_27", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        } else if ("3".equals(costDeptShow) && (entryCostCompanys.size() > 1 || entryCostCompanys.size() == 1 && !entryCostCompanys.contains(((JSONObject)data.get("costcompany")).getString(NUMBER)))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u516c\u53f8\u5728\u5355\u5934\u5c55\u793a\u3001\u90e8\u95e8\u5728\u5206\u5f55\u663e\u793a\uff0c\u5206\u5f55\u8d39\u7528\u627f\u62c5\u516c\u53f8\u548c\u5355\u5934\u4e0d\u4e00\u81f4\u3002", (String)"LoanBillImportDataOp_28", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        BigDecimal approveamount = BigDecimal.ZERO;
        HashSet<String> currencySet = new HashSet<String>();
        for (JSONObject expenseentryentity : expenseentryentitys) {
            String project;
            String expenseitemedit;
            this.checkCostdept(data, expenseentryentity);
            String string = expenseitemedit = expenseentryentity.get((Object)"expenseitem") != null ? expenseentryentity.getJSONObject("expenseitem").getString(NUMBER) : null;
            if (expenseitemedit == null || "".equals(expenseitemedit)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165,\u5b57\u6bb5\u6807\u8bc6\uff1a%s", (String)"LoanBillImportDataOp_55", (String)"fi-er-opplugin", (Object[])new Object[0]), "expenseitem"));
            }
            if (!StringUtils.isEmpty((CharSequence)expenseitemedit)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_expenseitemedit", (String)"enable,isleaf", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)expenseitemedit)});
                if (dynamicObject != null && !"1".equals(dynamicObject.getString("enable"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee%s\u5df2\u7981\u7528\u3002", (String)"LoanBillImportDataOp_29", (String)"fi-er-opplugin", (Object[])new Object[0]), expenseitemedit));
                }
                if (dynamicObject != null && Boolean.FALSE.equals(dynamicObject.getBoolean("isleaf"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8d39\u7528\u9879\u76ee\u4e0d\u662f\u53f6\u5b50\u8282\u70b9\u3002", (String)"LoanBillImportDataOp_51", (String)"fi-er-opplugin", (Object[])new Object[0]), expenseitemedit));
                }
            }
            String string2 = project = expenseentryentity.get((Object)"std_project") != null ? expenseentryentity.getJSONObject("std_project").getString(NUMBER) : null;
            if (this.checkDisenable("bd_project", project)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9879\u76ee%s\u5df2\u7981\u7528\u3002", (String)"LoanBillImportDataOp_31", (String)"fi-er-opplugin", (Object[])new Object[0]), project));
            }
            if (expenseentryentity.get((Object)"remark") != null && expenseentryentity.get((Object)"remark").toString().length() > 255) {
                throw new KDBizException(ResManager.loadKDString((String)"\u501f\u6b3e\u7528\u9014\u957f\u5ea6\u8d85\u51fa\u9650\u5236\u3002", (String)"LoanBillImportDataOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            this.setExchangerateAndCurrency(data, (Map<String, Object>)expenseentryentity, "entrycurrency", "exchangerate", "expquotetype");
            if (expenseentryentity.get((Object)"entrycurrency") != null || StringUtils.isNotEmpty((CharSequence)((JSONObject)expenseentryentity.get((Object)"entrycurrency")).getString(NUMBER))) {
                currencySet.add(((JSONObject)expenseentryentity.get((Object)"entrycurrency")).getString(NUMBER));
            }
            BigDecimal expenseamount = null;
            try {
                expenseamount = new BigDecimal(expenseentryentity.get((Object)"expenseamount").toString());
            }
            catch (Exception e2) {
                errStr = data.get("detailtype") != null ? String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5%s\u91d1\u989d\u8f93\u5165\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002", (String)"LoanBillImportDataOp_32", (String)"fi-er-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7533\u8bf7", (String)"LoanBillImportDataOp_33", (String)"fi-er-opplugin", (Object[])new Object[0])) : String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5%s\u91d1\u989d\u8f93\u5165\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002", (String)"LoanBillImportDataOp_32", (String)"fi-er-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u501f\u6b3e", (String)"LoanBillImportDataOp_34", (String)"fi-er-opplugin", (Object[])new Object[0]));
                throw new KDBizException(errStr);
            }
            if (expenseamount.compareTo(BigDecimal.ZERO) <= 0) {
                if (data.get("detailtype") != null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u91d1\u989d\u5e94\u5927\u4e8e\u96f6\u3002", (String)"LoanBillImportDataOp_35", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u501f\u6b3e\u91d1\u989d\u5e94\u5927\u4e8e\u96f6\u3002", (String)"LoanBillImportDataOp_36", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            String expquotetype = expenseentryentity.getString("expquotetype");
            BigDecimal currexpenseamount = BigDecimal.ZERO;
            currexpenseamount = "1".equals(expquotetype) ? expenseamount.divide(expenseentryentity.getBigDecimal("exchangerate"), (int)((Integer)data.get(AMTPRECISION)), 4) : expenseamount.multiply((BigDecimal)expenseentryentity.get((Object)"exchangerate")).setScale((int)((Integer)data.get(AMTPRECISION)), 4);
            expenseentryentity.put("currexpenseamount", (Object)currexpenseamount);
            expenseentryentity.put("expeapproveamount", (Object)expenseamount);
            expenseentryentity.put("expeapprovecurramount", (Object)currexpenseamount);
            approveamount = approveamount.add(currexpenseamount);
            expenseentryentity.put("orgiexpebalanceamount", expenseentryentity.get((Object)"expeapproveamount"));
            expenseentryentity.put("expebalanceamount", expenseentryentity.get((Object)"expeapprovecurramount"));
            if ("G".equals(data.get("billstatus"))) {
                expenseentryentity.put("exporiusedamount", (Object)0);
                expenseentryentity.put("expusedamount", (Object)0);
                expenseentryentity.put("expeorirepayamount", (Object)0);
                expenseentryentity.put("experepayamount", (Object)0);
                expenseentryentity.put("expeorihasreimamount", (Object)0);
                expenseentryentity.put("expehasreimamount", (Object)0);
            }
            expenseentryentity.put("billstatusfield", data.get("billstatus"));
        }
        if (currencySet.size() > 1 || currencySet.size() == 1 && !currencySet.contains(((JSONObject)data.get("currency")).getString(NUMBER))) {
            data.put("iscurrency", true);
        } else {
            data.put("iscurrency", false);
        }
        data.put("approveamount", approveamount);
        data.put("loanamount", approveamount);
        data.put("notpayamount", approveamount);
        if ("G".equals(data.get("billstatus"))) {
            data.put("notpayamount", 0);
            data.put("payamount", approveamount);
            data.put("balanceamount", approveamount);
        }
    }

    private void checkCostdept(Map<String, Object> data, JSONObject expenseentryentity) {
        int showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)((JSONObject)data.get("company")).get((Object)"id")));
        if (expenseentryentity.get((Object)"entrycostdept") != null && StringUtils.isNotEmpty((CharSequence)((JSONObject)expenseentryentity.get((Object)"entrycostdept")).getString(NUMBER))) {
            DynamicObject entrycostdeptData = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_adminorg", (String)NUMBER, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)((JSONObject)expenseentryentity.get((Object)"entrycostdept")).getString(NUMBER))});
            if (entrycostdeptData == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e0d\u5b58\u5728\u6216\u5df2\u5c01\u5b58\u3002", (String)"LoanBillImportDataOp_44", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            if (this.orgFreeze((Long)entrycostdeptData.getPkValue())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e0d\u5b58\u5728\u6216\u5df2\u5c01\u5b58\u3002", (String)"LoanBillImportDataOp_44", (String)"fi-er-opplugin", (Object[])new Object[0]), ((JSONObject)expenseentryentity.get((Object)"entrycostdept")).getString(NUMBER)));
            }
        }
        if (expenseentryentity.get((Object)"entrycostcompany") != null && StringUtils.isNotEmpty((CharSequence)((JSONObject)expenseentryentity.get((Object)"entrycostcompany")).getString(NUMBER))) {
            String costCompanyNumber = ((JSONObject)expenseentryentity.get((Object)"entrycostcompany")).getString(NUMBER);
            DynamicObject costCompany = ImportUtils.getOrgByNumber((String)costCompanyNumber);
            if (costCompany == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e0d\u5b58\u5728\u6216\u5df2\u5c01\u5b58\u3002", (String)"LoanBillImportDataOp_45", (String)"fi-er-opplugin", (Object[])new Object[0]), costCompanyNumber));
            }
            if (ImportUtils.orgFreeze((Long)ErCommonUtils.getPk((Object)costCompany))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e0d\u5b58\u5728\u6216\u5df2\u5c01\u5b58\u3002", (String)"LoanBillImportDataOp_45", (String)"fi-er-opplugin", (Object[])new Object[0]), costCompanyNumber));
            }
        }
        if (expenseentryentity.get((Object)"entrycostdept") == null && expenseentryentity.get((Object)"entrycostcompany") == null) {
            expenseentryentity.put("entrycostdept", data.get("costdept"));
            expenseentryentity.put("entrycostcompany", data.get("costcompany"));
        } else if (expenseentryentity.get((Object)"entrycostdept") == null) {
            expenseentryentity.put("entrycostdept", data.get("costdept"));
        } else if (expenseentryentity.get((Object)"entrycostcompany") == null) {
            DynamicObject entryCostDept = ImportUtils.getOrgByNumber((String)((JSONObject)expenseentryentity.get((Object)"entrycostdept")).getString(NUMBER));
            Long companyID = CoreBaseBillServiceHelper.getAccountOrgId((boolean)false, (Long)ErCommonUtils.getPk((Object)entryCostDept));
            DynamicObject costCompany = BusinessDataServiceHelper.loadSingleFromCache((String)BOSORG, (String)NUMBER, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)companyID)});
            expenseentryentity.put("costcompany", (Object)ImportUtils.packageJsonObject((DynamicObject)costCompany));
        }
    }

    private void setExchangerateAndCurrency(Map<String, Object> data, Map<String, Object> item, String currencyField, String exchangerateField, String expquotetypeFile) {
        BigDecimal exchangerate = BigDecimal.ONE;
        String expquotetype = "0";
        Map<Object, Object> exchangeRateAndQuoteMap = new HashMap();
        if (item.get(exchangerateField) == null || StringUtils.isEmpty((CharSequence)item.get(exchangerateField).toString())) {
            if (item.get(currencyField) == null || StringUtils.isEmpty((CharSequence)((JSONObject)item.get(currencyField)).getString(NUMBER))) {
                item.put(currencyField, data.get("currency"));
            } else {
                String entrycurrencyNumber = ((JSONObject)item.get(currencyField)).getString(NUMBER);
                exchangeRateAndQuoteMap = this.getExchangerate(data, entrycurrencyNumber);
                exchangerate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateAndQuoteMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                expquotetype = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteMap.get("quoteType")), (Object)"0");
            }
        } else {
            if (item.get(currencyField) == null || StringUtils.isEmpty((CharSequence)((JSONObject)item.get(currencyField)).getString(NUMBER))) {
                item.put(currencyField, data.get("currency"));
            }
            String entrycurrencyNumber = ((JSONObject)item.get(currencyField)).getString(NUMBER);
            exchangeRateAndQuoteMap = this.getExchangerate(data, entrycurrencyNumber);
            try {
                exchangerate = new BigDecimal(item.get(exchangerateField).toString());
                expquotetype = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteMap.get("quoteType")), (Object)"0");
            }
            catch (Exception e) {
                logger.error("import load error info:", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u6c47\u7387\u7684\u8f93\u5165\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002", (String)"LoanBillImportDataOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        }
        item.put(exchangerateField, exchangerate);
        item.put(expquotetypeFile, expquotetype);
    }

    private void handleAccountEntry(Map<String, Object> data) throws KDBizException {
        JSONArray account = (JSONArray)data.get("accountentry");
        BigDecimal receiveamount = new BigDecimal(0);
        if (account != null && !account.isEmpty()) {
            BigDecimal approveamount;
            for (JSONObject item : (JSONObject[])account.toArray((Object[])new JSONObject[0])) {
                if (item.getString("accountcurrency") == null && data.get("detailtype") != null) {
                    item.put("accountcurrency", data.get("currency"));
                }
                this.setAccountInfoByPayer(item, item.getString("payertype"), data);
                receiveamount = receiveamount.add(item.getBigDecimal("receiveamount"));
            }
            BigDecimal receiveamountDecimal = BigDecimal.valueOf(receiveamount.doubleValue()).setScale(2, 1);
            if (receiveamountDecimal.compareTo(approveamount = new BigDecimal(data.get("approveamount").toString()).setScale(2, 1)) != 0) {
                if (data.get("detailtype") != null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u603b\u91d1\u989d\u4e0e\u7533\u8bf7\u603b\u91d1\u989d\u4e0d\u76f8\u7b49\u3002", (String)"LoanBillImportDataOp_38", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u603b\u91d1\u989d\u4e0e\u501f\u6b3e\u603b\u91d1\u989d\u4e0d\u76f8\u7b49\u3002", (String)"LoanBillImportDataOp_39", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterImportData(List<Object> pkIds, List<ImportLogger.ImportLog> importlogs) {
        super.afterImportData(pkIds, importlogs);
    }

    private void setAccountInfoByPayer(JSONObject entry, String payerType, Map<String, Object> data) {
        PayerTypeEnum payerEnum = PayerTypeEnum.getValue((String)payerType);
        String payername = entry.getString("payername");
        DynamicObject[] accountBanks = null;
        DynamicObject accountInfo = null;
        if (PayerTypeEnum.CASORG == payerEnum) {
            Map map = BusinessDataServiceHelper.loadFromCache((String)BOSORG, (String)"id,number, name, enable", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)payername)});
            if (map != null) {
                accountBanks = map.values().toArray(new DynamicObject[0]);
            }
        } else if (PayerTypeEnum.PAYER == payerEnum) {
            QFilter userFilter = new QFilter(NUMBER, "=", (Object)payername);
            DynamicObject applier = BusinessDataServiceHelper.loadSingleFromCache((String)BOSUSER, (String)"id, number, name, enable", (QFilter[])new QFilter[]{userFilter});
            if (applier == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u4e0d\u5b58\u5728", (String)"LoanBillImportDataOp_40", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            accountBanks = new DynamicObject[]{applier};
        } else if (PayerTypeEnum.CUSTOMER == payerEnum || PayerTypeEnum.SUPPLIER == payerEnum) {
            Map map;
            QFilter orgfilter = null;
            JSONObject costcompany = (JSONObject)data.get("costcompany");
            if (costcompany.getLong("id") != null) {
                orgfilter = BaseDataServiceHelper.getBaseDataFilter((String)payerType, (Long)costcompany.getLong("id"));
            }
            if ((map = orgfilter == null ? BusinessDataServiceHelper.loadFromCache((String)payerType, (String)"id, name, enable", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)payername)}) : BusinessDataServiceHelper.loadFromCache((String)payerType, (String)"id, name, enable", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)payername).and(orgfilter)})) != null) {
                accountBanks = map.values().toArray(new DynamicObject[0]);
                if (accountBanks == null || accountBanks.length == 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6536\u6b3e\u4eba\u67e5\u627e\u4e0d\u5230\u6216\u8be5\u7ec4\u7ec7\u65e0\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"LoanBillImportDataOp_50", (String)"fi-er-opplugin", (Object[])new Object[0]), payername));
                }
                accountBanks = Arrays.stream(accountBanks).filter(it -> it.getBoolean("enable")).collect(Collectors.toList()).toArray(new DynamicObject[0]);
            }
        }
        if (PayerTypeEnum.CASORG == payerEnum || PayerTypeEnum.PAYER == payerEnum || PayerTypeEnum.SUPPLIER == payerEnum || PayerTypeEnum.CUSTOMER == payerEnum) {
            if (accountBanks == null || accountBanks.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"LoanBillImportDataOp_41", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            accountInfo = accountBanks[0];
            if (this.checkBaseDataDisenable(accountInfo)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba%s\u5df2\u7981\u7528\u3002", (String)"LoanBillImportDataOp_42", (String)"fi-er-opplugin", (Object[])new Object[0]), payername));
            }
            if (PayerTypeEnum.CASORG == payerEnum) {
                JSONObject casorg = new JSONObject();
                casorg.put(NUMBER, (Object)accountInfo.getString(NUMBER));
                entry.put("casorg", (Object)casorg);
            } else if (PayerTypeEnum.SUPPLIER == payerEnum) {
                JSONObject supplier = new JSONObject();
                supplier.put(NUMBER, (Object)accountInfo.getString(NUMBER));
                entry.put("supplier", (Object)supplier);
            } else if (PayerTypeEnum.CUSTOMER == payerEnum) {
                JSONObject customer = new JSONObject();
                customer.put(NUMBER, (Object)accountInfo.getString(NUMBER));
                entry.put("customer", (Object)customer);
            } else if (PayerTypeEnum.PAYER == payerEnum) {
                JSONObject payer = new JSONObject();
                payer.put(NUMBER, entry.get((Object)"payeraccount"));
                entry.put("payer", (Object)payer);
            }
            entry.put("payername", (Object)accountInfo.getString("name"));
        }
        this.calcuReceiveamount(entry, data);
        entry.put("payeraccount02", (Object)PublicReimbursePayerAcctUtils.getHideMidPayerAccount((String)entry.getString("payeraccount")));
        entry.put("payeraccount01", (Object)PublicReimbursePayerAcctUtils.getHideTailPayerAccount((String)entry.getString("payeraccount")));
    }

    private void calcuReceiveamount(JSONObject entry, Map<String, Object> data) {
        this.setExchangerateAndCurrency(data, (Map<String, Object>)entry, "accountcurrency", "accexchangerate", "accquotetype");
        BigDecimal orireceiveamount = new BigDecimal(entry.get((Object)"orireceiveamount").toString());
        String accquotetype = entry.getString("accquotetype");
        BigDecimal receiveamount = BigDecimal.ZERO;
        receiveamount = "1".equals(accquotetype) ? orireceiveamount.divide(entry.getBigDecimal("accexchangerate"), (int)((Integer)data.get(AMTPRECISION)), 4) : orireceiveamount.multiply(entry.getBigDecimal("accexchangerate")).setScale((int)((Integer)data.get(AMTPRECISION)), 4);
        entry.put("receiveamount", (Object)receiveamount);
        entry.put("oriaccnotpayamount", (Object)orireceiveamount);
        entry.put("accnotpayamount", (Object)receiveamount);
        entry.put("oriaccbalamount", (Object)BigDecimal.ZERO);
        entry.put("accbalamount", (Object)BigDecimal.ZERO);
        entry.put("oriaccpayedamount", (Object)BigDecimal.ZERO);
        entry.put("accpayedamount", (Object)BigDecimal.ZERO);
        entry.put("buildedamount", (Object)BigDecimal.ZERO);
        if ("G".equals(data.get("billstatus"))) {
            entry.put("oriaccnotpayamount", (Object)BigDecimal.ZERO);
            entry.put("accnotpayamount", (Object)BigDecimal.ZERO);
            entry.put("oriaccbalamount", (Object)orireceiveamount);
            entry.put("accbalamount", (Object)receiveamount);
            entry.put("oriaccpayedamount", (Object)orireceiveamount);
            entry.put("accpayedamount", (Object)receiveamount);
            entry.put("buildedamount", (Object)orireceiveamount);
        }
    }

    private Map<String, Object> getExchangerate(Map<String, Object> data, String entrycurrencyNumber) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)entrycurrencyNumber), new QFilter("enable", "=", (Object)"1")});
        if (dynamicObject == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u5e01\u79cd%s\u4e0d\u5b58\u5728\u3002", (String)"LoanBillImportDataOp_43", (String)"fi-er-opplugin", (Object[])new Object[0]), entrycurrencyNumber);
            throw new KDBizException(msg);
        }
        int exchangeRateFrom = SystemParamterUtil.getExchangeRateFrom((Long)((JSONObject)data.get("company")).getLong("id"));
        Date curr = null;
        curr = 0 == exchangeRateFrom ? new Date() : (Date)data.get("bizdate");
        Map exchangeRateAndQuoteMap = CommonServiceHelper.getExchangeRateFromSysParams((Object)((JSONObject)data.get("company")).getLong("id"), (Object)((JSONObject)data.get("costcompany")).getLong("id"), (Long)((Long)dynamicObject.getPkValue()), (Long)((JSONObject)data.get("currency")).getLong("id"), (Object)curr);
        return exchangeRateAndQuoteMap;
    }

    private boolean checkDisenable(String entity, String number) {
        if (StringUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"enable", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)number)});
        return dynamicObject != null && !"1".equals(dynamicObject.getString("enable"));
    }

    private boolean checkBaseDataDisenable(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return false;
        }
        return !"1".equals(dynamicObject.getString("enable"));
    }

    private static DynamicObject getUser(Long userId) {
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectFields = "id,name,number,phone,entryentity.id,entryentity.position,entryentity.dpt,entryentity.dpt.id,entryentity.dpt.number,entryentity.ispartjob";
        return BusinessDataServiceHelper.loadSingleFromCache((String)BOSUSER, (String)selectFields, (QFilter[])qFilters);
    }

    private boolean checkBizdate(String dateStr) {
        if (dateStr != null) {
            Matcher matcher = Pattern.compile("\\d{4}-\\d{2}-\\d{2}").matcher(dateStr);
            return !matcher.matches();
        }
        return false;
    }
}

