/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily.web.importplugin.importdatahandle.importdatahandleimpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErOrgUtils;
import kd.fi.er.opplugin.daily.web.importplugin.importdatahandle.ErBillImportDataHandle;
import kd.fi.er.opplugin.daily.web.importplugin.utils.ImportUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ErBillBaseImportHandle
implements ErBillImportDataHandle {
    @Override
    public boolean handleHeadData(ImportBillData data, Iterator<ImportBillData> iterator, ImportLogger logger) {
        DynamicObject costOrg;
        JSONObject companyJson;
        Map company;
        JSONObject dataMap = data.getData();
        JSONObject applierJson = (JSONObject)dataMap.get("applier");
        if (applierJson == null) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u672a\u627e\u5230\u7533\u8bf7\u4eba\u3002", (String)"ErBillBaseImportHandle_26", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        String applierNumber = applierJson.getString("number");
        DynamicObject user = ImportUtils.getUserByNumber((String)applierNumber);
        if (user == null) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u672a\u627e\u5230", (String)"ErBillBaseImportHandle_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (!user.getBoolean("enable")) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u88ab\u7981\u7528", (String)"ErBillBaseImportHandle_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        Map userMap = ImportUtils.getUserMap((DynamicObject)user);
        applierJson.put("id", (Object)ErCommonUtils.getPk((Object)user));
        dataMap.put("tel", userMap.get("tel") == null || "".equals(userMap.get("tel")) ? "-" : userMap.get("tel"));
        dataMap.put("applierpositionstr", userMap.get("applierpositionstr"));
        JSONObject jsonOrg = (JSONObject)dataMap.get("org");
        if (jsonOrg != null && jsonOrg.getString("number") != null) {
            String orgNumber;
            Set orgNumbers = user.getDynamicObjectCollection("entryentity").stream().map(v -> v.getDynamicObject("dpt").getString("number")).collect(Collectors.toSet());
            if (!orgNumbers.contains(orgNumber = jsonOrg.getString("number"))) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u90e8\u95e8\u4e0d\u5b58\u5728\u3002", (String)"ErBillBaseImportHandle_27", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObject org = ImportUtils.getOrgByNumber((String)orgNumber);
            if (ImportUtils.orgFreeze((Long)ErCommonUtils.getPk((Object)org))) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u90e8\u95e8\u5df2\u5c01\u5b58\u3002", (String)"ErBillBaseImportHandle_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            company = OrgUnitServiceHelper.getCompanyfromOrg((Object)orgNumber);
            companyJson = ImportUtils.packageJsonObject(company.get("number"), company.get("name"));
            companyJson.put("id", company.get("id"));
            dataMap.put("company", companyJson);
            dataMap.put("companyid", company.get("id"));
        } else {
            DynamicObject dyOrg = (DynamicObject)userMap.get("org");
            JSONObject orgJson = ImportUtils.packageJsonObject((DynamicObject)dyOrg);
            dataMap.put("org", orgJson);
            Long companyID = (Long)userMap.get("company");
            if (companyID == null) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7533\u8bf7\u4eba\u516c\u53f8\u3002", (String)"ErBillBaseImportHandle_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            company = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)companyID)});
            companyJson = ImportUtils.packageJsonObject((DynamicObject)company);
            companyJson.put("id", company.getPkValue());
            dataMap.put("company", companyJson);
            dataMap.put("companyid", companyID);
        }
        JSONObject costDept = (JSONObject)dataMap.get("costdept");
        if (costDept != null) {
            String orgNumber = costDept.getString("number");
            costOrg = ImportUtils.getOrgByNumber((String)orgNumber);
            if (costOrg == null) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e0d\u5b58\u5728\u3002", (String)"ErBillBaseImportHandle_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            if (ImportUtils.orgFreeze((Long)ErCommonUtils.getPk((Object)costOrg))) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u5df2\u5c01\u5b58\u3002", (String)"ErBillBaseImportHandle_6", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            costOrg = (DynamicObject)userMap.get("costdept");
            JSONObject orgJson = ImportUtils.packageJsonObject((DynamicObject)costOrg);
            dataMap.put("costdept", orgJson);
        }
        JSONObject costCompany = (JSONObject)dataMap.get("costcompany");
        if (costCompany == null) {
            Long companyID = CoreBaseBillServiceHelper.getAccountOrgId((boolean)false, (Long)ErCommonUtils.getPk((Object)costOrg));
            DynamicObject company2 = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)companyID)});
            if (company2 == null) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5355\u5934\u7684\u201c\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u201d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d39\u7528\u627f\u62c5\u516c\u53f8\u3002", (String)"ErBillBaseImportHandle_24", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            JSONObject jsonObject = ImportUtils.packageJsonObject((DynamicObject)company2);
            jsonObject.put("id", company2.getPkValue());
            dataMap.put("costcompany", jsonObject);
        } else {
            String costCompanyNumber = costCompany.getString("number");
            DynamicObject costCompanyObject = ImportUtils.getCompany((String)costCompanyNumber);
            if (costCompanyObject == null) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5355\u5934\u7684\u201c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201d\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u5c01\u5b58\uff0c\u6216\u975e\u53f6\u5b50\u8282\u70b9\u3002", (String)"ErBillBaseImportHandle_15", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            List costcompanyNumbers = ErOrgUtils.getCostCompanySelectable((Long)ErCommonUtils.getPk((Object)costOrg), (Long)((Long)dataMap.get("companyid")));
            if (costcompanyNumbers.size() > 0 && !costcompanyNumbers.contains(costCompanyNumber)) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5355\u5934\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e0d\u5728\u9009\u62e9\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"ErBillBaseImportHandle_17", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            costCompany.put("id", costCompanyObject.getPkValue());
        }
        String msg = ImportUtils.checkCostDeptSelectInRange((long)ErCommonUtils.getPk((Object)user), (long)((Long)dataMap.get("companyid")), (long)ErCommonUtils.getPk((Object)costOrg));
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            this.fail(data.getStartIndex(), iterator, logger, msg);
        }
        JSONObject costcompany = (JSONObject)dataMap.get("costcompany");
        DynamicObject costcompanyDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)costcompany.getString("number"))});
        Long costCompanyId = (Long)costcompanyDyn.get("id");
        DynamicObject currency = BaseCurrencyServiceHelper.getBaseCurrencyObject(dataMap.get("companyid"), (Object)costCompanyId);
        if (currency == null) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"DataCopyUtils_16", (String)"fi-er-business", (Object[])new Object[0]));
            return false;
        }
        JSONObject jsonObject = ImportUtils.packageJsonObject((DynamicObject)currency);
        jsonObject.put("id", currency.getPkValue());
        jsonObject.put("amtprecision", (Object)currency.getInt("amtprecision"));
        dataMap.put("currency", jsonObject);
        dataMap.put("billstatus", "E");
        return true;
    }

    @Override
    public abstract boolean handleExpenseEntry(ImportBillData var1, Iterator<ImportBillData> var2, ImportLogger var3);

    @Override
    public boolean handleAccountEntry(ImportBillData data, Iterator<ImportBillData> iterator, ImportLogger logger) {
        JSONObject dataMap = data.getData();
        boolean isCurrency = false;
        if (dataMap.get("iscurrency") != null) {
            isCurrency = (Boolean)dataMap.get("iscurrency");
        }
        JSONArray accountEntry = (JSONArray)dataMap.get("accountentry");
        BigDecimal exchangeRate = null;
        BigDecimal reimburseAmountSum = null;
        String amountStr = (String)dataMap.get("amount");
        if (amountStr == null) {
            amountStr = (String)dataMap.get("reimburseamount");
        }
        try {
            reimburseAmountSum = new BigDecimal(amountStr);
        }
        catch (Exception e) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ErBillBaseImportHandle_7", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        BigDecimal receiveAmountSum = new BigDecimal(0L);
        for (int i = 0; i < accountEntry.size(); ++i) {
            BigDecimal orireceiveAmount;
            Map row = (Map)accountEntry.get(i);
            if (row.get("paymode") == null) {
                QFilter qFilter = new QFilter("isdefault", "=", (Object)true);
                qFilter.and(new QFilter("enable", "=", (Object)true));
                DynamicObject payMode = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)"number,name,enable", (QFilter[])new QFilter[]{qFilter});
                if (payMode != null) {
                    row.put("paymode", ImportUtils.packageJsonObject((DynamicObject)payMode));
                }
            } else {
                JSONObject jsonPaymode = (JSONObject)row.get("paymode");
                QFilter qFilter = new QFilter("number", "=", (Object)jsonPaymode.getString("number"));
                DynamicObject payMode = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)"number,name,enable", (QFilter[])new QFilter[]{qFilter});
                if (payMode != null && !payMode.getBoolean("enable")) {
                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u5df2\u7981\u7528\u3002", (String)"ErBillBaseImportHandle_8", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return false;
                }
            }
            row.putIfAbsent("payertype", "other");
            if (!isCurrency) {
                row.put("accountcurrency", dataMap.get("currency"));
                row.put("accexchangerate", "1");
                exchangeRate = new BigDecimal(1);
            } else if (row.get("accexchangerate") == null && row.get("accountcurrency") != null) {
                JSONObject currency = (JSONObject)dataMap.get("currency");
                JSONObject company = (JSONObject)dataMap.get("company");
                JSONObject accountcurrency = (JSONObject)row.get("accountcurrency");
                Date bizdate = new Date();
                if (dataMap.get("bizdate") instanceof Date) {
                    bizdate = (Date)dataMap.get("bizdate");
                }
                if (dataMap.get("bizdate") != null && dataMap.get("bizdate") instanceof String) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        bizdate = sdf.parse(String.valueOf(dataMap.get("bizdate")));
                    }
                    catch (ParseException e) {
                        this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u683c\u5f0f\u6709\u8bef\u3002", (String)"TripReimburseBillImportHandle_13", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return false;
                    }
                }
                exchangeRate = ImportUtils.getExchangeRate((String)accountcurrency.getString("number"), (String)currency.getString("number"), (String)company.getString("number"), (Date)bizdate);
                row.put("accexchangerate", exchangeRate.toString());
            } else {
                if (row.get("accountcurrency") == null) {
                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5bfc\u5165\u6c47\u7387\u4f46\u672a\u6307\u5b9a\u5e01\u79cd\u3002", (String)"ErBillBaseImportHandle_9", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return false;
                }
                try {
                    exchangeRate = new BigDecimal((String)row.get("accexchangerate"));
                }
                catch (NumberFormatException e) {
                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u683c\u5f0f\u7684\u6c47\u7387\u3002", (String)"ErBillBaseImportHandle_25", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return false;
                }
            }
            String orireceiveAmountStr = (String)row.get("orireceiveamount");
            try {
                orireceiveAmount = new BigDecimal(orireceiveAmountStr);
            }
            catch (Exception e) {
                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u683c\u5f0f\u7684\u6536\u6b3e\u91d1\u989d\u3002", (String)"ErBillBaseImportHandle_11", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
            BigDecimal receiveAmount = orireceiveAmount.multiply(exchangeRate);
            receiveAmountSum = receiveAmountSum.add(receiveAmount);
            row.put("receiveamount", receiveAmount);
            row.put("oriaccnotpayamount", orireceiveAmount);
            row.put("accnotpayamount", orireceiveAmount.multiply(exchangeRate));
        }
        if (receiveAmountSum.setScale(10, 4).compareTo(reimburseAmountSum.setScale(10, 4)) != 0) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u4e0d\u7b49\u4e8e\u62a5\u9500\u91d1\u989d\u3002", (String)"ErBillBaseImportHandle_12", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        dataMap.put("encashamount", receiveAmountSum);
        dataMap.put("isimport", Boolean.TRUE);
        return true;
    }
}

