/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily.web.importplugin.importdatahandle.importdatahandleimpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.opplugin.daily.web.importplugin.importdatahandle.importdatahandleimpl.ErBillBaseImportHandle;
import kd.fi.er.opplugin.daily.web.importplugin.utils.ImportUtils;
import org.apache.commons.lang3.StringUtils;

public class ErDailyApplyBillImportHandle
extends ErBillBaseImportHandle {
    @Override
    public boolean handleHeadData(ImportBillData data, Iterator<ImportBillData> iterator, ImportLogger logger) {
        if (super.handleHeadData(data, iterator, logger)) {
            JSONObject dataMap = data.getData();
            dataMap.put("billstatus", "A");
            return true;
        }
        return false;
    }

    @Override
    public boolean handleExpenseEntry(ImportBillData data, Iterator<ImportBillData> iterator, ImportLogger logger) {
        JSONObject dataMap = data.getData();
        JSONArray expenseEntry = (JSONArray)dataMap.get((Object)"expenseentryentity");
        if (expenseEntry.isEmpty()) {
            return false;
        }
        String entityName = data.getEntityMapping().getEntityType().getName();
        int costOrgShowTypes = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)dataMap.get((Object)"companyid")));
        BigDecimal amount = new BigDecimal(0);
        for (int i = 0; i < expenseEntry.size(); ++i) {
            BigDecimal exchangeRate;
            JSONObject currency;
            BigDecimal expenseAmount;
            Map row;
            block17: {
                row = (Map)expenseEntry.get(i);
                JSONObject expenseitem = (JSONObject)row.get("expenseitem");
                if (!ImportUtils.isenableExpenseItem((String)expenseitem.getString("number"), (String)entityName)) {
                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u4e0d\u53ef\u7528\uff0c\u53ef\u80fd\u539f\u56e0\uff1a\u8d39\u7528\u9879\u76ee\u88ab\u7981\u7528\uff0c\u6216\u4e3a\u975e\u53f6\u5b50\u8282\u70b9\uff0c\u6216\u5f53\u524d\u5355\u636e\u4e0d\u53ef\u7528\u3002", (String)"ReimburseBillImportHandle_19", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return false;
                }
                JSONObject entryCostDept = (JSONObject)row.get("entrycostdept");
                if (entryCostDept == null || entryCostDept.get((Object)"number") == null || costOrgShowTypes == 1) {
                    row.put("entrycostdept", dataMap.get((Object)"costdept"));
                    row.put("entrycostcompany", dataMap.get((Object)"costcompany"));
                } else if (entryCostDept != null) {
                    String orgNumber = entryCostDept.getString("number");
                    DynamicObject org = ImportUtils.getOrgByNumber((String)orgNumber);
                    if (org == null) {
                        this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e0d\u5b58\u5728\u3002", (String)"ReimburseBillImportHandle_32", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return false;
                    }
                    Long companyID = CoreBaseBillServiceHelper.getAccountOrgId((boolean)false, (Long)ErCommonUtils.getPk((Object)org));
                    DynamicObject company = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)companyID)});
                    row.put("entrycostcompany", ImportUtils.packageJsonObject((DynamicObject)company));
                }
                try {
                    expenseAmount = new BigDecimal((String)row.get("expenseamount"));
                }
                catch (Exception e) {
                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ReimburseBillImportHandle_20", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return false;
                }
                currency = (JSONObject)dataMap.get((Object)"currency");
                JSONObject entryCurrency = (JSONObject)row.get("entrycurrency");
                exchangeRate = new BigDecimal(1);
                if (entryCurrency != null) {
                    if (!entryCurrency.get((Object)"number").equals(currency.get((Object)"number"))) {
                        dataMap.put("iscurrency", (Object)true);
                    } else {
                        dataMap.put("iscurrency", (Object)false);
                    }
                    String exchangeRateStr = (String)row.get("exchangerate");
                    if (!StringUtils.isBlank((CharSequence)exchangeRateStr)) {
                        try {
                            exchangeRate = new BigDecimal(exchangeRateStr);
                            if (exchangeRate.compareTo(new BigDecimal(0)) < 0) {
                                throw new IllegalArgumentException();
                            }
                            break block17;
                        }
                        catch (Exception e) {
                            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u6c47\u7387\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ReimburseBillImportHandle_33", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                    }
                    exchangeRate = ImportUtils.getExchangeRate((String)entryCurrency.getString("number"), (String)currency.getString("number"), (String)((JSONObject)dataMap.get((Object)"company")).getString("number"), (Date)dataMap.getDate("bizdate"));
                } else {
                    row.put("entrycurrency", currency);
                }
            }
            row.put("exchangerate", exchangeRate);
            BigDecimal expenseOriAmount = expenseAmount.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision((String)currency.getString("number")), RoundingMode.HALF_EVEN);
            row.put("currexpenseamount", expenseOriAmount.toString());
            row.put("expeapproveamount", expenseAmount.toString());
            row.put("expeapprovecurramount", expenseOriAmount.toString());
            row.put("orgiexpebalanceamount", expenseAmount.toString());
            row.put("expebalanceamount", expenseOriAmount.toString());
            row.put("canloanamount", expenseAmount.toString());
            row.put("canloancurramount", expenseOriAmount.toString());
            amount = amount.add(expenseOriAmount);
            row.put("orientryamount", expenseAmount);
        }
        String amountStr = amount.toString();
        dataMap.put("applyamount", (Object)amountStr);
        dataMap.put("approveamount", (Object)amountStr);
        dataMap.put("notpayamount", (Object)amountStr);
        dataMap.put("payamount", (Object)amountStr);
        dataMap.put("balanceamount", (Object)amountStr);
        dataMap.put("billcanloanamount", (Object)amountStr);
        return true;
    }
}

