/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.invoicecloud;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.OperateUtils;

public class InvoiceChangeOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(InvoiceChangeOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String opKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet statusSet = Sets.newHashSet((Object[])new String[]{"save", "audit", "submit"});
        if (statusSet.contains(opKey.toLowerCase())) {
            for (DynamicObject dataEntity : dataEntities) {
                IDataEntityType entityType = dataEntity.getDataEntityType();
                DataEntityPropertyCollection properties = entityType.getProperties();
                if (properties.get((Object)"invoiceentry") != null && properties.get((Object)"invoiceoffsetamount") != null) {
                    BigDecimal invoiceOffsetAmount = BigDecimal.ZERO;
                    DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
                    if (!invoiceEntry.isEmpty()) {
                        invoiceOffsetAmount = invoiceEntry.stream().map(invoice -> invoice.getBigDecimal("offsetamount")).reduce(BigDecimal::add).get();
                    }
                    log.info("invoiceoffsetamount:" + invoiceOffsetAmount);
                    dataEntity.set("invoiceoffsetamount", (Object)invoiceOffsetAmount);
                }
                if (properties.get((Object)"totaloffsetamount") == null) continue;
                BigDecimal totalOffsetAmount = BigDecimal.ZERO;
                if (properties.get((Object)"tripentry") != null) {
                    DynamicObjectCollection tripEntry = dataEntity.getDynamicObjectCollection("tripentry");
                    DynamicObjectType tripDynamicType = tripEntry.getDynamicObjectType();
                    if (tripDynamicType.getProperty("entryentity") != null) {
                        List allEntryEntity = tripEntry.stream().flatMap(trip -> trip.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
                        if (!allEntryEntity.isEmpty()) {
                            totalOffsetAmount = allEntryEntity.stream().map(expenseEntity -> expenseEntity.getBigDecimal("deductibletax")).reduce(BigDecimal::add).get();
                        }
                        dataEntity.set("totaloffsetamount", (Object)totalOffsetAmount);
                    }
                } else if (properties.get((Object)"expenseentryentity") != null) {
                    DynamicObjectCollection expenseEntryEntity = dataEntity.getDynamicObjectCollection("expenseentryentity");
                    if (!expenseEntryEntity.isEmpty()) {
                        totalOffsetAmount = expenseEntryEntity.stream().map(expenseEntity -> expenseEntity.getBigDecimal("deductibletax")).reduce(BigDecimal::add).get();
                    }
                    dataEntity.set("totaloffsetamount", (Object)totalOffsetAmount);
                }
                log.info("invoiceoffsetamount:" + totalOffsetAmount);
            }
        }
    }
}

