/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.invoicecloud.checkingpay;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.util.StringUtils;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;

public class DifferentTaxPlugin
extends AbstractOperationServicePlugIn {
    private static final String ENTRYENTITY = "entryentity";
    private static final String INVOICEENTRY = "invoiceentry";
    private static final String OPERATIONTYPE = "operationtype";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add(OPERATIONTYPE);
        list.add("differenttax");
        list.add("entryentity.serviceitem");
        list.add("entryentity.actentryamount");
        list.add("entryentity.taxamount");
        list.add("invoiceentry.invoicetype");
        list.add("invoiceentry.offsetamount");
        list.add("invoiceentry.totalamount");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject d : e.getDataEntities()) {
            BigDecimal offsetamount;
            BigDecimal totalAmount;
            String paramStr = TripSyncConfigUtil.getTripsyncSettingByKey((String)"invoice_deductibleTax_difference");
            if (StringUtils.isEmpty((String)paramStr)) {
                return;
            }
            List<String> invoiceTypes = Arrays.asList(paramStr.split(","));
            BigDecimal differenttax = BigDecimal.ZERO;
            if (Arrays.asList("1", "5", "3").contains(d.getString(OPERATIONTYPE))) {
                totalAmount = this.getSumAmount(d.getDynamicObjectCollection(INVOICEENTRY).stream().filter(m -> invoiceTypes.contains(m.getString("invoicetype"))), "totalamount");
                offsetamount = this.getSumAmount(d.getDynamicObjectCollection(INVOICEENTRY).stream(), "offsetamount");
                BigDecimal actentryamount = this.getSumAmount(d, ENTRYENTITY, "actentryamount");
                if (totalAmount.compareTo(actentryamount) == 0) {
                    BigDecimal taxamount = this.getSumAmount(d, ENTRYENTITY, "taxamount");
                    differenttax = offsetamount.subtract(taxamount);
                }
            } else if (Arrays.asList("2", "4", "6").contains(d.getString(OPERATIONTYPE))) {
                totalAmount = this.getSumAmount(d.getDynamicObjectCollection(INVOICEENTRY).stream().filter(m -> invoiceTypes.contains(m.getString("invoicetype"))), "totalamount");
                offsetamount = this.getSumAmount(d.getDynamicObjectCollection(INVOICEENTRY).stream().filter(m -> invoiceTypes.contains(m.getString("invoicetype"))), "offsetamount");
                Stream<DynamicObject> serviceStream = d.getDynamicObjectCollection(ENTRYENTITY).stream().filter(m -> "SERVICE".equals(m.getString("serviceitem")));
                BigDecimal serviceAmount = this.getSumAmount(serviceStream, "actentryamount");
                if (totalAmount.compareTo(serviceAmount) == 0) {
                    BigDecimal taxamount = this.getSumAmount(d.getDynamicObjectCollection(ENTRYENTITY).stream().filter(m -> "SERVICE".equals(m.getString("serviceitem"))), "taxamount");
                    differenttax = offsetamount.subtract(taxamount);
                }
            }
            d.set("differenttax", (Object)differenttax);
        }
    }

    private BigDecimal getSumAmount(DynamicObject d, String entryName, String field) {
        return d.getDynamicObjectCollection(entryName).stream().filter(m -> m.getBigDecimal(field) != null).map(n -> n.getBigDecimal(field)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getSumAmount(Stream<DynamicObject> stream, String field) {
        return stream.filter(m -> m.getBigDecimal(field) != null).map(n -> n.getBigDecimal(field)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

