/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.invoicecloud.kingdee;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceStatusEnum;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.opplugin.invoicecloud.kingdee.BillOpPlugin;
import org.apache.commons.lang3.ObjectUtils;

public class BillSavePlugin
extends BillOpPlugin {
    private static Log logger = LogFactory.getLog(BillSavePlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("is_all_einvoice");
        list.add("noinvoice");
        list.add("invoicetype");
        list.add("needimagescan");
        list.add("expenseitem");
        list.add("invoicefrom");
        list.add("billstatus");
        list.add("payamount");
        list.add("encashamount");
        list.add("expenseentryentity");
        list.add("invoiceentry");
        list.add("accountentry");
        list.add("tripentry");
        list.add("tripentry.entryentity");
        list.add("automapinvoice");
    }

    @Override
    protected InvoiceStatusEnum getTargetStatus() {
        return InvoiceStatusEnum.submitted;
    }

    @Override
    protected InvoiceStatusEnum getRollbackStatus(DynamicObject dataEntity) {
        boolean isAddNew;
        String billStatus = dataEntity.getString("billstatus");
        if (ErBillStatusEnum.C.toString().equals(billStatus)) {
            return InvoiceStatusEnum.submitted;
        }
        boolean bl = isAddNew = !dataEntity.getDataEntityState().getFromDatabase();
        if (isAddNew) {
            return InvoiceStatusEnum.unused;
        }
        return InvoiceStatusEnum.submitted;
    }

    @Override
    protected String getOpDesc() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"BillSavePlugin_5", (String)"fi-er-opplugin", (Object[])new Object[0]);
    }

    @Override
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Map<Object, DynamicObject> oldEntitiesMap = Stream.of(dataEntities).filter(o -> o.getDataEntityState().getFromDatabase()).collect(Collectors.toMap(DataEntityBase::getPkValue, a -> a));
        Set<Object> pkSet = oldEntitiesMap.keySet();
        if (pkSet.isEmpty()) {
            return;
        }
        if (dataEntities != null && dataEntities.length == 1) {
            InvoiceUtils.outLogInfo((DynamicObject)dataEntities[0]);
            InvoiceUtils.outLogInfo(pkSet, (MainEntityType)this.billEntityType);
        }
        Map oldBillMap = this.oldBillMap;
        for (DynamicObject dataEntity : oldEntitiesMap.values()) {
            DynamicObject oldBill = (DynamicObject)oldBillMap.get(dataEntity.getLong("id"));
            if (oldBill == null) continue;
            boolean hasInvoiceEntry = dataEntity.getDynamicObjectType().getProperty("invoiceentry") != null;
            Set oldSerialNos = hasInvoiceEntry ? oldBill.getDynamicObjectCollection("invoiceentry").stream().map(v -> v.getString("serialno")).collect(Collectors.toSet()) : Collections.emptySet();
            Set newSerialNos = hasInvoiceEntry ? dataEntity.getDynamicObjectCollection("invoiceentry").stream().map(v -> v.getString("serialno")).collect(Collectors.toSet()) : Collections.emptySet();
            HashSet diff = new HashSet(oldSerialNos);
            diff.removeAll(newSerialNos);
            logger.info(String.format("\u6570\u636e\u5e93\u4fdd\u5b58\u7684\u65e7\u53d1\u7968\u4fe1\u606f\u662f:%s, \u5373\u5c06\u4fdd\u5b58\u7684\u65b0\u6570\u636e\u53d1\u7968\u4fe1\u606f:%s, \u88ab\u5220\u9664\u7684\u53d1\u7968\u4fe1\u606f\uff1a%s", ObjectUtils.defaultIfNull(oldSerialNos, Collections.emptySet()), ObjectUtils.defaultIfNull(newSerialNos, Collections.emptySet()), diff));
        }
    }
}

