/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.publicbiz.bill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.validator.invoicecloud.checkInvoice.ReimSubmitCheckInvoiceValidator;
import org.apache.commons.lang3.StringUtils;

public class RedOffsetOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(RedOffsetOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new RedOffsetValidator());
        e.addValidator((AbstractValidator)new ReimSubmitCheckInvoiceValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            BigDecimal payedAmount = dataEntity.getBigDecimal("payedamount");
            BigDecimal payAmount = dataEntity.getBigDecimal("payamount");
            BigDecimal notPayAmount = dataEntity.getBigDecimal("notpayamount");
            if (payAmount.compareTo(payedAmount) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u73b0\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u5df2\u4ed8\u91d1\u989d\u3002", (String)"ErConfirmStopReimOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection accEntry = dataEntity.getDynamicObjectCollection("accountentry");
            if (accEntry != null && accEntry.size() > 0) {
                for (int i = 0; i < accEntry.size(); ++i) {
                    if (((DynamicObject)accEntry.get(i)).getBigDecimal("accnotpayamount").compareTo(BigDecimal.ZERO) != 0) continue;
                    ((DynamicObject)accEntry.get(i)).set("billstatusfield", (Object)"G");
                }
            }
            if (payedAmount.compareTo(BigDecimal.ZERO) > 0 && notPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                dataEntity.set("billstatus", (Object)"G");
            }
            dataEntity.set("isredoffset", (Object)true);
            InvoiceUtils.unbindInvoiceAefTicket((DynamicObject)dataEntity);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            String billstatus = dataEntity.getString("billstatus");
            Object[] pKids = Arrays.stream(new DynamicObject[]{dataEntity}).map(v -> v.getPkValue()).toArray(Object[]::new);
            OperateOption option = OperateOption.create();
            if (!"G".equals(billstatus)) continue;
            logger.info("\u51fa\u7eb3\u96c6\u6210,\u8d39\u7528\u62a5\u9500\u5355/\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u5f00\u59cb,\u8d39\u7528\u62a5\u9500\u5355/\u5bf9\u516c\u62a5\u9500\u5355ids:" + Arrays.toString(pKids));
            String billtype = dataEntity.getDataEntityType().getName();
            if (StringUtils.isEmpty((CharSequence)billtype)) continue;
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)billtype, (Object[])pKids, (OperateOption)option);
            if (operationResult.isSuccess()) {
                logger.info("\u51fa\u7eb3\u96c6\u6210,\u8d39\u7528\u62a5\u9500\u5355/\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u6761\u76ee\u6210\u529f");
                continue;
            }
            ValidateResultCollection validateResult = operationResult.getValidateResult();
            logger.info("\u51fa\u7eb3\u96c6\u6210,\u8d39\u7528\u62a5\u9500\u5355/\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u6761\u76ee\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
        }
    }

    static class RedOffsetValidator
    extends AbstractValidator {
        RedOffsetValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] billsExtendedDataEntity;
            for (ExtendedDataEntity billExtendedDataEntity : billsExtendedDataEntity = this.getDataEntities()) {
                DynamicObjectCollection accEntry;
                BigDecimal accEntryTotalPayAmount;
                BigDecimal payAmount;
                DynamicObject bill = billExtendedDataEntity.getDataEntity();
                DynamicObjectCollection exps = bill.getDynamicObjectCollection("expenseentryentity");
                if (exps != null && exps.size() > 0) {
                    BigDecimal approveamount = AmountUtils.getEntryAmount((DynamicObjectCollection)exps, (String)"expeapprovecurramount").abs();
                    BigDecimal redoffsetamount = exps.stream().filter(m -> m.getBoolean("expisredoffset")).map(n -> n.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal.ZERO, BigDecimal::add).abs();
                    BigDecimal noredoffsetamount = exps.stream().filter(m -> !m.getBoolean("expisredoffset")).map(n -> n.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal.ZERO, BigDecimal::add).abs();
                    BigDecimal expeapproveamount = AmountUtils.getEntryAmount((DynamicObjectCollection)exps, (String)"expeapproveamount");
                    BigDecimal expenseamount = AmountUtils.getEntryAmount((DynamicObjectCollection)exps, (String)"expenseamount");
                    if (noredoffsetamount.compareTo(redoffsetamount) < 0) {
                        this.addErrorMessage(billExtendedDataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8d85\u989d\u7ea2\u51b2\u3002", (String)"PublicReimListPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (noredoffsetamount.compareTo(approveamount) < 0) {
                        this.addErrorMessage(billExtendedDataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8d85\u989d\u7ea2\u51b2\u3002", (String)"PublicReimListPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (expenseamount.compareTo(expeapproveamount) < 0) {
                        this.addErrorMessage(billExtendedDataEntity, ResManager.loadKDString((String)"\u6838\u5b9a\u91d1\u989d\u603b\u8ba1\u4e0d\u5f97\u8d85\u51fa\u62a5\u9500\u91d1\u989d\u603b\u8ba1\u3002", (String)"PublicReimListPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                if ((payAmount = bill.getBigDecimal("payamount")).compareTo(accEntryTotalPayAmount = (accEntry = bill.getDynamicObjectCollection("accountentry")).stream().map(row -> row.getBigDecimal("receiveamount")).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
                    this.addErrorMessage(billExtendedDataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u7d2f\u8ba1\u91d1\u989d\u4e0d\u7b49\u4e8e\u4ed8\u73b0\u91d1\u989d\u3002", (String)"ReimburseBillSubmitValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (accEntry == null || accEntry.size() <= 0) continue;
                for (int i = 0; i < accEntry.size(); ++i) {
                    if (((DynamicObject)accEntry.get(i)).getBigDecimal("receiveamount").compareTo(((DynamicObject)accEntry.get(i)).getBigDecimal("accpayedamount")) >= 0) continue;
                    this.addErrorMessage(billExtendedDataEntity, String.format(ResManager.loadKDString((String)"\"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\"\u7b2c%1$s\u884c\u6536\u6b3e\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u5df2\u4ed8\u91d1\u989d\u3002", (String)"ErConfirmStopReimOp_5", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1));
                    return;
                }
            }
        }
    }
}

