/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.publicbiz.bill.importhandle;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.ExchangeRateService;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.OrgServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.opplugin.daily.web.importplugin.importdatahandle.ErBillImportDataHandle;
import kd.fi.er.opplugin.daily.web.importplugin.utils.ImportUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ErPubBillInitImportBaseHandle
implements ErBillImportDataHandle {
    private static Log logger = LogFactory.getLog(ErPubBillInitImportBaseHandle.class);
    private static final List<String> entrywltypelist = Arrays.asList("bd_supplier", "bd_customer", "bos_user", "bos_org");
    private static final List<Object> billstatuslist = Arrays.asList("A", "E");

    @Override
    public boolean handleHeadData(ImportBillData data, Iterator<ImportBillData> iterator, ImportLogger logger) {
        JSONObject dataMap = data.getData();
        String errMsg = this.handleCommonHeadData((Map<String, Object>)dataMap);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            this.fail(data.getStartIndex(), iterator, logger, errMsg);
            return false;
        }
        errMsg = this.handleCustomHeadData((Map<String, Object>)dataMap);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            this.fail(data.getStartIndex(), iterator, logger, errMsg);
            return false;
        }
        return true;
    }

    @Override
    public boolean handleExpenseEntry(ImportBillData data, Iterator<ImportBillData> iterator, ImportLogger logger) {
        JSONObject dataMap = data.getData();
        boolean needInput = this.isMustInput(data, "expenseentryentity", "expenseitem");
        dataMap.put("expenseitemMustInput", needInput);
        String errMsg = this.handleCommonEntryData((Map<String, Object>)dataMap);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            int startIndex = data.getStartIndex();
            if (dataMap.get("currIndex") != null) {
                startIndex += Integer.parseInt(String.valueOf(dataMap.get("currIndex")));
            }
            this.fail(startIndex, iterator, logger, errMsg);
            return false;
        }
        needInput = this.isMustInput(data, "expenseentryentity", "entrywltype");
        dataMap.put("entrywltypeMustInput", needInput);
        errMsg = this.handleCustomEntryData((Map<String, Object>)dataMap);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            this.fail(data.getStartIndex(), iterator, logger, errMsg);
            return false;
        }
        return true;
    }

    @Override
    public boolean handleAccountEntry(ImportBillData data, Iterator<ImportBillData> iterator, ImportLogger logger) {
        return false;
    }

    protected String handleCommonHeadData(Map<String, Object> dataMap) {
        DynamicObject costCompany;
        Long companyId;
        JSONObject applier = (JSONObject)dataMap.get("applier");
        if (null == applier || !applier.containsKey((Object)"number")) {
            return ResManager.loadKDString((String)"\u7ecf\u529e\u4eba\u4e0d\u5b58\u5728\u3002", (String)"EM-W-068755", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        String applierNumber = applier.getString("number");
        DynamicObject user = ImportUtils.getUserByNumber((String)applierNumber);
        if (user == null) {
            return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7ecf\u529e\u4eba\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_0", (String)"fi-er-opplugin", (Object[])new Object[0]), applierNumber);
        }
        if (!user.getBoolean("enable")) {
            return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u8bf7\u4eba\u88ab\u7981\u7528\u3002", (String)"ErPubBillInitImportBaseHandle_1", (String)"fi-er-opplugin", (Object[])new Object[0]), applierNumber);
        }
        Map userMap = ImportUtils.getUserMap((DynamicObject)user);
        dataMap.put("tel", userMap.get("tel"));
        dataMap.put("applierpositionstr", userMap.get("applierpositionstr"));
        JSONObject orgJsonObject = (JSONObject)dataMap.get("org");
        if (orgJsonObject != null && orgJsonObject.getString("number") != null) {
            String orgNumber;
            Set orgNumbers = user.getDynamicObjectCollection("entryentity").stream().map(v -> v.getDynamicObject("dpt").getString("number")).collect(Collectors.toSet());
            if (!orgNumbers.contains(orgNumber = orgJsonObject.getString("number"))) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u8bf7\u4eba\u90e8\u95e8\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_2", (String)"fi-er-opplugin", (Object[])new Object[0]), applierNumber);
            }
            DynamicObject org = ImportUtils.getOrgByNumber((String)orgNumber);
            if (ImportUtils.orgFreeze((Long)ErCommonUtils.getPk((Object)org))) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u8bf7\u4eba\u90e8\u95e8\u5df2\u5c01\u5b58\u3002", (String)"ErPubBillInitImportBaseHandle_3", (String)"fi-er-opplugin", (Object[])new Object[0]), applierNumber);
            }
            companyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)ErCommonUtils.getPk((Object)org));
        } else {
            DynamicObject orgDy = (DynamicObject)userMap.get("org");
            orgJsonObject = ImportUtils.packageJsonObject((DynamicObject)orgDy);
            dataMap.put("org", orgJsonObject);
            companyId = (Long)userMap.get("company");
        }
        DynamicObject company = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)companyId)});
        JSONObject jsonObjectCompany = new JSONObject();
        jsonObjectCompany = ImportUtils.packageJsonObject((DynamicObject)company);
        dataMap.put("company", jsonObjectCompany);
        jsonObjectCompany.put("id", company.get("id"));
        JSONObject costDept = (JSONObject)dataMap.get("costdept");
        DynamicObject costOrg = null;
        if (costDept != null) {
            String orgNumber = costDept.getString("number");
            costOrg = ImportUtils.getOrgByNumber((String)orgNumber);
            if (costOrg == null) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_7", (String)"fi-er-opplugin", (Object[])new Object[0]), orgNumber);
            }
            if (ImportUtils.orgFreeze((Long)ErCommonUtils.getPk((Object)costOrg))) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u5df2\u5c01\u5b58\u3002", (String)"ErPubBillInitImportBaseHandle_8", (String)"fi-er-opplugin", (Object[])new Object[0]), orgNumber);
            }
        } else {
            costOrg = (DynamicObject)userMap.get("org");
            orgJsonObject = ImportUtils.packageJsonObject((DynamicObject)costOrg);
            dataMap.put("costdept", orgJsonObject);
        }
        Long costCompanyId = null;
        JSONObject costCompanyJson = (JSONObject)dataMap.get("costcompany");
        JSONObject companyJson = null;
        if (costCompanyJson != null && StringUtils.isNotBlank((CharSequence)costCompanyJson.getString("number"))) {
            String orgNumber = costCompanyJson.getString("number");
            costCompany = ImportUtils.getOrgByNumber((String)orgNumber);
            if (costCompany == null) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_4", (String)"fi-er-opplugin", (Object[])new Object[0]), orgNumber);
            }
            if (ImportUtils.orgFreeze((Long)ErCommonUtils.getPk((Object)costCompany), (String)"10")) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u7ec4\u7ec7\u5df2\u5c01\u5b58\u3002", (String)"ErPubBillInitImportBaseHandle_5", (String)"fi-er-opplugin", (Object[])new Object[0]), orgNumber);
            }
            boolean accountingOrg = OrgServiceHelper.isAccountingOrg((String)orgNumber);
            if (!accountingOrg) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u7ec4\u7ec7\u7684\u804c\u80fd\u4e0d\u662f\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ErPubBillInitImportBaseHandle_17", (String)"fi-er-opplugin", (Object[])new Object[0]), orgNumber);
            }
            companyJson = ImportUtils.packageJsonObject((DynamicObject)costCompany);
            costCompanyId = (Long)costCompany.get("id");
            companyJson.put("id", (Object)costCompanyId);
            dataMap.put("costcompany", companyJson);
        } else {
            Long companyID = CoreBaseBillServiceHelper.getAccountOrgId((boolean)false, (Long)ErCommonUtils.getPk((Object)costOrg));
            costCompany = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)companyID)});
            DynamicObject dept = null;
            JSONObject deptJson = (JSONObject)dataMap.get("org");
            if (deptJson != null && StringUtils.isNotBlank((CharSequence)deptJson.getString("number"))) {
                String deptNumber = deptJson.getString("number");
                dept = ImportUtils.getOrgByNumber((String)deptNumber);
            } else {
                dept = (DynamicObject)userMap.get("org");
            }
            Long deptId = (Long)dept.getPkValue();
            costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((Long)deptId);
            companyJson = ImportUtils.packageJsonObject((DynamicObject)costCompany);
            companyJson.put("id", costCompany.getPkValue());
            dataMap.put("costcompany", companyJson);
        }
        DynamicObject currency = BaseCurrencyServiceHelper.getBaseCurrencyObject((Object)companyId, (Object)costCompanyId);
        if (currency == null) {
            return ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u4e3a\u7a7a", (String)"ErPubBillInitImportBaseHandle_24", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        JSONObject jsonCurr = ImportUtils.packageJsonObject((DynamicObject)currency);
        jsonCurr.put("id", currency.get("id"));
        jsonCurr.put("amtprecision", (Object)currency.getInt("amtprecision"));
        dataMap.put("currency", jsonCurr);
        return null;
    }

    protected String handleCustomHeadData(Map<String, Object> dataMap) {
        return null;
    }

    protected String handleCommonEntryData(Map<String, Object> dataMap) {
        JSONArray expenseEntry = (JSONArray)dataMap.get("expenseentryentity");
        String headCurrencyNumber = ((JSONObject)dataMap.get("currency")).getString("number");
        HashSet<String> entryCurrencySet = new HashSet<String>(expenseEntry != null ? expenseEntry.size() : 0);
        Object frameworkcontractobj = dataMap.get("frameworkcontract");
        Boolean frameworkcontract = Boolean.FALSE;
        if (frameworkcontractobj != null) {
            frameworkcontract = (Boolean)dataMap.get("frameworkcontract");
        }
        if (!frameworkcontract.booleanValue() && expenseEntry != null) {
            for (int i = 0; i < expenseEntry.size(); ++i) {
                Date bizdate;
                JSONObject entryCurrency;
                String entryCurrencyNumber;
                DynamicObject currencyDy;
                JSONObject expenseitem;
                dataMap.put("currIndex", i);
                Map row = (Map)expenseEntry.get(i);
                JSONObject entryCostCompany = (JSONObject)row.get("entrycostcompany");
                JSONObject entryCostDept = (JSONObject)row.get("entrycostdept");
                if (entryCostCompany == null || entryCostCompany.get((Object)"number") == null) {
                    row.put("entrycostcompany", dataMap.get("costcompany"));
                } else {
                    String entryCostCompanyNumber = entryCostCompany.getString("number");
                    DynamicObject costCompanyOrg = ImportUtils.getOrgByNumber((String)entryCostCompanyNumber);
                    if (costCompanyOrg == null) {
                        return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_4", (String)"fi-er-opplugin", (Object[])new Object[0]), entryCostCompanyNumber);
                    }
                    if (ImportUtils.orgFreeze((Long)ErCommonUtils.getPk((Object)costCompanyOrg), (String)"10")) {
                        return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u7ec4\u7ec7\u5df2\u5c01\u5b58\u3002", (String)"ErPubBillInitImportBaseHandle_5", (String)"fi-er-opplugin", (Object[])new Object[0]), entryCostCompanyNumber);
                    }
                    boolean accountingOrg = OrgServiceHelper.isAccountingOrg((String)entryCostCompanyNumber);
                    if (!accountingOrg) {
                        return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u7ec4\u7ec7\u7684\u804c\u80fd\u4e0d\u662f\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ErPubBillInitImportBaseHandle_17", (String)"fi-er-opplugin", (Object[])new Object[0]), entryCostCompanyNumber);
                    }
                }
                if (entryCostDept == null || entryCostDept.get((Object)"number") == null) {
                    row.put("entrycostdept", dataMap.get("org"));
                } else {
                    String entryCostDeptNumber = entryCostDept.getString("number");
                    DynamicObject costDeptOrg = ImportUtils.getOrgByNumber((String)entryCostDeptNumber);
                    if (costDeptOrg == null) {
                        return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_7", (String)"fi-er-opplugin", (Object[])new Object[0]), entryCostDeptNumber);
                    }
                    if (ImportUtils.orgFreeze((Long)ErCommonUtils.getPk((Object)costDeptOrg))) {
                        return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u5df2\u5c01\u5b58\u3002", (String)"ErPubBillInitImportBaseHandle_8", (String)"fi-er-opplugin", (Object[])new Object[0]), entryCostDeptNumber);
                    }
                }
                boolean needInput = false;
                if (dataMap.containsKey("expenseitemMustInput") && null != dataMap.get("expenseitemMustInput")) {
                    needInput = (Boolean)dataMap.get("expenseitemMustInput");
                }
                if ((expenseitem = (JSONObject)row.get("expenseitem")) == null && needInput) {
                    return ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ErPubBillInitImportBaseHandle_9", (String)"fi-er-opplugin", (Object[])new Object[0]);
                }
                if (null != expenseitem) {
                    String expenseitemnumber = expenseitem.getString("number");
                    DynamicObject expenseitemDy = BusinessDataServiceHelper.loadSingleFromCache((String)"er_expenseitemedit", (String)"enable,isleaf", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)expenseitemnumber)});
                    if (expenseitemDy == null) {
                        return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8d39\u7528\u9879\u76ee\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_10", (String)"fi-er-opplugin", (Object[])new Object[0]), expenseitemnumber);
                    }
                    if (!"1".equals(expenseitemDy.getString("enable"))) {
                        return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8d39\u7528\u9879\u76ee\u5df2\u7981\u7528\u3002", (String)"ErPubBillInitImportBaseHandle_11", (String)"fi-er-opplugin", (Object[])new Object[0]), expenseitemnumber);
                    }
                    if (Boolean.FALSE.equals(expenseitemDy.getBoolean("isleaf"))) {
                        return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8d39\u7528\u9879\u76ee\u4e0d\u662f\u53f6\u5b50\u8282\u70b9\u3002", (String)"ErPubBillInitImportBaseHandle_6", (String)"fi-er-opplugin", (Object[])new Object[0]), expenseitemnumber);
                    }
                    QFilter filter = new QFilter("expenseitem.number", "=", (Object)expenseitemnumber);
                    DynamicObjectCollection relDepts = QueryServiceHelper.query((String)"bd_expitemreldept", (String)"relorg.number", (QFilter[])new QFilter[]{filter});
                    if (relDepts != null && relDepts.size() > 0) {
                        JSONObject entrycostdept = (JSONObject)row.get("entrycostdept");
                        String number = entrycostdept.getString("number");
                        List relnumbers = relDepts.stream().map(e -> e.getString("relorg.number")).collect(Collectors.toList());
                        if (!relnumbers.isEmpty() && !relnumbers.contains(number)) {
                            return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8d39\u7528\u9879\u76ee\u5173\u8054\u90e8\u95e8\u4e0e\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e0d\u5339\u914d\u3002", (String)"ErPubBillInitImportBaseHandle_20", (String)"fi-er-opplugin", (Object[])new Object[0]), expenseitemnumber);
                        }
                    }
                }
                if ((currencyDy = ImportUtils.getCurrencyIdByNumber((String)(entryCurrencyNumber = (entryCurrency = (JSONObject)row.get("entrycurrency")).getString("number")))) == null) {
                    return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e01\u79cd\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_12", (String)"fi-er-opplugin", (Object[])new Object[0]), entryCurrencyNumber);
                }
                entryCurrencySet.add(currencyDy.getString("number"));
                if (dataMap.get("bizdate") != null) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        bizdate = format.parse(dataMap.get("bizdate").toString());
                    }
                    catch (ParseException e2) {
                        return ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u683c\u5f0f\u6709\u95ee\u9898\u3002", (String)"ErPubBillInitImportBaseHandle_26", (String)"fi-er-opplugin", (Object[])new Object[0]);
                    }
                } else {
                    bizdate = new Date();
                }
                BigDecimal exchangerate = null;
                Object exchangerateobj = row.get("exchangerate");
                if (exchangerateobj != null) {
                    if (exchangerateobj instanceof BigDecimal) {
                        exchangerate = (BigDecimal)exchangerateobj;
                    } else {
                        try {
                            exchangerate = new BigDecimal((String)exchangerateobj);
                        }
                        catch (Exception e3) {
                            return ResManager.loadKDString((String)"\u6c47\u7387\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ErBillBaseImportHandle_10", (String)"fi-er-opplugin", (Object[])new Object[0]);
                        }
                    }
                    boolean quoteType = ExchangeRateService.getRateConversionConfig((Long)((Long)currencyDy.getPkValue()), (Long)((JSONObject)dataMap.get("currency")).getLong("id"), (Date)bizdate);
                    row.put("quoteType", quoteType ? "1" : "0");
                } else if (currencyDy.getPkValue().equals(((JSONObject)dataMap.get("currency")).getLong("id"))) {
                    exchangerate = BigDecimal.ONE;
                } else if (dataMap.get("company") != null && dataMap.get("costcompany") != null) {
                    Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateAndQuoteTypeNoDefault((Object)((JSONObject)dataMap.get("company")).get((Object)"id"), (Object)((JSONObject)dataMap.get("costcompany")).get((Object)"id"), (Long)((Long)currencyDy.getPkValue()), (Long)((JSONObject)dataMap.get("currency")).getLong("id"), (Date)bizdate);
                    exchangerate = (BigDecimal)exchangeRateAndQuoteType.get("exchangeRate");
                    row.put("quoteType", exchangeRateAndQuoteType.get("quoteType"));
                }
                if (exchangerate == null) {
                    return ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u5728\u6c47\u7387\u8868\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u6c47\u7387\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u8bbe\u7f6e\u6216\u624b\u5de5\u586b\u5199\u6c47\u7387\u3002", (String)"ErPubBillInitImportBaseHandle_27", (String)"fi-er-opplugin", (Object[])new Object[0]);
                }
                row.put("exchangerate", exchangerate);
            }
        }
        if (!entryCurrencySet.isEmpty() && (!entryCurrencySet.contains(headCurrencyNumber) || entryCurrencySet.contains(headCurrencyNumber) && entryCurrencySet.size() > 1)) {
            dataMap.put("iscurrency", "1");
        }
        return null;
    }

    protected String handleCustomEntryData(Map<String, Object> dataMap) {
        return null;
    }

    protected String handleHeadDataForProjectOrEstimateBill(Map<String, Object> dataMap) {
        JSONObject projectType;
        if (!billstatuslist.contains(dataMap.get("billstatus"))) {
            return ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u53ea\u80fd\u4e3a\u201c\u6682\u5b58\u201d\u6216\u201c\u5ba1\u6838\u901a\u8fc7\u201d\u3002", (String)"ErPubBillInitImportBaseHandle_25", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        if ("A".equals(dataMap.get("billstatus"))) {
            dataMap.put("auditdate", null);
        }
        if ("E".equals(dataMap.get("billstatus")) && dataMap.get("auditdate") == null) {
            dataMap.put("auditdate", new Date());
        }
        if ((projectType = (JSONObject)dataMap.get("projecttype")) != null) {
            List entryExpItemNumbers;
            String projectTypeNumber = projectType.getString("number");
            DynamicObject projectTypeDy = BusinessDataServiceHelper.loadSingleFromCache((String)"er_projecttype", (String)"id,entryentity.expenseitem,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)projectTypeNumber)});
            if (projectTypeDy == null) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u4e1a\u52a1\u5206\u7c7b\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_16", (String)"fi-er-opplugin", (Object[])new Object[0]), projectTypeNumber);
            }
            if ("0".equals(projectTypeDy.get("enable"))) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u4e1a\u52a1\u5206\u7c7b\u4e0d\u53ef\u7528\u3002", (String)"ErPubBillInitImportBaseHandle_23", (String)"fi-er-opplugin", (Object[])new Object[0]), projectTypeNumber);
            }
            DynamicObjectCollection entryentity = projectTypeDy.getDynamicObjectCollection("entryentity");
            if (!entryentity.isEmpty() && !(entryExpItemNumbers = entryentity.stream().map(e -> e.getString("expenseitem.number")).collect(Collectors.toList())).isEmpty()) {
                dataMap.put("projectTypeExpItemNumbers", entryExpItemNumbers);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("biztype_applybill", "er_costestimatebill_BT_S");
        map.put("biztype_changebill", "er_costestimatechgbill_BT_S");
        map.put("biztype_sharebill", "er_costestimatesharebill_BT_S");
        map.put("biztype_applyassetbill", "er_costestimateassetbill_BT_S");
        if (dataMap.get("detailtype") != null) {
            String detailtype = (String)dataMap.get("detailtype");
            dataMap.put("detailtype", detailtype);
            String stdbilltypeNumber = (String)map.get(detailtype);
            DynamicObject stdbilltypeDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)stdbilltypeNumber)});
            if (stdbilltypeDy != null) {
                dataMap.put("stdbilltype", stdbilltypeDy);
            }
        } else {
            dataMap.put("detailtype", "biztype_applybill");
        }
        dataMap.put("changetype", "A");
        dataMap.put("isimport", "1");
        return null;
    }

    protected String handleEntryDataForProjectOrEstimateBill(Map<String, Object> dataMap) {
        String billstatus = (String)dataMap.get("billstatus");
        JSONArray expenseEntry = (JSONArray)dataMap.get("expenseentryentity");
        BigDecimal applyamount = BigDecimal.ZERO;
        BigDecimal approveamount = BigDecimal.ZERO;
        BigDecimal acapproveamount = BigDecimal.ZERO;
        BigDecimal balanceamount = BigDecimal.ZERO;
        BigDecimal usedamount = BigDecimal.ZERO;
        BigDecimal billcanloanamount = BigDecimal.ZERO;
        BigDecimal loanedamount = BigDecimal.ZERO;
        Object projectTypeExpItemNumbers = dataMap.get("projectTypeExpItemNumbers");
        for (int i = 0; i < expenseEntry.size(); ++i) {
            DynamicObject costCenter;
            String entryCostCenterNumber;
            String expenseitemnumber;
            List ptExpItemNumbers;
            Map row = (Map)expenseEntry.get(i);
            if (projectTypeExpItemNumbers != null && !(ptExpItemNumbers = (List)projectTypeExpItemNumbers).contains(expenseitemnumber = ((JSONObject)row.get("expenseitem")).getString("number"))) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8d39\u7528\u9879\u76ee\u4e0e\u4e1a\u52a1\u5206\u7c7b\u6240\u5173\u8054\u7684\u8d39\u7528\u9879\u76ee\u4e0d\u5339\u914d\u3002", (String)"ErPubBillInitImportBaseHandle_21", (String)"fi-er-opplugin", (Object[])new Object[0]), expenseitemnumber);
            }
            BigDecimal expenseamount = BigDecimal.ZERO;
            try {
                expenseamount = new BigDecimal((String)row.get("expenseamount"));
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u91d1\u989d\u8f93\u5165\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002", (String)"ErPubBillInitImportBaseHandle_28", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            BigDecimal orgiexpebalanceamount = expenseamount;
            Object orgiexpebalanceamountobj = row.get("orgiexpebalanceamount");
            if (orgiexpebalanceamountobj != null) {
                try {
                    orgiexpebalanceamount = new BigDecimal((String)orgiexpebalanceamountobj);
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u91d1\u989d\u8f93\u5165\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002", (String)"ErPubBillInitImportBaseHandle_28", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
                if (orgiexpebalanceamount.compareTo(expenseamount) > 0) {
                    return ResManager.loadKDString((String)"\u53ef\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d\u3002", (String)"ErPubBillInitImportBaseHandle_18", (String)"fi-er-opplugin", (Object[])new Object[0]);
                }
            }
            row.put("orgiexpebalanceamount", orgiexpebalanceamount);
            BigDecimal canloanamount = expenseamount;
            Object canloanamountobj = row.get("canloanamount");
            if (canloanamountobj != null) {
                try {
                    canloanamount = new BigDecimal((String)canloanamountobj);
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u91d1\u989d\u8f93\u5165\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002", (String)"ErPubBillInitImportBaseHandle_28", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
                if (canloanamount.compareTo(expenseamount) > 0) {
                    return ResManager.loadKDString((String)"\u53ef\u9884\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u91d1\u989d\u3002", (String)"ErPubBillInitImportBaseHandle_19", (String)"fi-er-opplugin", (Object[])new Object[0]);
                }
            }
            row.put("canloanamount", canloanamount);
            JSONObject entryCostCenter = (JSONObject)row.get("std_entrycostcenter");
            if (entryCostCenter != null && (entryCostCenterNumber = entryCostCenter.getString("number")) != null && (costCenter = ImportUtils.getCostCenterByNumber((String)entryCostCenterNumber)) == null) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6210\u672c\u4e2d\u5fc3\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_13", (String)"fi-er-opplugin", (Object[])new Object[0]), entryCostCenterNumber);
            }
            int amtprecision = ((JSONObject)dataMap.get("currency")).getInteger("amtprecision");
            boolean needInput = false;
            if (dataMap.containsKey("entrywltypeMustInput") && null != dataMap.get("entrywltypeMustInput")) {
                needInput = (Boolean)dataMap.get("entrywltypeMustInput");
            }
            String entrywltypenumber = (String)row.get("entrywltype");
            if (needInput && !entrywltypelist.contains(entrywltypenumber)) {
                return ResManager.loadKDString((String)"\u5f80\u6765\u5355\u4f4d\u4e0d\u5b58\u5728\u3002", (String)"ErPubBillInitImportBaseHandle_14", (String)"fi-er-opplugin", (Object[])new Object[0]);
            }
            Object taxamountobj = row.get("taxamount");
            BigDecimal taxamount = BigDecimal.ZERO;
            if (taxamountobj == null) {
                Object taxrate = row.get("taxrate");
                if (taxrate != null) {
                    BigDecimal rate = new BigDecimal((String)taxrate).divide(new BigDecimal("100"));
                    taxamount = expenseamount.divide(BigDecimal.ONE.add(rate), amtprecision, 4).multiply(rate).setScale(amtprecision, 4);
                }
            } else {
                taxamount = new BigDecimal((String)taxamountobj);
            }
            row.put("taxamount", taxamount);
            BigDecimal orientryamount = expenseamount.subtract(taxamount);
            row.put("orientryamount", orientryamount);
            BigDecimal exchangerate = (BigDecimal)row.get("exchangerate");
            BigDecimal currexpenseamount = "1".equals(row.get("quoteType")) ? expenseamount.divide(exchangerate, amtprecision, 4) : expenseamount.multiply(exchangerate).setScale(amtprecision, 4);
            row.put("currexpenseamount", currexpenseamount);
            BigDecimal expeapproveamount = expenseamount;
            row.put("expeapproveamount", expeapproveamount);
            BigDecimal expeapprovecurramount = "1".equals(row.get("quoteType")) ? expeapproveamount.divide(exchangerate, amtprecision, 4) : expeapproveamount.multiply(exchangerate).setScale(amtprecision, 4);
            row.put("expeapprovecurramount", expeapprovecurramount);
            BigDecimal price = expeapproveamount.subtract(taxamount);
            row.put("price", expeapproveamount.subtract(taxamount));
            row.put("approvetax", taxamount);
            BigDecimal curprice = "1".equals(row.get("quoteType")) ? price.divide(exchangerate, amtprecision, 4) : price.multiply(exchangerate).setScale(amtprecision, 4);
            row.put("curprice", curprice);
            BigDecimal expebalanceamount = "1".equals(row.get("quoteType")) ? orgiexpebalanceamount.divide(exchangerate, amtprecision, 4) : orgiexpebalanceamount.multiply(exchangerate).setScale(amtprecision, 4);
            row.put("expebalanceamount", expebalanceamount);
            BigDecimal reimbursedamount = expeapproveamount.subtract(orgiexpebalanceamount);
            row.put("reimbursedamount", reimbursedamount);
            BigDecimal reimbursedcurramount = "1".equals(row.get("quoteType")) ? reimbursedamount.divide(exchangerate, amtprecision, 4) : reimbursedamount.multiply(exchangerate).setScale(amtprecision, 4);
            row.put("reimbursedcurramount", reimbursedcurramount);
            BigDecimal canloancurramount = "1".equals(row.get("quoteType")) ? canloanamount.divide(exchangerate, amtprecision, 4) : canloanamount.multiply(exchangerate).setScale(amtprecision, 4);
            row.put("canloancurramount", canloancurramount);
            BigDecimal pushedamount = expeapproveamount.subtract(canloanamount);
            row.put("pushedamount", pushedamount);
            BigDecimal pushedcurramount = "1".equals(row.get("quoteType")) ? pushedamount.divide(exchangerate, amtprecision, 4) : pushedamount.multiply(exchangerate).setScale(amtprecision, 4);
            row.put("pushedcurramount", pushedcurramount);
            applyamount = applyamount.add(currexpenseamount);
            approveamount = approveamount.add(expeapprovecurramount);
            balanceamount = balanceamount.add(expebalanceamount);
            usedamount = usedamount.add(reimbursedcurramount);
            billcanloanamount = billcanloanamount.add(canloancurramount);
            loanedamount = loanedamount.add(pushedcurramount);
            if (!"E".equals(billstatus)) continue;
            BigDecimal acexpeapproveamount = expeapproveamount;
            row.put("acexpeapproveamount", acexpeapproveamount);
            BigDecimal acexpeapprovecurramount = expeapprovecurramount;
            row.put("acexpeapprovecurramount", acexpeapprovecurramount);
            BigDecimal actaxamount = taxamount;
            row.put("actaxamount", actaxamount);
            BigDecimal acorientryamount = orientryamount;
            row.put("acorientryamount", acorientryamount);
            BigDecimal acprice = price;
            row.put("acprice", acprice);
            BigDecimal accurprice = curprice;
            row.put("accurprice", accurprice);
            acapproveamount = acapproveamount.add(acexpeapprovecurramount);
        }
        dataMap.put("applyamount", applyamount);
        dataMap.put("approveamount", approveamount);
        dataMap.put("balanceamount", balanceamount);
        dataMap.put("usedamount", usedamount);
        dataMap.put("billcanloanamount", billcanloanamount);
        dataMap.put("loanedamount", loanedamount);
        dataMap.put("acapproveamount", acapproveamount);
        return null;
    }

    private boolean isMustInput(ImportBillData data, String entryName, String filedName) {
        ImportEntityMapping mapping;
        Map colMap;
        Map entries = data.getEntityMapping().getEntries();
        if (entries.containsKey(entryName) && null != entries.get(entryName) && (colMap = (mapping = (ImportEntityMapping)entries.get(entryName)).getCols()).containsKey(filedName) && null != colMap.get(filedName)) {
            return ((ImportEntityMapping.ColInfo)colMap.get(filedName)).isMustInput();
        }
        return false;
    }
}

