/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.publicbiz.bill.project;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.servicehelper.operation.ErOperationServiceHelper;
import kd.fi.er.business.utils.AttachmentUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.model.attachment.AttachmentData;
import kd.fi.er.validator.publicbiz.bill.project.ProjectBillValidator;

public class PubBizApplyToChangeBillOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PubBizApplyToChangeBillOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("detailtype");
        e.getFieldKeys().add("acapproveamount");
        e.getFieldKeys().add("acexpeapproveamount");
        e.getFieldKeys().add("acexpeapprovecurramount");
        e.getFieldKeys().add("actaxamount");
        e.getFieldKeys().add("acorientryamount");
        e.getFieldKeys().add("approveamount");
        e.getFieldKeys().add("expeapproveamount");
        e.getFieldKeys().add("expeapprovecurramount");
        e.getFieldKeys().add("taxamount");
        e.getFieldKeys().add("orientryamount");
        e.getFieldKeys().add("price");
        e.getFieldKeys().add("curprice");
        e.getFieldKeys().add("acprice");
        e.getFieldKeys().add("accurprice");
        e.getFieldKeys().add("expenseentryentity");
        e.getFieldKeys().add("availableamount");
        e.getFieldKeys().add("currexpenseamount");
        e.getFieldKeys().add("expenseamount");
        e.getFieldKeys().add("entrychangeableamount");
        e.getFieldKeys().add("wbsrcbilltype");
        e.getFieldKeys().add("wbsrcbillid");
        e.getFieldKeys().add("wbsrcbillno");
        e.getFieldKeys().add("expenseentryentity");
        e.getFieldKeys().add("attachmentpanel");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            String detailType = dataEntity.getString("detailtype");
            if (!ErEntityTypeUtils.isApplyProjectBill((String)dataEntity.getDataEntityType().getName()) || !detailType.equalsIgnoreCase("biztype_applybill") && !detailType.equalsIgnoreCase("biztype_applyassetbill")) continue;
            dataEntity.set("acapproveamount", dataEntity.get("approveamount"));
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("expenseentryentity");
            for (DynamicObject entry : entrys) {
                entry.set("actaxamount", entry.get("taxamount"));
                entry.set("acorientryamount", entry.get("orientryamount"));
                entry.set("acexpeapproveamount", entry.get("expeapproveamount"));
                entry.set("acexpeapprovecurramount", entry.get("expeapprovecurramount"));
                entry.set("acprice", entry.get("price"));
                entry.set("accurprice", entry.get("curprice"));
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ProjectBillValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String opKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("audit".equals(opKey)) {
            for (int i = 0; i < dataEntities.length; ++i) {
                String detailtype;
                DynamicObject dataEntity = dataEntities[i];
                String entityName = dataEntities[0].getDataEntityType().getName();
                if (ErEntityTypeUtils.isContractBill((String)entityName) && "biztype_stopbill".equals(detailtype = dataEntities[0].getString("detailtype"))) {
                    QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)dataEntity.getLong("srcsourceid"))};
                    DynamicObject[] soruceBillArray = BusinessDataServiceHelper.load((String)"er_contractbill", (String)"id,billno,billstatus", (QFilter[])qFilters);
                    try {
                        logger.info("\u5ba1\u6838\u901a\u8fc7\u540e\u91ca\u653e\u9884\u7b97>>>>>>>>>>>>>>>>>releasebudget>>>>\u8c03\u7528");
                        OperationResult result = ErOperationServiceHelper.execOperate((String)"releasebudget", (String)entityName, (DynamicObject[])soruceBillArray, (OperateOption)OperateOption.create());
                        if (!result.isSuccess()) {
                            logger.error("\u5355\u636e\u540e\u53f0\u91ca\u653e\u9884\u7b97\u64cd\u4f5c->" + entityName + "sbillid" + dataEntity.getLong("srcsourceid") + "\u5931\u8d25->", (Object)JSONObject.toJSONString((Object)result.getAllErrorOrValidateInfo()));
                        }
                    }
                    catch (KDBizException e1) {
                        logger.error("\u5355\u636e\u540e\u53f0\u91ca\u653e\u9884\u7b97\u64cd\u4f5c->" + entityName + "sbillid" + dataEntity.getLong("srcsourceid") + "\u5f02\u5e38->", (Object)e1.getStackTraceMessage());
                    }
                }
                if (!"biztype_changebill".equals(dataEntity.get("detailtype"))) {
                    return;
                }
                DynamicObjectCollection expenseentryentity = dataEntity.getDynamicObjectCollection("expenseentryentity");
                if (expenseentryentity.size() == 0) {
                    return;
                }
                long wbsrcbillid = (Long)((DynamicObject)expenseentryentity.get(0)).get("wbsrcbillid");
                String wbsrcbillno = (String)((DynamicObject)expenseentryentity.get(0)).get("wbsrcbillno");
                String formid = (String)dataEntity.get("formid");
                List billAttachmentList = AttachmentServiceHelper.getAttachments((String)formid, (Object)dataEntity.getPkValue(), (String)"attachmentpanel");
                ArrayList newAttachmentDatas = Lists.newArrayListWithExpectedSize((int)1);
                if (billAttachmentList == null || billAttachmentList.size() <= 0) continue;
                for (Map map : billAttachmentList) {
                    AttachmentData attachmentDataForUpload = new AttachmentData();
                    String url = (String)map.get("url");
                    String attachmentName = (String)map.get("name");
                    if (url.contains("tempfile/download.do?configKey")) {
                        url = AttachmentUtils.uploadTempfile((String)url, (String)attachmentName);
                    }
                    byte[] bytes = new byte[]{};
                    logger.info("\u6587\u4ef6\u4e0a\u4f20-->\u6587\u4ef6\u539f\u5730\u5740\uff1a{}", (Object)url);
                    try {
                        Map data = HttpServiceHelper.doGetInputStream((String)url);
                        InputStream inputStream = (InputStream)data.get("in");
                        if (inputStream == null) {
                            logger.info("\u7533\u8bf7\u5355\u9644\u4ef6\u53cd\u5199\u5f02\u5e38 no stream");
                            continue;
                        }
                        String type = URLConnection.guessContentTypeFromStream(inputStream);
                        attachmentDataForUpload.setType(type);
                        bytes = ByteStreams.toByteArray((InputStream)inputStream);
                    }
                    catch (Exception exception) {
                        logger.info("{}\u9644\u4ef6\u4fe1\u606f\u4e0a\u4f20\u5f02\u5e38\uff1a{}", (Object)wbsrcbillno, (Object)exception.getMessage());
                    }
                    TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    String filePath = tempFile.saveAsFullUrl(attachmentName, (InputStream)new ByteArrayInputStream(bytes), 30000);
                    String uid = AttachmentServiceHelper.generateUid();
                    filePath = AttachmentServiceHelper.saveTempToFileService((String)filePath, (String)"em", (String)formid, (Object)wbsrcbillid, (String)attachmentName);
                    logger.info("\u9644\u4ef6\u4fe1\u606f\u4e0a\u4f20\u5730\u5740\uff1a{}", (Object)filePath);
                    attachmentDataForUpload.setName(attachmentName);
                    attachmentDataForUpload.setUrl(filePath);
                    attachmentDataForUpload.setSize((long)bytes.length);
                    attachmentDataForUpload.setClient("web");
                    attachmentDataForUpload.setUid(uid);
                    attachmentDataForUpload.setEntityNum(formid);
                    attachmentDataForUpload.setStatus("success");
                    attachmentDataForUpload.setLastModified(UserServiceHelper.getCurrentUserId());
                    attachmentDataForUpload.setCreatedate(new Date().getTime());
                    logger.info("\u9644\u4ef6\u4fe1\u606f\u4e0a\u4f20\u6587\u4ef6\uff1a{}", JSON.toJSON((Object)attachmentDataForUpload));
                    newAttachmentDatas.add((Map)JSON.toJSON((Object)attachmentDataForUpload));
                }
                AttachmentServiceHelper.upload((String)formid, (Object)wbsrcbillid, (String)"attachmentpanel", (List)newAttachmentDatas);
            }
        }
    }
}

