/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.publicbiz.bill.publicreim;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ErBillStatusEnum;
import org.apache.commons.lang.StringUtils;

public class PublicreimBillOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
        fieldKeys.add("invoiceentry.seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PublicReimValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objects;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject bill : objects = e.getDataEntities()) {
            PublicBillUtil.calNonpayAmount((DynamicObject)bill);
        }
    }

    static class PublicReimValidator
    extends AbstractValidator {
        PublicReimValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] billsExtendedDataEntity;
            for (ExtendedDataEntity billExtendedDataEntity : billsExtendedDataEntity = this.getDataEntities()) {
                DynamicObjectCollection invoiceentry;
                Object reimburseType;
                DynamicObject bill = billExtendedDataEntity.getDataEntity();
                DynamicObjectCollection expEntrys = bill.getDynamicObjectCollection("expenseentryentity");
                DynamicObjectCollection accEntrys = bill.getDynamicObjectCollection("accountentry");
                Object detailtype = bill.get("detailtype");
                if (StringUtils.equalsIgnoreCase((String)detailtype.toString(), (String)"biztype_contract")) {
                    DynamicObjectCollection writeOffEntrys = bill.getDynamicObjectCollection("writeoffmoney");
                    Set writeSrcEntryIds = writeOffEntrys.stream().map(r -> r.getLong("srcofsrcentryid")).collect(Collectors.toSet());
                    Set accSrcEntryIds = accEntrys.stream().map(r -> r.getLong("recsrcentryid")).collect(Collectors.toSet());
                    if (accEntrys.size() > 0) {
                        for (DynamicObject expEntry : expEntrys) {
                            Long expEntrySrcEntryId = expEntry.getLong("wbsrcentryid");
                            if (!accSrcEntryIds.contains(expEntrySrcEntryId) && !writeSrcEntryIds.contains(expEntrySrcEntryId)) {
                                this.addErrorMessage(billExtendedDataEntity, String.format(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u5206\u5f55\uff1a%s\u884c\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6536\u6b3e\u4fe1\u606f", (String)"PublicreimBillOp_11", (String)"fi-er-opplugin", (Object[])new Object[0]), expEntry.getInt("seq")));
                                return;
                            }
                            List accEntrySet = accEntrys.stream().filter(r -> expEntrySrcEntryId.compareTo(r.getLong("recsrcentryid")) == 0).collect(Collectors.toList());
                            if (accEntrySet == null || accEntrySet.size() <= 0) continue;
                            BigDecimal expAmount = expEntry.getBigDecimal("expeapproveamount");
                            DynamicObject accEntry = (DynamicObject)accEntrySet.get(0);
                            BigDecimal accAmount = accEntry.getBigDecimal("orireceiveamount");
                            String contractType = SystemParamterUtil.getRelationContract((Long)((Long)((DynamicObject)bill.get("company")).getPkValue()));
                            if (!contractType.equals("0") || expAmount.compareTo(accAmount) >= 0) continue;
                            this.addErrorMessage(billExtendedDataEntity, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u4e2d%s\u884c\u7684\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u8fdb\u884c\u4ed8\u6b3e\u3002", (String)"PublicreimBillOp_8", (String)"fi-er-opplugin", (Object[])new Object[0]), accEntry.getInt("seq")));
                            return;
                        }
                    }
                }
                String writeofftype = (String)bill.get("writeofftype");
                DynamicObjectCollection contractentryEntrys = bill.getDynamicObjectCollection("contractentry");
                if (contractentryEntrys != null && contractentryEntrys.size() > 0 && WriteOffTypeEnum.ORGI_WO.getValue().equals(writeofftype)) {
                    Set concurrency = contractentryEntrys.stream().map(v -> (Long)((DynamicObject)v.get("contractexpcurrency")).getPkValue()).collect(Collectors.toSet());
                    Set expcurrency = expEntrys.stream().map(p -> (Long)((DynamicObject)p.get("entrycurrency")).getPkValue()).collect(Collectors.toSet());
                    Set acccurrency = accEntrys.stream().map(p -> (Long)((DynamicObject)p.get("accountcurrency")).getPkValue()).collect(Collectors.toSet());
                    HashSet totalIds = Sets.newHashSet();
                    totalIds.addAll(concurrency);
                    totalIds.addAll(expcurrency);
                    totalIds.addAll(acccurrency);
                    if (totalIds.size() > 1) {
                        this.addErrorMessage(billExtendedDataEntity, ResManager.loadKDString((String)"\u6240\u6709\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u5e01\u79cd\u3001\u5173\u8054\u5408\u540c\u5206\u5f55\u5e01\u79cd\u3001\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u5e01\u79cd\u5fc5\u987b\u4e00\u81f4\u3002", (String)"RelationContractAmountValidator_13", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                if ((reimburseType = bill.get("reimbursetype")) != null && StringUtils.equalsIgnoreCase((String)"asset", (String)reimburseType.toString())) {
                    DynamicObject assetOrg = bill.getDynamicObject("assetorg");
                    if (assetOrg == null) {
                        this.addErrorMessage(billExtendedDataEntity, ResManager.loadKDString((String)"\u8d44\u4ea7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PublicreimBillOp_10", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObjectCollection assetEntry = bill.getDynamicObjectCollection("assetentry");
                    if (assetEntry == null || assetEntry.size() < 1) {
                        return;
                    }
                    HashMap<DynamicObject, BigDecimal> currencyAndExchangedRateRecorder = new HashMap<DynamicObject, BigDecimal>();
                    BigDecimal sumOfExpeApproveCurAmount = expEntrys.stream().map(e -> e.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.valueOf(0L));
                    BigDecimal sumOfAssetCurrAmount = BigDecimal.ZERO;
                    BigDecimal sumOfAssettaxamount = BigDecimal.ZERO;
                    for (int i = assetEntry.getStartRowIndex(); i < assetEntry.size(); ++i) {
                        DynamicObject row = (DynamicObject)assetEntry.get(i);
                        String assetName = row.getString("asset_name");
                        DynamicObject assetUnit = row.getDynamicObject("asset_unit");
                        if (StringUtils.isBlank((String)assetName) || assetUnit == null) {
                            this.addErrorMessage(billExtendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u8d44\u4ea7\u660e\u7ec6\u4e2d\u8d44\u4ea7\u540d\u79f0\u548c\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"PublicreimBillOp_13", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1));
                            return;
                        }
                        sumOfAssetCurrAmount = sumOfAssetCurrAmount.add(row.getBigDecimal("assetcurrexpenseamount"));
                        sumOfAssettaxamount = sumOfAssettaxamount.add(row.getBigDecimal("assettaxamount"));
                        DynamicObject assetCurrency = row.getDynamicObject("assetcurrency");
                        BigDecimal assetExchangedRate = row.getBigDecimal("assetexchangerate");
                        BigDecimal oldExchangedRate = (BigDecimal)currencyAndExchangedRateRecorder.get(assetCurrency);
                        if (oldExchangedRate == null || BigDecimal.ZERO.compareTo(oldExchangedRate) == 0) {
                            currencyAndExchangedRateRecorder.put(assetCurrency, assetExchangedRate);
                            continue;
                        }
                        if (oldExchangedRate.compareTo(assetExchangedRate) == 0) continue;
                        this.addErrorMessage(billExtendedDataEntity, ResManager.loadKDString((String)"\u8d44\u4ea7\u4fe1\u606f\u540c\u4e00\u79cd\u5e01\u79cd\u8bf7\u5f55\u5165\u76f8\u540c\u6c47\u7387\u3002", (String)"PublicreimBillOp_15", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if ("2".equals(ErStdConfig.get((String)"TassetsCheck"))) continue;
                    String billStatus = bill.getString("billstatus");
                    int compare = sumOfExpeApproveCurAmount.subtract(sumOfAssetCurrAmount).abs().compareTo(new BigDecimal("0.05"));
                    if (compare > 0 && (ErBillStatusEnum.A.toString().equals(billStatus) || ErBillStatusEnum.D.toString().equals(billStatus))) {
                        this.addWarningMessage(billExtendedDataEntity, ResManager.loadKDString((String)"\u62a5\u8d26\u603b\u91d1\u989d\u4e0d\u7b49\u4e8e\u8d44\u4ea7\u603b\u91d1\u989d\u3002", (String)"PublicreimBillOp_16", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    BigDecimal sumOfExpeTaxamount = expEntrys.stream().map(e -> e.getBigDecimal("taxamount")).reduce(BigDecimal::add).orElseGet(() -> BigDecimal.valueOf(0L));
                    if (sumOfExpeTaxamount.compareTo(sumOfAssettaxamount) != 0) {
                        this.addWarningMessage(billExtendedDataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u4e2d\u7a0e\u989d\u4e0d\u7b49\u4e8e\u8d44\u4ea7\u4fe1\u606f\u4e2d\u7a0e\u989d\u3002", (String)"PublicreimBillOp_17", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                if (bill.getDynamicObject("company") == null) {
                    this.addErrorMessage(billExtendedDataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErReimburseBaseBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject wlunit = bill.getDynamicObject("billpayerid");
                Object issamewlunitinvoice = ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)bill.getDynamicObject("company")), (String)"issamewlunitinvoice");
                if (issamewlunitinvoice == null || "0".equals(issamewlunitinvoice.toString()) || wlunit == null || StringUtils.isEmpty((String)wlunit.getString("name")) || (invoiceentry = bill.getDynamicObjectCollection("invoiceentry")) == null || invoiceentry.size() == 0) continue;
                for (int i = 0; i < invoiceentry.size(); ++i) {
                    String makeoutcompname;
                    if (StringUtils.isEmpty((String)((DynamicObject)invoiceentry.get(i)).getString("makeoutcompname")) || StringUtils.isEmpty((String)(makeoutcompname = ((DynamicObject)invoiceentry.get(i)).getString("makeoutcompname").replaceAll("\\(", "\uff08").replaceAll("\\)", "\uff09").replaceAll(" ", ""))) || makeoutcompname.equals(wlunit.getString("name"))) continue;
                    if ("1".equals(issamewlunitinvoice.toString())) {
                        this.buildWarnMessage(billExtendedDataEntity, i + 1);
                        continue;
                    }
                    this.buildErrorMessage(billExtendedDataEntity, i + 1);
                }
            }
        }

        public void buildErrorMessage(ExtendedDataEntity dataEntity, int rowIndex) {
            String fmt = ResManager.loadKDString((String)"\u5f80\u6765\u5355\u4f4d\u4e0e\u53d1\u7968\u4fe1\u606f\u7b2c%s\u884c\u5f00\u7968\u516c\u53f8\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"PublicReimOpValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(fmt, rowIndex));
        }

        public void buildWarnMessage(ExtendedDataEntity dataEntity, int rowIndex) {
            String fmt = ResManager.loadKDString((String)"\u5f80\u6765\u5355\u4f4d\u4e0e\u53d1\u7968\u4fe1\u606f\u7b2c%s\u884c\u5f00\u7968\u516c\u53f8\u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u63d0\u4ea4\uff1f", (String)"PublicReimOpValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]);
            this.addWarningMessage(dataEntity, String.format(fmt, rowIndex));
        }
    }
}

