/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.checking;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.HttpRetryServiceHelper;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.trip.exception.TripSyncLogParam;
import kd.fi.er.business.trip.exception.TripSyncLogUtils;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.systemexternal.CorpSync;
import kd.fi.er.business.trip.supplier.didi.systemexternal.DiDiServiceUtil;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TravelNoOneSync;
import kd.fi.er.business.trip.util.TripClassUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.common.ExternalConstants;
import kd.fi.er.common.utils.ThrowableHelper;
import org.apache.commons.lang3.StringUtils;

public class CheckingBillConfirmOp
extends AbstractOperationServicePlugIn {
    private String splitSign = "-";
    private static Log logger = LogFactory.getLog(CheckingBillConfirmOp.class);
    protected List<TripSyncLogParam> tripSyncLogParamList = null;
    protected TripSyncLogParam tripSyncLogParam = null;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billnum");
        fieldKeys.add("billstatusname");
        fieldKeys.add("server");
        fieldKeys.add("operationtype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            /*
             * WARNING - void declaration
             */
            public void validate() {
                CheckingBillConfirmOp.this.tripSyncLogParamList = new LinkedList<TripSyncLogParam>();
                ExtendedDataEntity[] billEntitys = this.getDataEntities();
                String server = "";
                ArrayList billExpressionList = Lists.newArrayListWithCapacity((int)16);
                HashMap billNumAndBusinessTypeMap = Maps.newHashMapWithExpectedSize((int)16);
                server = CheckingBillConfirmOp.this.buildFilter(billEntitys, server, billExpressionList, billNumAndBusinessTypeMap);
                if (CollectionUtils.isNotEmpty((Collection)billExpressionList)) {
                    QFilter qFilter = new QFilter("server", "=", (Object)server);
                    int index = 0;
                    for (String billNum : billExpressionList) {
                        if (index == 0) {
                            ++index;
                            qFilter.and(QFilter.like((String)"billnum", (String)billNum));
                            continue;
                        }
                        if (index == 0) continue;
                        qFilter.or(QFilter.like((String)"billnum", (String)billNum));
                    }
                    DynamicObject[] allSelectedListData = BusinessDataServiceHelper.load((String)"er_checkingbill", (String)"operationtype,id,settlementamount,server,billnum,billstatusname,formid", (QFilter[])new QFilter[]{qFilter});
                    Set validateBillNums = billNumAndBusinessTypeMap.keySet();
                    List<DynamicObject> needConfirmData = Arrays.stream(allSelectedListData).collect(Collectors.toList());
                    for (String validateBillNum : validateBillNums) {
                        List samePreBillNums = needConfirmData.stream().filter(dynamicObject -> dynamicObject.getString("billnum").contains(validateBillNum)).collect(Collectors.toList());
                        for (DynamicObject dynamicObject2 : samePreBillNums) {
                            void var16_16;
                            Object billnum = dynamicObject2.getString("billnum");
                            String string = "";
                            if (((String)billnum).contains("-")) {
                                String string2 = ((String)billnum).substring(0, ((String)billnum).indexOf("-"));
                            } else if (Supplier.XIECHENG.getValue().equals(server)) {
                                for (String businessType : ExternalConstants.CTRIP_BUSINESSTYPE) {
                                    billnum = ((String)billnum).replace(businessType, "");
                                }
                                Object object = billnum;
                            } else {
                                Object object = billnum;
                            }
                            if (var16_16.equals(validateBillNum)) continue;
                            needConfirmData.remove(dynamicObject2);
                        }
                    }
                    allSelectedListData = needConfirmData.toArray(new DynamicObject[0]);
                    HashMap formIdAndBillNumMap = Maps.newHashMapWithExpectedSize((int)16);
                    Map groupBillData = CheckingBillConfirmOp.this.groupData(allSelectedListData, formIdAndBillNumMap);
                    Set entries = groupBillData.entrySet();
                    Map countMap = Maps.newHashMapWithExpectedSize((int)16);
                    if (Supplier.CHAILVYIHAO.name().equals(server)) {
                        Set formIds = Arrays.stream(allSelectedListData).filter(dynamicObject -> dynamicObject != null && StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("formid"))).map(dynamicObject -> dynamicObject.getString("formid")).collect(Collectors.toSet());
                        countMap = CheckingBillConfirmOp.this.groupCount(formIdAndBillNumMap, formIds);
                    }
                    JSONArray jsonArray = new JSONArray();
                    for (Map.Entry entry : entries) {
                        JSONObject jsonObject;
                        String billNum = (String)entry.getKey();
                        List bills = (List)entry.getValue();
                        if (Supplier.CHAILVYIHAO.name().equals(server)) {
                            jsonObject = CheckingBillConfirmOp.this.buildTravelNoOneConfrimBodyParams(billNum, bills, (Integer)countMap.get(billNum));
                            jsonArray.add((Object)jsonObject);
                            continue;
                        }
                        if (Supplier.DIDI.name().equals(server)) {
                            String businessType = (String)billNumAndBusinessTypeMap.get(billNum);
                            JSONObject jsonObject2 = CheckingBillConfirmOp.this.buildDiDiConfrimBodyParams(billNum, businessType);
                            jsonArray.add((Object)jsonObject2);
                            break;
                        }
                        if (!Supplier.XIECHENG.name().equals(server)) continue;
                        jsonObject = CheckingBillConfirmOp.this.buildXieChengConfrimBodyParams(billNum, bills);
                        jsonArray.add((Object)jsonObject);
                    }
                    Map resultMap = CheckingBillConfirmOp.this.sendRequest(server, jsonArray);
                    this.dealResultMap(billEntitys, server, allSelectedListData, resultMap);
                }
                CheckingBillConfirmOp.this.saveErrorLogDO();
            }

            private void dealResultMap(ExtendedDataEntity[] billEntitys, String server, DynamicObject[] allSelectedListData, Map<String, String> resultMap) {
                if (resultMap != null && !resultMap.isEmpty()) {
                    for (DynamicObject dynamicObject : allSelectedListData) {
                        String billnum = dynamicObject.getString("billnum");
                        if (billnum.contains(CheckingBillConfirmOp.this.splitSign)) {
                            billnum = billnum.substring(0, billnum.indexOf(CheckingBillConfirmOp.this.splitSign));
                        } else {
                            for (String businessType : ExternalConstants.CTRIP_BUSINESSTYPE) {
                                billnum = billnum.replace(businessType, "");
                            }
                        }
                        String reslut = resultMap.get(billnum);
                        if (!StringUtils.isNotEmpty((CharSequence)reslut) || !reslut.equals("success")) continue;
                        dynamicObject.set("billstatusname", (Object)"3");
                    }
                    SaveServiceHelper.save((DynamicObject[])allSelectedListData);
                    for (DynamicObject dynamicObject : billEntitys) {
                        DynamicObject bill = dynamicObject.getDataEntity();
                        String erpBillNum = bill.getString("billnum");
                        if ((Supplier.DIDI.name().equalsIgnoreCase(server) || Supplier.CHAILVYIHAO.name().equalsIgnoreCase(server)) && StringUtils.isNotEmpty((CharSequence)erpBillNum) && erpBillNum.contains(CheckingBillConfirmOp.this.splitSign)) {
                            erpBillNum = erpBillNum.substring(0, erpBillNum.indexOf(CheckingBillConfirmOp.this.splitSign));
                        } else if (Supplier.XIECHENG.name().equalsIgnoreCase(server)) {
                            for (String businessType : ExternalConstants.CTRIP_BUSINESSTYPE) {
                                erpBillNum = erpBillNum.replace(businessType, "");
                            }
                        }
                        if (resultMap.containsKey(erpBillNum) && !"success".equals(resultMap.get(erpBillNum))) {
                            this.addErrorMessage((ExtendedDataEntity)dynamicObject, resultMap.get(erpBillNum));
                        }
                        if (resultMap.containsKey(erpBillNum) || !Supplier.XIECHENG.name().equalsIgnoreCase(server)) continue;
                        this.addErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u8d26\u5355\u786e\u8ba4\u5931\u8d25\u3002", (String)"CheckingBillConfirmOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    private void saveErrorLogDO() {
        final ArrayList<TripSyncLogParam> loglist = new ArrayList<TripSyncLogParam>();
        loglist.addAll(this.tripSyncLogParamList);
        ThreadService.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (null == loglist || loglist.size() < 1) {
                    return;
                }
                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u65e5\u5fd7\u4fdd\u5b58\uff1aloglist:{},traceid:{}", (Object)loglist.size(), (Object)((TripSyncLogParam)loglist.get(0)).getTraceid());
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"er_trip_log");
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                for (TripSyncLogParam logParam : loglist) {
                    DynamicObject triplog = new DynamicObject((DynamicObjectType)entityType);
                    triplog.set("traceid", (Object)logParam.getTraceid());
                    triplog.set("server", (Object)logParam.getServer());
                    triplog.set("function", (Object)logParam.getFunction());
                    triplog.set("status", (Object)logParam.getStatus());
                    triplog.set("message", (Object)TripSyncLogUtils.genErrorStr((String)logParam.getMessage()));
                    triplog.set("message_tag", (Object)logParam.getMessage());
                    triplog.set("requesturl", (Object)logParam.getRequesturl());
                    triplog.set("requestdata", TripSyncLogUtils.genJsonStr((Object)logParam.getRequestdata()));
                    triplog.set("requestdata_tag", TripSyncLogUtils.genClobJsonStr((Object)logParam.getRequestdata()));
                    triplog.set("responsedata", TripSyncLogUtils.genJsonStr((Object)logParam.getResponsedata()));
                    triplog.set("responsedata_tag", TripSyncLogUtils.genClobJsonStr((Object)logParam.getResponsedata()));
                    triplog.set("billno", (Object)TripSyncLogUtils.genErrorStr((String)logParam.getBillno()));
                    triplog.set("billno_tag", (Object)logParam.getBillno());
                    triplog.set("username", (Object)"");
                    triplog.set("opname", (Object)"");
                    list.add(triplog);
                }
                LogORM logORM = LogORM.create();
                try {
                    logORM.insert(list);
                }
                catch (Exception e) {
                    logger.info("\u5546\u65c5\u96c6\u6210,\u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38\uff1a{}", (Object)ThrowableHelper.toString((Exception)e));
                }
            }
        }, (TaskType)TaskType.ER_LOG_TASK, (RequestContext)RequestContext.get());
    }

    private String buildFilter(ExtendedDataEntity[] billEntitys, String server, List<String> billExpressionList, Map<String, String> billNumAndBusinessTypeMap) {
        for (ExtendedDataEntity billEntity : billEntitys) {
            DynamicObject bill = billEntity.getDataEntity();
            String serverName = bill.getString("server");
            String erpBillNum = bill.getString("billnum");
            if (StringUtils.isEmpty((CharSequence)erpBillNum)) continue;
            String operationtype = bill.getString("operationtype");
            if ((Supplier.DIDI.name().equalsIgnoreCase(serverName) || Supplier.CHAILVYIHAO.name().equalsIgnoreCase(serverName)) && erpBillNum.contains(this.splitSign)) {
                erpBillNum = erpBillNum.substring(0, erpBillNum.indexOf(this.splitSign));
                billExpressionList.add(erpBillNum + "%");
            } else if (Supplier.XIECHENG.name().equalsIgnoreCase(serverName)) {
                for (String businessType : ExternalConstants.CTRIP_BUSINESSTYPE) {
                    erpBillNum = erpBillNum.replace(businessType, "");
                }
                billExpressionList.add("%" + erpBillNum);
            }
            if (StringUtils.isNotEmpty((CharSequence)serverName)) {
                server = serverName;
            }
            if ("3".equals(operationtype)) {
                billNumAndBusinessTypeMap.put(erpBillNum, "0");
                continue;
            }
            billNumAndBusinessTypeMap.put(erpBillNum, "1");
        }
        return server;
    }

    private Map<String, Integer> groupCount(Map<String, List<String>> formIdAndBillNumMap, Set<String> formIds) {
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (String formId : formIds) {
            List<String> billNums = formIdAndBillNumMap.get(formId);
            if (CollectionUtils.isEmpty(billNums)) continue;
            DynamicObjectCollection data = QueryServiceHelper.query((String)formId, (String)"id,batchno", (QFilter[])new QFilter[]{new QFilter("batchno", "in", billNums)});
            if (data.isEmpty()) continue;
            Map<String, List<DynamicObject>> detailCheckingBills = data.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("batchno")));
            Set<Map.Entry<String, List<DynamicObject>>> entries = detailCheckingBills.entrySet();
            for (Map.Entry<String, List<DynamicObject>> entry : entries) {
                String key = entry.getKey();
                if (key.contains(this.splitSign)) {
                    key = key.substring(0, key.indexOf(this.splitSign));
                }
                if (countMap.containsKey(key)) {
                    Integer count = (Integer)countMap.get(key);
                    count = count + entry.getValue().size();
                    countMap.put(key, count);
                    continue;
                }
                countMap.put(key, entry.getValue().size());
            }
        }
        return countMap;
    }

    private Map<String, List<DynamicObject>> groupData(DynamicObject[] allSelectedListDate, Map<String, List<String>> formIdAndBillNumMap) {
        HashMap groupBillData = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : allSelectedListDate) {
            List<Object> billNumList;
            String billNum = dynamicObject.getString("billnum");
            if (StringUtils.isEmpty((CharSequence)billNum)) continue;
            if (billNum.contains(this.splitSign)) {
                billNum = billNum.substring(0, billNum.indexOf(this.splitSign));
            } else {
                for (String businessType : ExternalConstants.CTRIP_BUSINESSTYPE) {
                    billNum = billNum.replace(businessType, "");
                }
            }
            if (groupBillData.containsKey(billNum)) {
                ((List)groupBillData.get(billNum)).add(dynamicObject);
            } else {
                ArrayList dataList = Lists.newArrayListWithCapacity((int)16);
                dataList.add(dynamicObject);
                groupBillData.put(billNum, dataList);
            }
            String formId = dynamicObject.getString("formid");
            if (formIdAndBillNumMap.containsKey(formId)) {
                billNumList = formIdAndBillNumMap.get(formId);
                billNumList.add(dynamicObject.getString("billnum"));
                continue;
            }
            billNumList = Lists.newArrayListWithCapacity((int)16);
            billNumList.add(dynamicObject.getString("billnum"));
            formIdAndBillNumMap.put(formId, billNumList);
        }
        return groupBillData;
    }

    private Map<String, String> sendRequest(String server, JSONArray jsonArray) {
        String errcodeKey = "";
        String errMsgKey = "errmsg";
        String responseData = "";
        if (!StringUtils.equalsAny((CharSequence)server, (CharSequence[])new CharSequence[]{Supplier.CHAILVYIHAO.name(), Supplier.DIDI.name(), Supplier.XIECHENG.name()})) {
            return Maps.newHashMap();
        }
        if (jsonArray == null || jsonArray.size() == 0) {
            return Maps.newHashMap();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        switch (server) {
            case "CHAILVYIHAO": {
                this.initSyncLogParam(server);
                errcodeKey = "errcode";
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("access_token", (Object)TravelNoOneSync.getLoginToken());
                jsonObject.put("data", (Object)jsonArray);
                logger.info("\u5546\u65c5\u96c6\u6210,\u5dee\u65c5\u58f9\u53f7\u786e\u8ba4\u8d26\u5355,\u4e0a\u9001\u6570\u636epostdata: " + SerializationUtils.toJsonString((Object)jsonObject));
                String url = TripCommonUtil.getTravelNoOneApiUrl((String)"batchConfirmCheckingBillUrlKey");
                this.tripSyncLogParam.setRequesturl(url);
                this.tripSyncLogParam.setRequestdata((Object)JSON.toJSONString((Object)jsonObject));
                responseData = HttpServiceHelper.PostData((String)url, (String)SerializationUtils.toJsonString((Object)jsonObject));
                this.tripSyncLogParam.setResponsedata((Object)responseData);
                logger.info("\u5dee\u65c5\u58f9\u53f7\u786e\u8ba4\u8d26\u5355\u8fd4\u56de{}", (Object)responseData);
                JSONObject travelNoOneJson = JSONObject.parseObject((String)responseData);
                this.dealTravelNoOneResult(jsonArray, errcodeKey, resultMap, travelNoOneJson);
                this.tripSyncLogParamList.add(this.tripSyncLogParam);
                break;
            }
            case "DIDI": {
                this.initSyncLogParam(server);
                String postData = SerializationUtils.toJsonString((Object)jsonArray.getJSONObject(0));
                errcodeKey = "errno";
                String url = (String)ExternalConstants.DIDIURLMAP.get("billConfirmKey");
                this.tripSyncLogParam.setRequesturl(url);
                this.tripSyncLogParam.setRequestdata((Object)JSON.toJSONString((Object)postData));
                responseData = HttpServiceHelper.PostData((String)url, (String)postData);
                this.tripSyncLogParam.setResponsedata((Object)responseData);
                logger.info("\u6ef4\u6ef4\u786e\u8ba4\u8d26\u5355\u8fd4\u56de{}", (Object)responseData);
                JSONObject didiJson = JSONObject.parseObject((String)responseData);
                JSONObject requestJson = JSONObject.parseObject((String)postData);
                String bill_id = requestJson.getString("bill_id");
                if (didiJson != null && !didiJson.getString(errcodeKey).equals("0")) {
                    String errmsg = didiJson.getString("errmsg");
                    if (errmsg.contains(ResManager.loadKDString((String)"\u5df2\u786e\u8ba4", (String)"OrderBillListForEM_11", (String)"fi-er-formplugin", (Object[])new Object[0]))) {
                        resultMap.put(bill_id, "success");
                        this.tripSyncLogParam.setStatus("A");
                        this.tripSyncLogParam.setBillno(bill_id);
                    } else {
                        resultMap.put(bill_id, didiJson.getString(errMsgKey));
                        this.tripSyncLogParam.setStatus("B");
                        this.tripSyncLogParam.setMessage((Object)didiJson.getString(errMsgKey));
                        this.tripSyncLogParam.setBillno(bill_id);
                    }
                    this.tripSyncLogParamList.add(this.tripSyncLogParam);
                } else if (didiJson != null) {
                    resultMap.put(bill_id, "success");
                    this.tripSyncLogParam.setStatus("A");
                    this.tripSyncLogParam.setBillno(bill_id);
                }
                this.tripSyncLogParamList.add(this.tripSyncLogParam);
                break;
            }
            case "XIECHENG": {
                int paramValue = TripSyncConfigUtil.getIntValue((String)"Ctrip_Billing_method", (int)1);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject data = jsonArray.getJSONObject(i);
                    String batchNo = data.getString("batchNo");
                    if (StringUtils.isBlank((CharSequence)batchNo)) continue;
                    this.initSyncLogParam(server);
                    JSONObject postJson = new JSONObject();
                    postJson.put("Auth", (Object)CorpSync.getCacheAuthentification((String)""));
                    postJson.put("BatchNo", (Object)batchNo);
                    logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u643a\u7a0b\u7ed3\u7b97\u6279\u6b21\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42\u6570\u636e\uff1a{}", (Object)postJson.toJSONString());
                    this.tripSyncLogParam.setRequesturl("https://ct.ctrip.com/SwitchApi/CorpSettlement/GetCorpAccountAccCheck");
                    this.tripSyncLogParam.setRequestdata((Object)postJson.toJSONString());
                    responseData = HttpRetryServiceHelper.PostData((String)"https://ct.ctrip.com/SwitchApi/CorpSettlement/GetCorpAccountAccCheck", (String)postJson.toJSONString());
                    this.tripSyncLogParam.setResponsedata((Object)responseData);
                    JSONObject backJson = JSONObject.parseObject((String)responseData);
                    if (backJson == null) {
                        logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u643a\u7a0b\u7ed3\u7b97\u6279\u6b21\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42\u6570\u636e\uff0cbackJson\u4e3a\u7a7a");
                        continue;
                    }
                    logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u643a\u7a0b\u7ed3\u7b97\u6279\u6b21{}\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)batchNo, (Object)backJson.toJSONString());
                    JSONObject responseStatus = (JSONObject)backJson.getOrDefault((Object)"Status", (Object)new JSONObject());
                    if ("0".equals(responseStatus.getString("ErrorCode"))) {
                        this.tripSyncLogParam.setBillno(batchNo);
                        this.tripSyncLogParam.setStatus("A");
                        this.tripSyncLogParamList.add(this.tripSyncLogParam.clone());
                        this.dealXieChengResult(data, backJson.getJSONArray("CorpAccountAccCheckInfoList"), paramValue, resultMap);
                        continue;
                    }
                    resultMap.put(batchNo, responseStatus.getString("Message"));
                    this.tripSyncLogParam.setBillno(batchNo);
                    this.tripSyncLogParam.setStatus("B");
                    this.tripSyncLogParam.setMessage((Object)responseStatus.getString("Message"));
                    this.tripSyncLogParamList.add(this.tripSyncLogParam.clone());
                }
                break;
            }
        }
        return resultMap;
    }

    private void dealXieChengResult(JSONObject data, JSONArray checkInfoList, int paramValue, Map<String, String> resultMap) {
        String batchNo;
        String logBatchNo = batchNo = data.getString("batchNo");
        if (paramValue == 3) {
            logBatchNo = data.getString("subbatchno");
        }
        if (checkInfoList == null || checkInfoList.isEmpty()) {
            logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u643a\u7a0b\u7ed3\u7b97\u6279\u6b21\u786e\u8ba4\uff0cCorpAccountAccCheckInfoList\u4e3a\u7a7a");
            resultMap.put(logBatchNo, ResManager.loadKDString((String)"\u8d26\u5355\u786e\u8ba4\u5931\u8d25\u3002", (String)"CheckingBillConfirmOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < checkInfoList.size(); ++i) {
            JSONObject checkInfo = checkInfoList.getJSONObject(i);
            JSONArray accCheckInfoList = checkInfo.getJSONArray("AccCheckInfoList");
            if (accCheckInfoList == null || accCheckInfoList.isEmpty()) {
                logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u643a\u7a0b\u7ed3\u7b97\u6279\u6b21\uff0cAccCheckInfoList\u4e3a\u7a7a");
                resultMap.put(logBatchNo, ResManager.loadKDString((String)"\u8d26\u5355\u786e\u8ba4\u5931\u8d25\u3002", (String)"CheckingBillConfirmOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue;
            }
            JSONObject accCheckInfo = null;
            for (int j = 0; j < accCheckInfoList.size(); ++j) {
                JSONObject jsonObject = accCheckInfoList.getJSONObject(j);
                if (!batchNo.equals(jsonObject.getString("BatchNo"))) continue;
                accCheckInfo = jsonObject;
                break;
            }
            if (accCheckInfo == null) {
                logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u643a\u7a0b\u8fd4\u56de\u6570\u636e\u4e2d\u6ca1\u6709\u627e\u5230\u4e0e\u6279\u6b21\u53f7\uff1a{}\u76f8\u540c\u7684\u6570\u636e\uff0ccheckInfoList\uff1a{}", (Object)batchNo, (Object)checkInfo.toJSONString());
                resultMap.put(logBatchNo, ResManager.loadKDString((String)"\u8d26\u5355\u786e\u8ba4\u5931\u8d25\u3002", (String)"CheckingBillConfirmOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue;
            }
            JSONObject postJson = new JSONObject();
            postJson.put("Auth", (Object)CorpSync.getCacheAuthentification((String)""));
            if (paramValue == 2) {
                BigDecimal consumeMoney = TripClassUtil.getDefaultBigDecimal((BigDecimal)accCheckInfo.getBigDecimal("ConsumeMoney"));
                if (data.getBigDecimal("consumeMoney").compareTo(consumeMoney) == 0) {
                    JSONArray batchEntityList = new JSONArray();
                    JSONObject batchEntity = new JSONObject();
                    batchEntity.put("BatchNo", (Object)batchNo);
                    batchEntity.put("ConfirmStatus", (Object)1);
                    batchEntityList.add((Object)batchEntity);
                    String accountID = batchNo.substring(batchNo.indexOf("_") + 1, batchNo.lastIndexOf("_"));
                    postJson.put("AccountID", (Object)accountID);
                    postJson.put("ConfirmType", (Object)0);
                    postJson.put("BatchEntityList", (Object)batchEntityList);
                    logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u643a\u7a0b\u7ed3\u7b97\u6279\u6b21\u786e\u8ba4\u63a5\u53e3\u8bf7\u6c42\u6570\u636e\uff1a{}", (Object)postJson.toJSONString());
                    this.tripSyncLogParam.setRequesturl("https://ct.ctrip.com/SwitchApi/CorpSettlement/ConfirmAccCheck");
                    this.tripSyncLogParam.setRequestdata((Object)postJson.toJSONString());
                    String result = HttpRetryServiceHelper.PostData((String)"https://ct.ctrip.com/SwitchApi/CorpSettlement/ConfirmAccCheck", (String)postJson.toJSONString());
                    this.tripSyncLogParam.setResponsedata((Object)result);
                    JSONObject backJson = JSONObject.parseObject((String)result);
                    if (backJson == null) {
                        logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u643a\u7a0b\u7ed3\u7b97\u6279\u6b21{}\u786e\u8ba4\u63a5\u53e3\u8bf7\u6c42\u6570\u636e\uff0cbackJson\u4e3a\u7a7a", (Object)batchNo);
                        resultMap.put(logBatchNo, ResManager.loadKDString((String)"\u8d26\u5355\u786e\u8ba4\u5931\u8d25\u3002", (String)"CheckingBillConfirmOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u643a\u7a0b\u7ed3\u7b97\u6279\u6b21{}\u786e\u8ba4\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)batchNo, (Object)backJson.toJSONString());
                    JSONObject responseStatus = backJson.getJSONObject("Status");
                    if (responseStatus != null && "0".equals(responseStatus.getString("ErrorCode"))) {
                        this.tripSyncLogParam.setBillno(logBatchNo);
                        this.tripSyncLogParam.setStatus("A");
                        resultMap.put(logBatchNo, "success");
                    } else if (responseStatus != null) {
                        this.tripSyncLogParam.setBillno(logBatchNo);
                        this.tripSyncLogParam.setStatus("B");
                        this.tripSyncLogParam.setMessage((Object)responseStatus.getString("Message"));
                        resultMap.put(logBatchNo, ResManager.loadKDString((String)"\u8d26\u5355\u786e\u8ba4\u5931\u8d25\u3002", (String)"CheckingBillConfirmOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.tripSyncLogParam.setBillno(logBatchNo);
                    this.tripSyncLogParam.setStatus("B");
                    this.tripSyncLogParam.setMessage((Object)String.format(ResManager.loadKDString((String)"\u8d26\u5355%1$s\u7684\u7ed3\u7b97\u91d1\u989d\u548c\u643a\u7a0b\u65b9\u8d26\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"CheckingBillConfirmOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]), logBatchNo));
                    logger.info("\u8d26\u5355\u786e\u8ba4\uff0c{}\u643a\u7a0b\u8fd4\u56de\u91d1\u989d\u548c\u8d26\u5355\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4\uff0c\u8d26\u5355\u91d1\u989d\uff1a{}\uff0c\u643a\u7a0b\u8fd4\u56de\u91d1\u989d\uff1a{}", new Object[]{batchNo, data.getBigDecimal("consumeMoney"), consumeMoney});
                    resultMap.put(logBatchNo, String.format(ResManager.loadKDString((String)"\u8d26\u5355%1$s\u7684\u7ed3\u7b97\u91d1\u989d\u548c\u643a\u7a0b\u65b9\u8d26\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"CheckingBillConfirmOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]), logBatchNo));
                }
                this.tripSyncLogParamList.add(this.tripSyncLogParam.clone());
                continue;
            }
            if (paramValue != 3) continue;
            String subBatchNo = data.getString("subbatchno");
            if (StringUtils.isBlank((CharSequence)subBatchNo)) {
                logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u6309\u5b50\u6279\u6b21\u786e\u8ba4\u65f6\uff0c\u5b50\u6279\u6b21\u53f7\u4e3a\u7a7a");
                resultMap.put(logBatchNo, ResManager.loadKDString((String)"\u8d26\u5355\u786e\u8ba4\u5931\u8d25\u3002", (String)"CheckingBillConfirmOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return;
            }
            JSONArray subAccCheckInfoList = accCheckInfo.getJSONArray("SubAccCheckInfoList");
            if (subAccCheckInfoList == null || subAccCheckInfoList.isEmpty()) {
                logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u6309\u5b50\u6279\u6b21\u786e\u8ba4\u65f6\uff0c{}\u643a\u7a0b\u8fd4\u56deSubAccCheckInfoList\u4e3a\u7a7a,accCheckInfo\uff1a{}", (Object)subBatchNo, (Object)accCheckInfo.toJSONString());
                resultMap.put(logBatchNo, ResManager.loadKDString((String)"\u8d26\u5355\u786e\u8ba4\u5931\u8d25\u3002", (String)"CheckingBillConfirmOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue;
            }
            for (int j = 0; j < subAccCheckInfoList.size(); ++j) {
                JSONObject subAccCheckInfo = subAccCheckInfoList.getJSONObject(j);
                if (subAccCheckInfo == null || !subBatchNo.equals(subAccCheckInfo.getString("SubAccCheckBatchNo"))) {
                    logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u6309\u5b50\u6279\u6b21\u786e\u8ba4\u65f6\uff0c{}\u643a\u7a0b\u8fd4\u56deSubAccCheckBatchNo\u548c\u5b50\u6279\u6b21\u53f7\u4e0d\u7b49,accCheckInfo\uff1a{}", (Object)subBatchNo, (Object)accCheckInfo.toJSONString());
                    resultMap.put(logBatchNo, ResManager.loadKDString((String)"\u8d26\u5355\u786e\u8ba4\u5931\u8d25\u3002", (String)"CheckingBillConfirmOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue;
                }
                BigDecimal adjedReceiveMoney = TripClassUtil.getDefaultBigDecimal((BigDecimal)subAccCheckInfo.getBigDecimal("AdjedReceiveMoney"));
                if (data.getBigDecimal("consumeMoney").compareTo(adjedReceiveMoney) == 0) {
                    JSONArray subBatchEntityList = new JSONArray();
                    JSONObject batchEntity = new JSONObject();
                    batchEntity.put("BatchNo", (Object)subBatchNo);
                    batchEntity.put("ConfirmStatus", (Object)1);
                    subBatchEntityList.add((Object)batchEntity);
                    postJson.put("ConfirmType", (Object)1);
                    postJson.put("SubBatchEntityList", (Object)subBatchEntityList);
                    logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u643a\u7a0b\u7ed3\u7b97\u5b50\u6279\u6b21\u786e\u8ba4\u63a5\u53e3\u8bf7\u6c42\u6570\u636e\uff1a{}", (Object)postJson.toJSONString());
                    this.tripSyncLogParam.setRequesturl("https://ct.ctrip.com/SwitchApi/CorpSettlement/ConfirmAccCheck");
                    this.tripSyncLogParam.setRequestdata((Object)postJson.toJSONString());
                    String result = HttpRetryServiceHelper.PostData((String)"https://ct.ctrip.com/SwitchApi/CorpSettlement/ConfirmAccCheck", (String)postJson.toJSONString());
                    this.tripSyncLogParam.setResponsedata((Object)result);
                    JSONObject backJson = JSONObject.parseObject((String)result);
                    if (backJson == null) {
                        logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u643a\u7a0b\u5b50\u7ed3\u7b97\u6279\u6b21{}\u786e\u8ba4\u63a5\u53e3\u8bf7\u6c42\u6570\u636e\uff0cbackJson\u4e3a\u7a7a", (Object)subBatchNo);
                        resultMap.put(logBatchNo, ResManager.loadKDString((String)"\u8d26\u5355\u786e\u8ba4\u5931\u8d25\u3002", (String)"CheckingBillConfirmOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u643a\u7a0b\u7ed3\u7b97\u6279\u6b21{}\u786e\u8ba4\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)subBatchNo, (Object)backJson.toJSONString());
                    JSONObject responseStatus = backJson.getJSONObject("Status");
                    if (responseStatus != null && "0".equals(responseStatus.getString("ErrorCode"))) {
                        resultMap.put(logBatchNo, "success");
                        this.tripSyncLogParam.setBillno(logBatchNo);
                        this.tripSyncLogParam.setStatus("A");
                    } else if (responseStatus != null) {
                        this.tripSyncLogParam.setStatus("B");
                        this.tripSyncLogParam.setMessage((Object)responseStatus.getString("Message"));
                        resultMap.put(logBatchNo, ResManager.loadKDString((String)"\u8d26\u5355\u786e\u8ba4\u5931\u8d25\u3002", (String)"CheckingBillConfirmOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.tripSyncLogParam.setBillno(logBatchNo);
                    this.tripSyncLogParam.setStatus("B");
                    this.tripSyncLogParam.setMessage((Object)String.format(ResManager.loadKDString((String)"\u8d26\u5355%1$s\u7684\u7ed3\u7b97\u91d1\u989d\u548c\u643a\u7a0b\u65b9\u8d26\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"CheckingBillConfirmOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]), logBatchNo));
                    logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u643a\u7a0b\u8fd4\u56de\u91d1\u989d\u548c\u8d26\u5355\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4{}\uff0c\u8d26\u5355\u91d1\u989d\uff1a{}\uff0c\u643a\u7a0b\u8fd4\u56de\u91d1\u989d\uff1a{}", new Object[]{subBatchNo, data.getBigDecimal("consumeMoney"), adjedReceiveMoney});
                    resultMap.put(logBatchNo, String.format(ResManager.loadKDString((String)"\u8d26\u5355%1$s\u7684\u7ed3\u7b97\u91d1\u989d\u548c\u643a\u7a0b\u65b9\u8d26\u5355\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"CheckingBillConfirmOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]), logBatchNo));
                }
                this.tripSyncLogParamList.add(this.tripSyncLogParam.clone());
            }
        }
    }

    private void dealTravelNoOneResult(JSONArray jsonArray, String errcodeKey, Map<String, String> resultMap, JSONObject travelNoOneJson) {
        HashSet billNoSet = Sets.newHashSetWithExpectedSize((int)16);
        for (int i = 0; i < jsonArray.size(); ++i) {
            String billNo = jsonArray.getJSONObject(i).getString("billNo");
            billNoSet.add(billNo);
        }
        ArrayList billNoList = new ArrayList(billNoSet);
        if (travelNoOneJson != null) {
            Object result = travelNoOneJson.get((Object)"result");
            if (result == null) {
                logger.info("\u8fd4\u53c2\u89e3\u6790\u5f02\u5e38{}", (Object)travelNoOneJson);
                for (String billNo : billNoList) {
                    resultMap.put(billNo, String.format(ResManager.loadKDString((String)"\u8d26\u5355\u786e\u8ba4\u5931\u8d25\u3002", (String)"CheckingBillConfirmOp_02", (String)"fi-er-formplugin", (Object[])new Object[0]), billNo));
                }
                return;
            }
            Map returnResultMap = (Map)result;
            Set entries = returnResultMap.entrySet();
            for (Map.Entry entry : entries) {
                String billNo = (String)entry.getKey();
                JSONObject value = (JSONObject)entry.getValue();
                String left = value.getString("left");
                if ("true".equals(left)) {
                    this.tripSyncLogParam.setBillno(billNo);
                    this.tripSyncLogParam.setStatus("A");
                    this.tripSyncLogParam.setBillno(billNo);
                    resultMap.put(billNo, "success");
                    continue;
                }
                String right = value.getString("right");
                if (right.contains(ResManager.loadKDString((String)"\u5df2\u786e\u8ba4", (String)"OrderBillListForEM_11", (String)"fi-er-formplugin", (Object[])new Object[0])) || right.contains(ResManager.loadKDString((String)"\u5df2\u9501\u5b9a", (String)"CheckingBillConfirmOp_03", (String)"fi-er-formplugin", (Object[])new Object[0]))) {
                    resultMap.put(billNo, "success");
                    continue;
                }
                resultMap.put(billNo, right);
                this.tripSyncLogParam.setBillno(billNo);
                this.tripSyncLogParam.setStatus("B");
                this.tripSyncLogParam.setMessage((Object)right);
            }
            Set<String> resultBillNos = resultMap.keySet();
            billNoList.removeAll(resultBillNos);
            if (CollectionUtils.isNotEmpty(billNoList)) {
                billNoList.forEach(v -> resultMap.put((String)v, ResManager.loadKDString((String)"\u8d26\u5355\u786e\u8ba4\u5931\u8d25\u3002", (String)"CheckingBillConfirmOp_02", (String)"fi-er-formplugin", (Object[])new Object[0])));
            }
        }
    }

    private JSONObject buildTravelNoOneConfrimBodyParams(String billNum, List<DynamicObject> dynamicObjects, Integer count) {
        Map supplierMap = TripCommonUtil.getTripServiceInfo((String)Supplier.CHAILVYIHAO.name());
        String companyId = (String)supplierMap.get("orationid");
        JSONObject dataObject = new JSONObject();
        dataObject.put("billNo", (Object)billNum);
        dataObject.put("confirmType", (Object)1);
        dataObject.put("confirmState", (Object)1);
        dataObject.put("corpConfirmName", (Object)RequestContext.get().getUserName());
        dataObject.put("corpNo", (Object)companyId);
        if (TripSyncConfigUtil.getBoolean((String)"ttrip_orderbill_confirm")) {
            dataObject.put("totalConsumeNum", (Object)count);
            BigDecimal settlementAmount = dynamicObjects.stream().map(v -> v.getBigDecimal("settlementamount")).reduce(BigDecimal::add).get();
            dataObject.put("consumeMoney", (Object)(BigDecimal.ZERO.compareTo(settlementAmount) == 0 ? BigDecimal.ZERO : settlementAmount));
        }
        return dataObject;
    }

    private JSONObject buildDiDiConfrimBodyParams(String billNum, String businessType) {
        Map supplierMap = TripCommonUtil.getTripServiceInfo((String)Supplier.DIDI.name());
        String client_id = (String)supplierMap.get("appkey");
        String company_id = (String)supplierMap.get("orationid");
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        JSONObject jsonObject = new JSONObject();
        String signKey = (String)supplierMap.get("reservedfield1");
        String access_token = DiDiServiceUtil.getCacheToken((Date)new Date());
        if (access_token == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u65c5\u96c6\u6210\uff0c\u65e0\u6cd5\u83b7\u53d6\u6ef4\u6ef4token\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"CheckingBillConfirmOp_12", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        jsonObject.put("bill_id", (Object)billNum);
        jsonObject.put("client_id", (Object)client_id);
        jsonObject.put("company_id", (Object)company_id);
        jsonObject.put("access_token", (Object)access_token);
        jsonObject.put("timestamp", (Object)timestamp);
        jsonObject.put("business_type", (Object)businessType);
        String sign = DiDiServiceUtil.genSign((Map)jsonObject, (String)signKey);
        jsonObject.put("sign", (Object)sign);
        logger.info("\u5546\u65c5\u96c6\u6210,\u6ef4\u6ef4\u786e\u8ba4\u8d26\u5355,\u4e0a\u9001\u6570\u636epostdata: " + SerializationUtils.toJsonString((Object)jsonObject));
        return jsonObject;
    }

    private JSONObject buildXieChengConfrimBodyParams(String billNum, List<DynamicObject> dynamicObjects) {
        DynamicObject checkingBill = dynamicObjects.get(0);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)checkingBill.getString("formid"), (String)"batchno,subbatchno", (QFilter[])new QFilter[]{new QFilter("checkingbillnum", "=", (Object)checkingBill.getString("billnum"))});
        JSONObject jsonObject = new JSONObject();
        if (dynamicObject == null) {
            logger.info("\u8d26\u5355\u786e\u8ba4\uff0c\u6839\u636e\u6708\u7ed3\u8d26\u5355\u53f7\u67e5\u8be2\u7ed3\u7b97\u5355\u672a\u67e5\u8be2\u5230\uff0c\u7ed3\u7b97\u5355\u7c7b\u578b\u4e3a\uff1a{},\u6708\u7ed3\u8d26\u5355\u53f7\u4e3a:{}", (Object)checkingBill.getString("formid"), (Object)checkingBill.getString("billnum"));
            return jsonObject;
        }
        jsonObject.put("batchNo", (Object)dynamicObject.getString("batchno"));
        jsonObject.put("subbatchno", (Object)dynamicObject.getString("subbatchno"));
        BigDecimal settlementAmount = dynamicObjects.stream().map(v -> v.getBigDecimal("settlementamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        jsonObject.put("consumeMoney", (Object)settlementAmount);
        return jsonObject;
    }

    public void initSyncLogParam(String server) {
        this.tripSyncLogParam = new TripSyncLogParam();
        String functionname = ResManager.loadKDString((String)"\u6708\u7ed3\u8d26\u5355\u786e\u8ba4", (String)"CheckingBillConfirmOp_15", (String)"fi-er-opplugin", (Object[])new Object[0]);
        QFilter filter = new QFilter("number", "=", (Object)server);
        DynamicObject cacheObject = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info", (String)"name", (QFilter[])new QFilter[]{filter});
        String servername = "";
        if (null != cacheObject) {
            servername = cacheObject.getString("name");
        }
        this.tripSyncLogParam = new TripSyncLogParam(RequestContext.get().getTraceId(), servername, functionname);
        this.tripSyncLogParam.setSynctime(new Date());
    }
}

