/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.dailybiz;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.messagepublish.ErMessagePublisher;

public class ReverseOrderBillOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ReverseOrderBillOp.class);
    private String operateKey;
    private static final String SUBMIT_OPERATE = "submit";
    private static final String UNSUBMIT_OPERATE = "unsubmit";
    private static final String INVALIDBTN_OPERATE = "invalidbtn";
    private static final String AUDIT_OPERATE = "audit";
    private static final String NOAPPROVAL_OPERATE = "noapproval";
    private static final String UNAUDIT_OPERATE = "unaudit";
    private static final String DISAUDIT_OPERATE = "unaudit";
    private static final String RE_OPERATE = "cashierrepulse";
    private static final Map<String, Boolean> isReimburseMap = new HashMap<String, Boolean>();
    private static final Map<String, Boolean> isAuditMap = new HashMap<String, Boolean>();

    public void initialize(InitOperationArgs e) {
        super.initialize(e);
        Map opParameter = this.operateMeta;
        if (opParameter != null && opParameter.get("key") != null) {
            this.operateKey = (String)opParameter.get("key");
        }
        logger.info("\u5dee\u65c5\u62a5\u9500\u5355\u53cd\u5199\u82cd\u7a79\u7cfb\u7edf\u5173\u8054\u7684\u8ba2\u5355,\u4e1a\u52a1\u64cd\u4f5c\u662f:" + this.operateKey);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        for (DynamicObject tripReimburseBill : e.getDataEntities()) {
            HashMap<String, Object> sendMsg = new HashMap<String, Object>();
            sendMsg.put("billId", tripReimburseBill.getPkValue());
            sendMsg.put("isReimburse", isReimburseMap.get(this.operateKey));
            sendMsg.put("isAudit", isAuditMap.get(this.operateKey));
            sendMsg.put("operateKey", this.operateKey);
            String entityName = tripReimburseBill.getDataEntityType().getName();
            sendMsg.put("entityName", entityName);
            if (Arrays.asList("converttoh", "save").contains(this.operateKey)) {
                sendMsg.put("isReimburse", false);
                sendMsg.put("isAudit", false);
            } else if (Arrays.asList("converttoi", "closebill").contains(this.operateKey)) {
                sendMsg.put("isReimburse", true);
                sendMsg.put("isAudit", true);
            }
            if ("delete".equals(this.operateKey)) continue;
            ErMessagePublisher.publishMessageToMq((String)"fi", (String)"fi.er.tripsync.tripReimburseBill.reverse.orderbill", sendMsg);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (DynamicObject tripReimburseBill : e.getDataEntities()) {
            HashMap<String, Object> sendMsg = new HashMap<String, Object>();
            sendMsg.put("billId", tripReimburseBill.getPkValue());
            sendMsg.put("isReimburse", isReimburseMap.get(this.operateKey));
            sendMsg.put("isAudit", isAuditMap.get(this.operateKey));
            sendMsg.put("operateKey", this.operateKey);
            String entityName = tripReimburseBill.getDataEntityType().getName();
            sendMsg.put("entityName", entityName);
            if (!"delete".equals(this.operateKey)) continue;
            sendMsg.put("isReimburse", false);
            sendMsg.put("isAudit", false);
            ErMessagePublisher.publishMessageToMq((String)"fi", (String)"fi.er.tripsync.tripReimburseBill.reverse.orderbill", sendMsg);
        }
    }

    static {
        isReimburseMap.put(SUBMIT_OPERATE, Boolean.TRUE);
        isReimburseMap.put(UNSUBMIT_OPERATE, Boolean.FALSE);
        isReimburseMap.put(INVALIDBTN_OPERATE, Boolean.FALSE);
        isReimburseMap.put(AUDIT_OPERATE, Boolean.TRUE);
        isReimburseMap.put(NOAPPROVAL_OPERATE, Boolean.FALSE);
        isReimburseMap.put("unaudit", Boolean.FALSE);
        isReimburseMap.put("unaudit", Boolean.FALSE);
        isReimburseMap.put(RE_OPERATE, Boolean.TRUE);
        isAuditMap.put(SUBMIT_OPERATE, Boolean.FALSE);
        isAuditMap.put(UNSUBMIT_OPERATE, Boolean.FALSE);
        isAuditMap.put(INVALIDBTN_OPERATE, Boolean.FALSE);
        isAuditMap.put(AUDIT_OPERATE, Boolean.TRUE);
        isAuditMap.put(NOAPPROVAL_OPERATE, Boolean.FALSE);
        isAuditMap.put("unaudit", Boolean.FALSE);
        isAuditMap.put("unaudit", Boolean.FALSE);
        isAuditMap.put(RE_OPERATE, Boolean.FALSE);
    }
}

