/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.order;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OrderBillSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(OrderBillSaveOp.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.saveOrderBill(e);
    }

    private void saveOrderBill(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList orderBills = Lists.newArrayListWithExpectedSize((int)32);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
            String formID = dynamicObjectType.getName();
            Long orderId = (Long)dataEntity.getPkValue();
            String orderNum = dataEntity.getString("ordernum");
            String queryOrderStr = "orderformid=? and ordernum=?";
            Object[] paramObj = new Object[]{formID, orderNum};
            QFilter qFilter = QFilter.of((String)queryOrderStr, (Object[])paramObj);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"er_allorderbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
            DynamicObject orderBill = dynamicObject != null ? BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("id"), (String)"er_allorderbill") : BusinessDataServiceHelper.newDynamicObject((String)"er_allorderbill");
            orderBill.set("orderformid", (Object)formID);
            orderBill.set("orderid", (Object)orderId);
            logger.info("checking formId:" + formID + " orderNum" + orderNum);
            DataEntityPropertyCollection orderProperties = dynamicObjectType.getProperties();
            DataEntityPropertyCollection allOrderProperties = orderBill.getDynamicObjectType().getProperties();
            for (IDataEntityProperty orderProperty : orderProperties) {
                String orderPropName = orderProperty.getName();
                if ("id".equals(orderPropName) || allOrderProperties.get((Object)orderPropName) == null) continue;
                orderBill.set(orderPropName, dataEntity.get(orderPropName));
            }
            orderBills.add(orderBill);
        }
        if (orderBills.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])orderBills.toArray(new DynamicObject[orderBills.size()]));
        }
    }
}

