/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import com.google.common.base.Objects;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.utils.SystemParamterUtil;

public class BillUnSubmitValidator
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("company");
        fieldKeys.add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billEntitys;
                for (ExtendedDataEntity billEntity : billEntitys = this.getDataEntities()) {
                    DynamicObject tripReqData = billEntity.getDataEntity();
                    boolean isAuditRevocationBill = SystemParamterUtil.getIsAuditRevocationBill((long)tripReqData.getLong("company.id"));
                    if (!isAuditRevocationBill && !Objects.equal((Object)"B", (Object)tripReqData.get("billstatus"))) {
                        this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u53ea\u6709\u201c\u63d0\u4ea4\u201d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u64a4\u9500\u3002", (String)"BillUnSubmitValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (!isAuditRevocationBill || Objects.equal((Object)"B", (Object)tripReqData.get("billstatus")) || Objects.equal((Object)"C", (Object)tripReqData.get("billstatus"))) continue;
                    this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u53ea\u6709\u201c\u63d0\u4ea4\u201d\u548c\u201c\u5ba1\u6838\u4e2d\u201d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u64a4\u9500\u3002", (String)"BillUnSubmitValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

