/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripReimWriteBackOrderUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class CancelPayOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(CancelPayOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("approveamount");
        fieldKeys.add("payamount");
        fieldKeys.add("payedamount");
        fieldKeys.add("notpayamount");
        fieldKeys.add("balanceamount");
        fieldKeys.add("formid");
        fieldKeys.add("accountentry.orireceiveamount");
        fieldKeys.add("accountentry.receiveamount");
        fieldKeys.add("accountentry.oriaccbalamount");
        fieldKeys.add("accountentry.accbalamount");
        fieldKeys.add("accountentry.oriaccnotpayamount");
        fieldKeys.add("accountentry.accnotpayamount");
        fieldKeys.add("accountentry.oriaccpayedamount");
        fieldKeys.add("accountentry.accpayedamount");
        fieldKeys.add("accountentry.billstatusfield");
        fieldKeys.add("tripentry.oriaccbalanceamount");
        fieldKeys.add("tripentry.triporiaccappamount");
        fieldKeys.add("tripentry.accbalanceamount");
        fieldKeys.add("tripentry.tripaccappamount");
        fieldKeys.add("head_paydate");
        fieldKeys.add("repaymentdate");
        fieldKeys.add("bizdate");
        fieldKeys.add("accountentry.recsrcbillid");
        fieldKeys.add("accountentry.recsrcentryid");
        fieldKeys.add("company");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity entity : this.getDataEntities()) {
                    DynamicObject dobj = entity.getDataEntity();
                    QFilter q1 = new QFilter("billno", "=", (Object)dobj.getString("billno"));
                    QFilter q2 = new QFilter("formid", "=", (Object)dobj.getDynamicObjectType().getName());
                    if (QueryServiceHelper.exists((String)"er_manualpay", (QFilter[])new QFilter[]{q1, q2})) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u624b\u52a8\u4ed8\u6b3e\u7684\u624d\u53ef\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"CancelPayOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject elem : e.getDataEntities()) {
            elem.set("head_paydate", null);
            if (elem.getDynamicObjectType().getProperty("repaymentdate") != null) {
                elem.set("repaymentdate", (Object)CoreBaseBillServiceHelper.computeRepaymentDate((DynamicObject)elem));
            }
            QFilter q1 = new QFilter("billno", "=", (Object)elem.getString("billno"));
            QFilter q2 = new QFilter("formid", "=", (Object)elem.getDynamicObjectType().getName());
            DynamicObject manualpay = QueryServiceHelper.queryOne((String)"er_manualpay", (String)"id, statusbeforepay", (QFilter[])new QFilter[]{q1, q2});
            Object billStatus = manualpay.get("statusbeforepay");
            elem.set("billStatus", billStatus);
            DeleteServiceHelper.delete((String)"er_manualpay", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)manualpay.getLong("id"))});
            BigDecimal payamount = elem.getBigDecimal("payamount");
            elem.set("notpayamount", (Object)payamount);
            String formid = elem.getString("formid");
            if (this.tripBill(formid) || ErEntityTypeUtils.isDailyLoanBill((String)formid) || this.dailyLoanBill(formid)) {
                elem.set("payamount", (Object)0);
            }
            if (ErEntityTypeUtils.isDailyReimburseBill((String)formid) || ErEntityTypeUtils.isPublicReimburseBill((String)formid)) {
                elem.set("payedamount", (Object)0);
            } else {
                elem.set("balanceamount", (Object)0);
            }
            DynamicObjectCollection accountEntry = elem.getDynamicObjectCollection("accountentry");
            for (DynamicObject accountItem : accountEntry) {
                BigDecimal oriReveiveAmount = accountItem.getBigDecimal("orireceiveamount");
                BigDecimal receiveAmount = accountItem.getBigDecimal("receiveamount");
                accountItem.set("oriaccbalamount", (Object)0);
                accountItem.set("accbalamount", (Object)0);
                accountItem.set("oriaccnotpayamount", (Object)oriReveiveAmount);
                accountItem.set("accnotpayamount", (Object)receiveAmount);
                accountItem.set("oriaccpayedamount", (Object)0);
                accountItem.set("accpayedamount", (Object)0);
                accountItem.set("billstatusfield", (Object)0);
            }
            if (!ErEntityTypeUtils.isTripReqBill((String)elem.getDynamicObjectType().getName())) continue;
            DynamicObjectCollection tripEntry = elem.getDynamicObjectCollection("tripentry");
            for (DynamicObject tripItem : tripEntry) {
                tripItem.set("oriaccbalanceamount", (Object)BigDecimal.ZERO);
                tripItem.set("accbalanceamount", (Object)BigDecimal.ZERO);
            }
        }
    }

    private boolean tripBill(String formid) {
        return ErEntityTypeUtils.isTripReqBill((String)formid) || ErEntityTypeUtils.isTripReimburseBill((String)formid);
    }

    private boolean dailyLoanBill(String formid) {
        return ErEntityTypeUtils.isPrePayBill((String)formid) || ErEntityTypeUtils.isApplyPayBill((String)formid);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String entityNumber;
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            TripReimWriteBackOrderUtil.reimburseStatus((String)dynamicObject.getString("formid"), (Long)dynamicObject.getLong("id"), (String)"B");
        }
        DynamicObject[] billDyObjArray = e.getDataEntities();
        if (billDyObjArray != null && billDyObjArray.length > 0 && (ErEntityTypeUtils.isPrePayBill((String)(entityNumber = billDyObjArray[0].getDynamicObjectType().getName())) || ErEntityTypeUtils.isPublicReimburseBill((String)entityNumber) || ErEntityTypeUtils.isApplyPayBill((String)entityNumber) || ErEntityTypeUtils.isDailyLoanBill((String)entityNumber))) {
            OperateOption option = OperateOption.create();
            Object[] pKids = Arrays.stream(billDyObjArray).map(v -> v.getPkValue()).toArray(Object[]::new);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)entityNumber, (Object[])pKids, (OperateOption)option);
            HashSet recsrcbillid = new HashSet();
            if (operationResult.isSuccess() && ErEntityTypeUtils.isApplyPayBill((String)entityNumber)) {
                Arrays.stream(billDyObjArray).forEach(data -> {
                    DynamicObjectCollection accountentry = data.getDynamicObjectCollection("accountentry");
                    recsrcbillid.addAll(accountentry.stream().map(v -> v.get("recsrcbillid")).collect(Collectors.toSet()));
                });
                DynamicObjectCollection pubColl = QueryServiceHelper.query((String)"er_publicreimbursebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", recsrcbillid)});
                if (pubColl.size() > 0) {
                    OperateOption operateOption;
                    Object[] pubids = pubColl.stream().map(v -> v.get("id")).toArray(Object[]::new);
                    operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)"er_publicreimbursebill", (Object[])pubids, (OperateOption)(operateOption = OperateOption.create()));
                    if (operationResult.isSuccess()) {
                        logger.info("\u624b\u52a8\u53d6\u6d88\u4ed8\u6b3e,\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u5408\u540c\u53f0\u8d26\u6210\u529f\uff01");
                    } else {
                        ValidateResultCollection validateResult = operationResult.getValidateResult();
                        logger.info("\u624b\u52a8\u53d6\u6d88\u4ed8\u6b3e,\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u8d39\u7528\u5408\u540c\u53f0\u8d26\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
                    }
                }
                logger.info("\u624b\u52a8\u53d6\u6d88\u4ed8\u6b3e,\u53cd\u5199\u5408\u540c\u6210\u529f!");
            } else {
                ValidateResultCollection validateResult = operationResult.getValidateResult();
                logger.info("\u624b\u52a8\u53d6\u6d88\u4ed8\u6b3e\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
            }
        }
    }
}

