/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.er.common.ErBillStatusEnum;

public class CancelRepayOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("billstatus");
        fieldKeys.add("totalnotactrecamt");
        fieldKeys.add("amount");
        fieldKeys.add("totalactrecamt");
        fieldKeys.add("totalnotactrecamt");
        fieldKeys.add("repaymententry");
        fieldKeys.add("repaymententry.orirecamount");
        fieldKeys.add("repaymententry.recamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity entity : this.getDataEntities()) {
                    DynamicObject bill = entity.getDataEntity();
                    BigDecimal totalnotactrecamt = bill.getBigDecimal("totalnotactrecamt");
                    if (BigDecimal.ZERO.compareTo(totalnotactrecamt) == 0 && "G".equals(bill.getString("billstatus"))) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u53ea\u6709\u624b\u52a8\u6536\u6b3e\uff0c\u624d\u5141\u8bb8\u53d6\u6d88\u6536\u6b3e\u3002", (String)"CancelRepayOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject bill : e.getDataEntities()) {
            QFilter q1 = new QFilter("billno", "=", (Object)bill.getString("billno"));
            QFilter q2 = new QFilter("formid", "=", (Object)bill.getDynamicObjectType().getName());
            DynamicObject cancelpay = QueryServiceHelper.queryOne((String)"er_manualrepay", (String)"id,statusbeforerepay", (QFilter[])new QFilter[]{q1, q2});
            if (cancelpay != null) {
                Object billStatus = cancelpay.get("statusbeforerepay");
                DeleteServiceHelper.delete((String)"er_manualpay", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cancelpay.getLong("id"))});
                bill.set("billStatus", billStatus);
            } else {
                bill.set("billStatus", (Object)ErBillStatusEnum.E.toString());
            }
            BigDecimal amount = bill.getBigDecimal("amount");
            bill.set("totalactrecamt", (Object)BigDecimal.ZERO);
            bill.set("totalnotactrecamt", (Object)amount);
            DynamicObjectCollection repaymentEntries = bill.getDynamicObjectCollection("repaymententry");
            for (DynamicObject repaymentEntry : repaymentEntries) {
                repaymentEntry.set("orirecamount", (Object)BigDecimal.ZERO);
                repaymentEntry.set("recamount", (Object)BigDecimal.ZERO);
            }
        }
    }
}

