/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.EntityTypeEnum;
import kd.fi.er.validator.AbstractPayByHeadSubmitValidator;
import kd.fi.er.validator.DailyBillPayByHeadSubmitValidator;
import kd.fi.er.validator.TripLoanPayByHeadSubmitValidator;
import kd.fi.er.validator.TripReimPayByHeadSbumitValidator;

public class ErBillPayByHeadSubimitOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        String entityType = this.billEntityType.getName();
        EntityTypeEnum typeEnum = ErEntityTypeUtils.getEntityType((String)entityType);
        AbstractValidator validator = typeEnum != null ? this.getPayByHeadValidator(typeEnum) : new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6269\u5c55\u5355\u636e\u5b9e\u4f53\u7c7b\u578b\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ErBillPayByHeadSubimitOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
        };
        if (validator != null) {
            e.addValidator(validator);
        }
    }

    private AbstractPayByHeadSubmitValidator getPayByHeadValidator(EntityTypeEnum typeEnum) {
        AbstractPayByHeadSubmitValidator validator = null;
        switch (typeEnum) {
            case DAILYLOANBILL: 
            case DAILYREIMBURSEBILL: 
            case PUBLICREIMBURSEBILL: {
                validator = new DailyBillPayByHeadSubmitValidator();
                break;
            }
            case TRIPREQBILL: {
                validator = new TripLoanPayByHeadSubmitValidator();
                break;
            }
            case TRIPREIMBURSEBILL: {
                validator = new TripReimPayByHeadSbumitValidator();
            }
        }
        return validator;
    }
}

