/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ErBillStatusEnum;

public class ErReapymentAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("recentry.recbillno");
        e.getFieldKeys().add("recentry.payeedate");
        e.getFieldKeys().add("recentry.receivingtype");
        e.getFieldKeys().add("recentry.payeebank");
        e.getFieldKeys().add("recentry.accountbank");
        e.getFieldKeys().add("recentry.reccurrency");
        e.getFieldKeys().add("recentry.recexchangerate");
        e.getFieldKeys().add("recentry.oriactrecamt");
        e.getFieldKeys().add("recentry.actrecamt");
        e.getFieldKeys().add("recentry.recbillid");
        e.getFieldKeys().add("recentry.accountname");
        e.getFieldKeys().add("recentry.ismanualrelated");
        e.getFieldKeys().add("repaymententry.orirepayamount");
        e.getFieldKeys().add("repaymententry.repayamount");
        e.getFieldKeys().add("repaymententry.orirecamount");
        e.getFieldKeys().add("repaymententry.recamount");
        e.getFieldKeys().add("totalactrecamt");
        e.getFieldKeys().add("totalnotactrecamt");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection recentryCollectoin = dataEntity.getDynamicObjectCollection("recentry");
            if (recentryCollectoin.isEmpty()) continue;
            BigDecimal totalActrecamt = BigDecimal.ZERO;
            boolean ismanualrelated = ((DynamicObject)recentryCollectoin.get(0)).getBoolean("ismanualrelated");
            if (!ismanualrelated) continue;
            for (int i = 0; i < recentryCollectoin.size(); ++i) {
                BigDecimal actrecamt = ((DynamicObject)recentryCollectoin.get(i)).getBigDecimal("actrecamt");
                totalActrecamt = totalActrecamt.add(actrecamt);
                Long recbillid = ((DynamicObject)recentryCollectoin.get(i)).getLong("recbillid");
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)recbillid, (String)"cas_recbill");
                if (dynamicObject == null) continue;
                DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entry");
                if (!entrys.isEmpty()) {
                    for (int j = 0; j < entrys.size(); ++j) {
                        ((DynamicObject)entrys.get(j)).set("e_sourcebillid", dataEntity.getPkValue());
                        ((DynamicObject)entrys.get(j)).set("e_corebillno", (Object)dataEntity.getString("billno"));
                        ((DynamicObject)entrys.get(j)).set("e_corebilltype", (Object)"er_repaymentbill");
                        ((DynamicObject)entrys.get(j)).set("e_sourcebillentryid", (Object)-1);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            dataEntity.set("totalactrecamt", (Object)totalActrecamt);
            dataEntity.set("totalnotactrecamt", (Object)BigDecimal.ZERO);
            dataEntity.set("billstatus", (Object)ErBillStatusEnum.G.toString());
            DynamicObjectCollection repaymententryCollectoin = dataEntity.getDynamicObjectCollection("repaymententry");
            if (repaymententryCollectoin.isEmpty()) continue;
            for (int i = 0; i < repaymententryCollectoin.size(); ++i) {
                BigDecimal orirepayamount = ((DynamicObject)repaymententryCollectoin.get(i)).getBigDecimal("orirepayamount");
                BigDecimal repayamount = ((DynamicObject)repaymententryCollectoin.get(i)).getBigDecimal("repayamount");
                ((DynamicObject)repaymententryCollectoin.get(i)).set("orirecamount", (Object)orirepayamount);
                ((DynamicObject)repaymententryCollectoin.get(i)).set("recamount", (Object)repayamount);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InnerValidator());
    }

    static class InnerValidator
    extends AbstractValidator {
        InnerValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntitys;
            for (ExtendedDataEntity dataEntity : dataEntitys = this.getDataEntities()) {
                Long companyId = ErCommonUtils.getPk((Object)dataEntity.getDataEntity().get("company"));
                DynamicObjectCollection recentryCollectoin = dataEntity.getDataEntity().getDynamicObjectCollection("recentry");
                if (!SystemParamterUtil.getRepayRelateReceive((Long)companyId) || !recentryCollectoin.isEmpty()) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8fd8\u6b3e\u5355\u672a\u5173\u8054\u6536\u6b3e\u5355\uff0c\u8bf7\u5148\u5173\u8054\u6536\u6b3e\u5355\u3002", (String)"ErRepayMentBillPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }
}

