/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang3.StringUtils;

public class ErReimEntryNotNullCheckOp
extends AbstractOperationServicePlugIn {
    private static final String PAYAMOUNT = "payamount";
    private static final String WRITEOFFAMOUNT = "writeoffamount";
    private static final String WRITEOFF_ENTITY_ID = "writeoffEntityId";
    private static final String ENTRY_ENTITY_ID = "entryEntityId";
    private static final Log logger = LogFactory.getLog(ErReimEntryNotNullCheckOp.class);
    private String BILLSTATUS = "billstatus";
    private String TRIP_PAYAMOUNT = "encashamount";
    private String EXPENSEENTRYENTITY = "expenseentryentity";
    private String TRIPENTRY = "tripentry";
    private String TRIPDETAILENTRY = "tripentry.entryentity";
    private String ACCOUNTENTRY = "accountentry";
    private static Map<Integer, Map<String, String>> recorder;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List list = e.getFieldKeys();
        list.add("approveamount");
        list.add(this.BILLSTATUS);
        list.add(PAYAMOUNT);
        list.add("encashamount");
        list.add(this.TRIP_PAYAMOUNT);
        list.add(this.EXPENSEENTRYENTITY);
        list.add(this.ACCOUNTENTRY);
        list.add(this.TRIPENTRY);
        list.add(this.TRIPDETAILENTRY);
        list.add("totalaccloanamount");
        list.add("writeoffmoney");
        list.add("clearloanentry");
        list.add("checkloanamount");
        list.add("itemfrom");
        list.add("invoiceentry");
        list.add("invoiceitementry");
        list.add("isloan");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ErReimEntryNotNullValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        for (DynamicObject bill : bills = e.getDataEntities()) {
            Map<String, String> reimburseBill = this.isReimburseBill(bill.getDataEntityType().getName());
            if (reimburseBill == null) continue;
            this.recordEntryCount(e.getOperationKey(), bill);
        }
    }

    private void recordEntryCount(String operateKey, DynamicObject dataEntity) {
        DynamicObjectType type = dataEntity.getDynamicObjectType();
        DataEntityPropertyCollection properties = type.getProperties();
        StringBuilder sb = new StringBuilder();
        sb.append("bill entityid\uff1a").append(dataEntity.getDataEntityType().getName()).append(",pk:").append(dataEntity.getPkValue()).append("\u3002invoke\uff1a").append(operateKey).append(",verify information\uff1a");
        for (int i = 0; i < properties.size(); ++i) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get(i);
            if (!(iDataEntityProperty instanceof EntryProp)) continue;
            sb.append("ek:[").append(iDataEntityProperty.getName()).append("]:c{").append(((DynamicObjectCollection)iDataEntityProperty.getValue((Object)dataEntity)).size()).append("};");
        }
        logger.info(sb.toString());
    }

    private Map<String, String> isReimburseBill(String entityId) {
        int i = 0;
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            i = 1;
        } else if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            i = 2;
        } else if (ErEntityTypeUtils.isDailyLoanBill((String)entityId) || ErEntityTypeUtils.isPrePayBill((String)entityId)) {
            i = 3;
        } else if (ErEntityTypeUtils.isTripReqBill((String)entityId)) {
            i = 4;
        } else if (ErEntityTypeUtils.isDailyApplyBill((String)entityId) || ErEntityTypeUtils.isApplyProjectBill((String)entityId)) {
            i = 5;
        }
        return recorder.get(i);
    }

    static {
        HashMap<String, String> ReimIdRecord = new HashMap<String, String>();
        ReimIdRecord.put(ENTRY_ENTITY_ID, "expenseentryentity");
        ReimIdRecord.put(PAYAMOUNT, PAYAMOUNT);
        ReimIdRecord.put(WRITEOFFAMOUNT, "totalaccloanamount");
        ReimIdRecord.put(WRITEOFF_ENTITY_ID, "writeoffmoney");
        HashMap<String, String> TripReimIdRecord = new HashMap<String, String>();
        TripReimIdRecord.put(ENTRY_ENTITY_ID, "tripentry");
        TripReimIdRecord.put(PAYAMOUNT, "encashamount");
        TripReimIdRecord.put(WRITEOFF_ENTITY_ID, "clearloanentry");
        TripReimIdRecord.put(WRITEOFFAMOUNT, "checkloanamount");
        HashMap<String, String> loanRecord = new HashMap<String, String>();
        loanRecord.put(ENTRY_ENTITY_ID, "expenseentryentity");
        loanRecord.put(PAYAMOUNT, "approveamount");
        HashMap<String, String> tripReqRecord = new HashMap<String, String>();
        tripReqRecord.put(ENTRY_ENTITY_ID, "tripentry");
        tripReqRecord.put(PAYAMOUNT, "approveamount");
        tripReqRecord.put("isloan", "isloan");
        HashMap<String, String> applyRecord = new HashMap<String, String>();
        applyRecord.put(ENTRY_ENTITY_ID, "expenseentryentity");
        recorder = new HashMap<Integer, Map<String, String>>();
        recorder.put(1, ReimIdRecord);
        recorder.put(2, TripReimIdRecord);
        recorder.put(3, loanRecord);
        recorder.put(4, tripReqRecord);
        recorder.put(5, applyRecord);
    }

    class ErReimEntryNotNullValidator
    extends AbstractValidator {
        ErReimEntryNotNullValidator() {
        }

        private boolean entrysValidate(ExtendedDataEntity extendedDataEntity) {
            Map reimburseBill;
            boolean stop = false;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String entityId = dataEntity.getDataEntityType().getName();
            String operateType = this.getOperateType();
            if (StringUtils.equalsAny((CharSequence)operateType, (CharSequence[])new CharSequence[]{"delete", "unaudit", "unsubmit"})) {
                return false;
            }
            if (!(StringUtils.equals((CharSequence)this.getOperateKey(), (CharSequence)"save") && this.isSkipStatus(dataEntity) || (reimburseBill = ErReimEntryNotNullCheckOp.this.isReimburseBill(entityId)) == null)) {
                DynamicObjectCollection writeOffMoneyCollection;
                BigDecimal writeoffamount;
                DynamicObjectCollection entryentity;
                DynamicObjectCollection accountentry;
                BigDecimal payamount;
                String payAmountField = (String)reimburseBill.get(ErReimEntryNotNullCheckOp.PAYAMOUNT);
                if (payAmountField != null && BigDecimal.ZERO.compareTo(payamount = dataEntity.getBigDecimal(payAmountField)) != 0 && ((accountentry = dataEntity.getDynamicObjectCollection(ErReimEntryNotNullCheckOp.this.ACCOUNTENTRY)) == null || accountentry.isEmpty()) && (reimburseBill.get("isloan") == null || dataEntity.getBoolean("isloan"))) {
                    String s1 = ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f", (String)"ErReimEntryNotNullCheckOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff1a%2$s\u4e3a\u7a7a\u3002", (String)"ErReimEntryNotNullCheckOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]), this.getOperationName(), s1));
                    stop = true;
                }
                if ((entryentity = dataEntity.getDynamicObjectCollection((String)reimburseBill.get(ErReimEntryNotNullCheckOp.ENTRY_ENTITY_ID))) == null || entryentity.isEmpty()) {
                    String entry_zh_CN = ((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get(reimburseBill.get(ErReimEntryNotNullCheckOp.ENTRY_ENTITY_ID))).getDisplayName().getLocaleValue();
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff1a%2$s\u4e3a\u7a7a\u3002", (String)"ErReimEntryNotNullCheckOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]), this.getOperationName(), entry_zh_CN));
                    stop = true;
                }
                if (dataEntity.getDynamicObjectType().getProperty((String)reimburseBill.get(ErReimEntryNotNullCheckOp.WRITEOFF_ENTITY_ID)) != null && (writeoffamount = dataEntity.getBigDecimal((String)reimburseBill.get(ErReimEntryNotNullCheckOp.WRITEOFFAMOUNT))).compareTo(BigDecimal.ZERO) > 0 && (writeOffMoneyCollection = dataEntity.getDynamicObjectCollection((String)reimburseBill.get(ErReimEntryNotNullCheckOp.WRITEOFF_ENTITY_ID))).isEmpty()) {
                    String entry_zh_CN = ((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get(reimburseBill.get(ErReimEntryNotNullCheckOp.WRITEOFF_ENTITY_ID))).getDisplayName().getLocaleValue();
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff1a%2$s\u6570\u636e\u5f02\u5e38\uff0c\u82e5\u9875\u9762\u4e0a\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ErReimEntryNotNullCheckOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]), this.getOperationName(), entry_zh_CN));
                    stop = true;
                }
            }
            return stop;
        }

        private boolean fromInvoiceCloud(DynamicObject entry, ExtendedDataEntity extendedDataEntity) {
            boolean fromInvoiceCloud = ItemFrom.InvoiceCloud.getValue().equals(entry.getString("itemfrom"));
            if (fromInvoiceCloud) {
                String entry_zh_CN = ((IDataEntityProperty)extendedDataEntity.getDataEntity().getDataEntityType().getProperties().get((Object)"invoiceentry")).getDisplayName().getLocaleValue();
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff1a%2$s\u6570\u636e\u5f02\u5e38\uff0c\u82e5\u9875\u9762\u4e0a\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ErReimEntryNotNullCheckOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]), this.getOperationName(), entry_zh_CN));
            }
            return fromInvoiceCloud;
        }

        private boolean isSkipStatus(DynamicObject dataEntity) {
            String billStatus = dataEntity.getString("billstatus");
            return StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A", "D"});
        }

        public void validate() {
            ExtendedDataEntity[] extendedDataEntities;
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = this.getDataEntities()) {
                this.entrysValidate(extendedDataEntity);
            }
        }
    }
}

