/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ErTripReqLoanBillManualRepayOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("balanceamount");
        fieldKeys.add("returnedamount");
        fieldKeys.add("approveamount");
        fieldKeys.add("ismanualrepay");
        fieldKeys.add("usedamount");
        fieldKeys.add("triporiaccappamount");
        fieldKeys.add("tripaccappamount");
        fieldKeys.add("triporiamount");
        fieldKeys.add("tripamount");
        fieldKeys.add("accusedamount");
        fieldKeys.add("oriaccusedamount");
        fieldKeys.add("experepayamount");
        fieldKeys.add("expeorirepayamount");
        fieldKeys.add("accbalanceamount");
        fieldKeys.add("oriaccbalanceamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billEntities;
                for (ExtendedDataEntity billEntity : billEntities = this.getDataEntities()) {
                    String entityName;
                    Map targetBills;
                    Long billPkId = (Long)billEntity.getBillPkId();
                    DynamicObject bill = billEntity.getDataEntity();
                    if (!StringUtils.equals((CharSequence)"G", (CharSequence)bill.getString("billstatus"))) {
                        this.addFatalErrorMessage(billEntity, ResManager.loadKDString((String)"\u975e\u5df2\u4ed8\u6b3e\u72b6\u6001\u5355\u636e\uff0c\u65e0\u9700\u624b\u52a8\u8fd8\u6b3e\u3002", (String)"ErTripReqLoanBillManualRepayOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    }
                    if (!CollectionUtils.isEmpty((Map)(targetBills = BFTrackerServiceHelper.findTargetBills((String)(entityName = bill.getDataEntityType().getName()), (Long[])new Long[]{billPkId}))) && (targetBills.containsKey("cas_paybill") || targetBills.containsKey("cas_agentpaybill"))) {
                        this.preDealTargetBills("cas_paybill", targetBills);
                        this.preDealTargetBills("cas_agentpaybill", targetBills);
                    }
                    for (Map.Entry tBill : targetBills.entrySet()) {
                        Set tBillIds;
                        QFilter idFilter;
                        QFilter statusFilter;
                        String tBillEntityId = (String)tBill.getKey();
                        DynamicObject targetBillDym = QueryServiceHelper.queryOne((String)tBillEntityId, (String)"id", (QFilter[])new QFilter[]{statusFilter = new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C", "D"}), idFilter = new QFilter("id", "in", (Object)(tBillIds = (Set)tBill.getValue()))});
                        if (targetBillDym == null) continue;
                        this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u4e0b\u6e38\u5b58\u5728\u5728\u9014\u5355\u636e\uff0c\u65e0\u6cd5\u624b\u52a8\u8fd8\u6b3e\u3002", (String)"ErTripReqLoanBillManualRepayOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    }
                }
            }

            private void preDealTargetBills(String entityName, Map<String, HashSet<Long>> targetBills) {
                Set<String> entityNameSet = targetBills.keySet();
                HashSet<Long> payBillIds = targetBills.get(entityName);
                if (CollectionUtils.isEmpty(payBillIds)) {
                    return;
                }
                Map downCasPayBills = BFTrackerServiceHelper.findTargetBills((String)entityName, (Long[])payBillIds.toArray(new Long[0]));
                for (String next : entityNameSet) {
                    if (!downCasPayBills.containsKey(next)) continue;
                    targetBills.remove(next);
                }
                targetBills.remove(entityName);
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject loanBill : e.getDataEntities()) {
            BigDecimal headRepayed = loanBill.getBigDecimal("returnedamount");
            BigDecimal headReimbursed = loanBill.getBigDecimal("usedamount");
            BigDecimal headApproveAmount = loanBill.getBigDecimal("approveamount");
            String repayCase = "both";
            loanBill.set("billstatus", (Object)"I");
            loanBill.set("ismanualrepay", (Object)Boolean.TRUE);
            if (headReimbursed.compareTo(BigDecimal.ZERO) != 0) {
                repayCase = "reimburse";
                loanBill.set("balanceamount", (Object)BigDecimal.ZERO);
                loanBill.set("returnedamount", (Object)headApproveAmount.subtract(headReimbursed));
                if (headRepayed.compareTo(BigDecimal.ZERO) != 0) {
                    repayCase = "both";
                }
            } else {
                repayCase = "repay";
                loanBill.set("balanceamount", (Object)BigDecimal.ZERO);
                loanBill.set("returnedamount", (Object)headApproveAmount);
                if (headRepayed.compareTo(BigDecimal.ZERO) == 0) {
                    repayCase = "neither";
                }
            }
            DynamicObjectCollection loanDetailEntry = loanBill.getDynamicObjectCollection("tripentry");
            for (DynamicObject loanDetail : loanDetailEntry) {
                BigDecimal detailAppOriAmount = loanDetail.getBigDecimal("triporiaccappamount");
                BigDecimal detailAppAmount = loanDetail.getBigDecimal("tripaccappamount");
                BigDecimal detailReimburseAmount = loanDetail.getBigDecimal("accusedamount");
                BigDecimal detailReimburseOriAmount = loanDetail.getBigDecimal("oriaccusedamount");
                switch (repayCase) {
                    case "both": 
                    case "reimburse": {
                        loanDetail.set("expeorirepayamount", (Object)detailAppOriAmount.subtract(detailReimburseOriAmount));
                        loanDetail.set("experepayamount", (Object)detailAppAmount.subtract(detailReimburseAmount));
                        loanDetail.set("oriaccbalanceamount", (Object)BigDecimal.ZERO);
                        loanDetail.set("accbalanceamount", (Object)BigDecimal.ZERO);
                        break;
                    }
                    case "repay": 
                    case "neither": {
                        loanDetail.set("expeorirepayamount", (Object)detailAppOriAmount);
                        loanDetail.set("experepayamount", (Object)detailAppAmount);
                        loanDetail.set("accbalanceamount", (Object)BigDecimal.ZERO);
                        loanDetail.set("oriaccbalanceamount", (Object)BigDecimal.ZERO);
                        break;
                    }
                }
            }
        }
    }
}

