/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;

public class ErTripReqLoanBillManualRepayRollbackOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billstatus");
        fieldKeys.add("balanceamount");
        fieldKeys.add("returnedamount");
        fieldKeys.add("approveamount");
        fieldKeys.add("ismanualrepay");
        fieldKeys.add("triporiaccappamount");
        fieldKeys.add("tripaccappamount");
        fieldKeys.add("triporiamount");
        fieldKeys.add("tripamount");
        fieldKeys.add("accusedamount");
        fieldKeys.add("oriaccusedamount");
        fieldKeys.add("experepayamount");
        fieldKeys.add("expeorirepayamount");
        fieldKeys.add("accbalanceamount");
        fieldKeys.add("oriaccbalanceamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billEntities;
                for (ExtendedDataEntity billEntity : billEntities = this.getDataEntities()) {
                    DynamicObject bill = billEntity.getDataEntity();
                    boolean isManualRepay = bill.getBoolean("ismanualrepay");
                    if (isManualRepay) continue;
                    this.addFatalErrorMessage(billEntity, ResManager.loadKDString((String)"\u975e\u624b\u52a8\u8fd8\u6b3e\u7684\u5355\u636e\uff0c\u65e0\u9700\u53d6\u6d88\u8fd8\u6b3e\u3002", (String)"ErTripReqLoanBillManualRepayRollbackOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject loanBill : e.getDataEntities()) {
            BigDecimal headRepayed = loanBill.getBigDecimal("returnedamount");
            loanBill.set("billstatus", (Object)"G");
            loanBill.set("ismanualrepay", (Object)Boolean.FALSE);
            loanBill.set("balanceamount", (Object)headRepayed);
            loanBill.set("returnedamount", (Object)BigDecimal.ZERO);
            DynamicObjectCollection loanDetailEntry = loanBill.getDynamicObjectCollection("tripentry");
            for (DynamicObject loanDetail : loanDetailEntry) {
                BigDecimal detailRepayAmount = loanDetail.getBigDecimal("experepayamount");
                BigDecimal detailOriRepayAmount = loanDetail.getBigDecimal("expeorirepayamount");
                loanDetail.set("accbalanceamount", (Object)detailRepayAmount);
                loanDetail.set("oriaccbalanceamount", (Object)detailOriRepayAmount);
                loanDetail.set("expeorirepayamount", (Object)BigDecimal.ZERO);
                loanDetail.set("experepayamount", (Object)BigDecimal.ZERO);
            }
        }
    }
}

