/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.message.ErMessageServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripReimWriteBackOrderUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ErBillStatusEnum;

public class ManualPayOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ManualPayOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("company.id");
        fieldKeys.add("formid");
        fieldKeys.add("creator");
        fieldKeys.add("approveamount");
        fieldKeys.add("payamount");
        fieldKeys.add("encashamount");
        fieldKeys.add("payedamount");
        fieldKeys.add("notpayamount");
        fieldKeys.add("balanceamount");
        fieldKeys.add("paycompany");
        fieldKeys.add("billstatus");
        fieldKeys.add("accountentry.orireceiveamount");
        fieldKeys.add("accountentry.receiveamount");
        fieldKeys.add("accountentry.oriaccbalamount");
        fieldKeys.add("accountentry.accbalamount");
        fieldKeys.add("accountentry.oriaccnotpayamount");
        fieldKeys.add("accountentry.accnotpayamount");
        fieldKeys.add("accountentry.oriaccpayedamount");
        fieldKeys.add("accountentry.accpayedamount");
        fieldKeys.add("accountentry.billstatusfield");
        fieldKeys.add("tripentry.oriaccbalanceamount");
        fieldKeys.add("tripentry.triporiaccappamount");
        fieldKeys.add("tripentry.accbalanceamount");
        fieldKeys.add("tripentry.tripaccappamount");
        fieldKeys.add("head_paydate");
        fieldKeys.add("repaymentdate");
        fieldKeys.add("bizdate");
        fieldKeys.add("applier");
        fieldKeys.add("accountentry.recsrcbillid");
        fieldKeys.add("accountentry.recsrcentryid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity entity : this.getDataEntities()) {
                    String billstatus;
                    DynamicObject dobj = entity.getDataEntity();
                    BigDecimal encashedAmount = ManualPayOp.this.getEncashedAmount(dobj);
                    if (BigDecimal.ZERO.compareTo(encashedAmount) >= 0) {
                        this.addErrorMessage(entity, ResManager.loadKDString((String)"\u4ed8\u73b0\u91d1\u989d\u5927\u4e8e0\u624d\u80fd\u624b\u52a8\u4ed8\u6b3e\u3002", (String)"ManualPayOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    }
                    if (!"G".equals(billstatus = dobj.getString("billstatus"))) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u4ed8\u6b3e\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u91cd\u590d\u624b\u52a8\u4ed8\u6b3e\u3002", (String)"ManualPayOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] billDyObjArray = e.getDataEntities();
        if (billDyObjArray != null && billDyObjArray.length > 0) {
            String entityNumber = billDyObjArray[0].getDynamicObjectType().getName();
            ErMessageServiceHelper.sendMessage((DynamicObject[])billDyObjArray, (String)entityNumber, (String)"applier", (String)"er_cas_pay");
            if (ErEntityTypeUtils.isPrePayBill((String)entityNumber) || ErEntityTypeUtils.isPublicReimburseBill((String)entityNumber) || ErEntityTypeUtils.isApplyPayBill((String)entityNumber) || ErEntityTypeUtils.isDailyLoanBill((String)entityNumber)) {
                OperateOption option = OperateOption.create();
                Object[] pKids = Arrays.stream(billDyObjArray).map(v -> v.getPkValue()).toArray(Object[]::new);
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)entityNumber, (Object[])pKids, (OperateOption)option);
                HashSet recsrcbillid = new HashSet();
                if (operationResult.isSuccess() && ErEntityTypeUtils.isApplyPayBill((String)entityNumber)) {
                    Arrays.stream(billDyObjArray).forEach(data -> {
                        DynamicObjectCollection accountentry = data.getDynamicObjectCollection("accountentry");
                        recsrcbillid.addAll(accountentry.stream().map(v -> v.get("recsrcbillid")).collect(Collectors.toSet()));
                    });
                    DynamicObjectCollection pubColl = QueryServiceHelper.query((String)"er_publicreimbursebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", recsrcbillid)});
                    if (pubColl.size() > 0) {
                        OperateOption operateOption;
                        Object[] pubids = pubColl.stream().map(v -> v.get("id")).toArray(Object[]::new);
                        operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)"er_publicreimbursebill", (Object[])pubids, (OperateOption)(operateOption = OperateOption.create()));
                        if (operationResult.isSuccess()) {
                            logger.info("\u624b\u52a8\u4ed8\u6b3e,\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u5408\u540c\u53f0\u8d26\u6210\u529f\uff01");
                        } else {
                            ValidateResultCollection validateResult = operationResult.getValidateResult();
                            logger.info("\u624b\u52a8\u4ed8\u6b3e,\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u8d39\u7528\u5408\u540c\u53f0\u8d26\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
                        }
                    }
                    logger.info("\u624b\u52a8\u4ed8\u6b3e,\u53cd\u5199\u5408\u540c\u6210\u529f!");
                } else {
                    ValidateResultCollection validateResult = operationResult.getValidateResult();
                    logger.info("\u624b\u52a8\u4ed8\u6b3e\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
                }
            }
        }
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            TripReimWriteBackOrderUtil.reimburseStatus((String)dynamicObject.getString("formid"), (Long)dynamicObject.getLong("id"), (String)"C");
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (ExtendedDataEntity entity : e.getValidExtDataEntities()) {
            DynamicObject elem = entity.getDataEntity();
            QFilter q1 = new QFilter("billno", "=", (Object)elem.getString("billno"));
            QFilter q2 = new QFilter("formid", "=", (Object)elem.getDynamicObjectType().getName());
            DynamicObject[] records = BusinessDataServiceHelper.load((String)"er_manualpay", (String)"statusbeforepay", (QFilter[])new QFilter[]{q1, q2});
            DynamicObject record = null;
            if (records.length > 0) {
                record = records[0];
            } else {
                record = BusinessDataServiceHelper.newDynamicObject((String)"er_manualpay");
                record.set("billno", elem.get("billno"));
                record.set("formid", (Object)elem.getDynamicObjectType().getName());
            }
            record.set("statusbeforepay", elem.get("billstatus"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        }
        for (DynamicObject bill : e.getDataEntities()) {
            if (bill.getDynamicObjectType().getProperty("head_paydate") != null && bill.get("billstatus").equals(ErBillStatusEnum.E.name())) {
                Date payDate = new Date();
                bill.set("head_paydate", (Object)payDate);
            }
            Long companyId = ErCommonUtils.getPk((Object)bill.get("company"));
            if (bill.getDynamicObjectType().getProperty("repaymentdate") == null || companyId == null || SystemParamterUtil.getRepaymentDateBase((long)companyId) != 1) continue;
            bill.set("repaymentdate", (Object)CoreBaseBillServiceHelper.computeRepaymentDate((DynamicObject)bill));
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject elem : e.getDataEntities()) {
            BigDecimal encashamount = this.getEncashedAmount(elem);
            String formid = elem.getString("formid");
            if (this.tripBill(formid) || ErEntityTypeUtils.isDailyLoanBill((String)formid) || ErEntityTypeUtils.isPrePayBill((String)formid) || ErEntityTypeUtils.isApplyPayBill((String)formid)) {
                elem.set("payamount", (Object)encashamount);
            }
            if (ErEntityTypeUtils.isDailyReimburseBill((String)formid) || ErEntityTypeUtils.isPublicReimburseBill((String)formid)) {
                elem.set("payedamount", (Object)encashamount);
            } else {
                elem.set("balanceamount", (Object)encashamount);
            }
            elem.set("notpayamount", (Object)0);
            DynamicObjectCollection accountEntry = elem.getDynamicObjectCollection("accountentry");
            for (DynamicObject accountItem : accountEntry) {
                BigDecimal oriReveiveAmount = accountItem.getBigDecimal("orireceiveamount");
                BigDecimal receiveAmount = accountItem.getBigDecimal("receiveamount");
                accountItem.set("oriaccbalamount", (Object)oriReveiveAmount);
                accountItem.set("accbalamount", (Object)receiveAmount);
                accountItem.set("oriaccnotpayamount", (Object)0);
                accountItem.set("accnotpayamount", (Object)0);
                accountItem.set("oriaccpayedamount", (Object)oriReveiveAmount);
                accountItem.set("accpayedamount", (Object)receiveAmount);
                accountItem.set("billstatusfield", (Object)"G");
            }
            if (!ErEntityTypeUtils.isTripReqBill((String)elem.getDynamicObjectType().getName())) continue;
            DynamicObjectCollection tripEntry = elem.getDynamicObjectCollection("tripentry");
            for (DynamicObject tripItem : tripEntry) {
                tripItem.set("oriaccbalanceamount", (Object)tripItem.getBigDecimal("triporiaccappamount"));
                tripItem.set("accbalanceamount", (Object)tripItem.getBigDecimal("tripaccappamount"));
            }
        }
    }

    private BigDecimal getEncashedAmount(DynamicObject elem) {
        String formid = elem.getDynamicObjectType().getName();
        if (this.dailyBill(formid)) {
            return elem.getBigDecimal("payamount");
        }
        if (this.dailyLoanBill(formid)) {
            return elem.getBigDecimal("approveamount");
        }
        if (this.tripBill(formid)) {
            return elem.getBigDecimal("encashamount");
        }
        String msg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5355\u636e\u7c7b\u578b\u3002", (String)"ManualPayOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]);
        throw new KDBizException(new ErrorCode(msg, "%s"), new Object[]{formid});
    }

    private boolean dailyBill(String formid) {
        return ErEntityTypeUtils.isDailyReimburseBill((String)formid) || ErEntityTypeUtils.isPublicReimburseBill((String)formid);
    }

    private boolean dailyLoanBill(String formid) {
        return ErEntityTypeUtils.isDailyLoanBill((String)formid) || ErEntityTypeUtils.isPrePayBill((String)formid) || ErEntityTypeUtils.isApplyPayBill((String)formid);
    }

    private boolean tripBill(String formid) {
        return ErEntityTypeUtils.isTripReqBill((String)formid) || ErEntityTypeUtils.isTripReimburseBill((String)formid);
    }
}

