/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.share.befshare.BeforeShareBillGeneratorFactory;

public class TripReimburseAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(TripReimburseAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("isloan");
        fieldKeys.add("tripentry");
        fieldKeys.add("clearloanentry");
        fieldKeys.add("costcompany");
        fieldKeys.add("costdept");
        fieldKeys.add("entryentity");
        fieldKeys.add("orderformid");
        fieldKeys.add("ordernum");
        fieldKeys.add("reqaccountentryid");
        fieldKeys.add("loanclearamount");
        fieldKeys.add("loanclearoriamount");
        fieldKeys.add("snaploanclearamount");
        fieldKeys.add("snaploanclearoriamount");
        fieldKeys.add("accbalamount");
        fieldKeys.add("oriaccbalamount");
        fieldKeys.add("billno");
        fieldKeys.add("isapprove");
        fieldKeys.add("expcommitcomnum");
        fieldKeys.add("expcommitdepnum");
        fieldKeys.add("tripentry");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("company");
        fieldKeys.add("costcompany");
        fieldKeys.add("costdept");
        fieldKeys.add("billno");
        fieldKeys.add("entryentity");
        fieldKeys.add("orderformid");
        fieldKeys.add("ordernum");
        fieldKeys.add("provider");
        fieldKeys.add("enddate");
        fieldKeys.add("billkind");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity entity : this.getDataEntities()) {
                    DynamicObject dynamicObject = entity.getDataEntity();
                    DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("tripentry");
                    String billKind = dynamicObject.getString("billkind");
                    for (int i = 0; i < dynamicObjects.size(); ++i) {
                        DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                        if (!"0".equals(billKind) || null != entry.getDate("enddate")) continue;
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u884c\u7a0b\u4fe1\u606f\u201c\u7ed3\u675f\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TripReimburseAuditOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1));
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.handleBeforeShare(e);
    }

    private void handleBeforeShare(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        Set reimBillIds = Stream.of(dataEntities).map(v -> v.getPkValue()).collect(Collectors.toSet());
        BeforeShareBillGeneratorFactory.get((String)"er_tripreimbursebill").genBeforeShareBill(reimBillIds);
    }
}

