/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.validator.TripStandardSaveValidator;
import org.apache.commons.lang.StringUtils;

public class TripStandardSaveOp
extends AbstractOperationServicePlugIn {
    private static Map<String, String> airCabinMap = Collections.unmodifiableMap(Stream.of({ResManager.loadKDString((String)"\u5934\u7b49\u8231", (String)"TripStandardSaveOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]), "10"}, {ResManager.loadKDString((String)"\u5546\u52a1\u8231", (String)"TripStandardSaveOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]), "20"}, {ResManager.loadKDString((String)"\u7ecf\u6d4e\u8231", (String)"TripStandardSaveOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]), "30"}).collect(Collectors.toMap(item -> item[0], item -> item[1])));
    private static Map<String, String> trainCabinMap = Collections.unmodifiableMap(Stream.of({ResManager.loadKDString((String)"\u7279\u7b49\u5ea7", (String)"TripStandardSaveOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]), "00"}, {ResManager.loadKDString((String)"\u5546\u52a1\u5ea7", (String)"TripStandardSaveOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]), "11"}, {ResManager.loadKDString((String)"\u4e00\u7b49\u5ea7", (String)"TripStandardSaveOp_5", (String)"fi-er-opplugin", (Object[])new Object[0]), "12"}, {ResManager.loadKDString((String)"\u4e8c\u7b49\u5ea7", (String)"TripStandardSaveOp_6", (String)"fi-er-opplugin", (Object[])new Object[0]), "13"}, {ResManager.loadKDString((String)"\u52a8\u5367", (String)"TripStandardSaveOp_7", (String)"fi-er-opplugin", (Object[])new Object[0]), "14"}, {ResManager.loadKDString((String)"\u9ad8\u7ea7\u8f6f\u5367", (String)"TripStandardSaveOp_8", (String)"fi-er-opplugin", (Object[])new Object[0]), "15"}, {ResManager.loadKDString((String)"\u8f6f\u5367", (String)"TripStandardSaveOp_9", (String)"fi-er-opplugin", (Object[])new Object[0]), "16"}, {ResManager.loadKDString((String)"\u786c\u5367", (String)"TripStandardSaveOp_10", (String)"fi-er-opplugin", (Object[])new Object[0]), "17"}, {ResManager.loadKDString((String)"\u8f6f\u5ea7", (String)"TripStandardSaveOp_11", (String)"fi-er-opplugin", (Object[])new Object[0]), "18"}, {ResManager.loadKDString((String)"\u786c\u5ea7", (String)"TripStandardSaveOp_12", (String)"fi-er-opplugin", (Object[])new Object[0]), "19"}, {ResManager.loadKDString((String)"\u65e0\u5ea7", (String)"TripStandardSaveOp_13", (String)"fi-er-opplugin", (Object[])new Object[0]), "20"}).collect(Collectors.toMap(item -> item[0], item -> item[1])));
    private static Map<String, String> shipCabinMap = Collections.unmodifiableMap(Stream.of({ResManager.loadKDString((String)"\u7279\u7b49\u8231", (String)"TripStandardSaveOp_14", (String)"fi-er-opplugin", (Object[])new Object[0]), "21"}, {ResManager.loadKDString((String)"\u4e00\u7b49\u8231", (String)"TripStandardSaveOp_15", (String)"fi-er-opplugin", (Object[])new Object[0]), "22"}, {ResManager.loadKDString((String)"\u4e8c\u7b49\u8231", (String)"TripStandardSaveOp_16", (String)"fi-er-opplugin", (Object[])new Object[0]), "23"}, {ResManager.loadKDString((String)"\u4e09\u7b49\u8231", (String)"TripStandardSaveOp_17", (String)"fi-er-opplugin", (Object[])new Object[0]), "24"}, {ResManager.loadKDString((String)"\u56db\u7b49\u8231", (String)"TripStandardSaveOp_18", (String)"fi-er-opplugin", (Object[])new Object[0]), "25"}, {ResManager.loadKDString((String)"\u4e94\u7b49\u8231", (String)"TripStandardSaveOp_19", (String)"fi-er-opplugin", (Object[])new Object[0]), "26"}, {ResManager.loadKDString((String)"\u5750\u5e2d", (String)"TripStandardSaveOp_20", (String)"fi-er-opplugin", (Object[])new Object[0]), "27"}).collect(Collectors.toMap(item -> item[0], item -> item[1])));

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new TripStandardSaveValidator());
        if ("er_tripstandard_vehicle".equals(e.getDataEntities()[0].getDataEntityType().getName())) {
            e.addValidator(new AbstractValidator(){

                public void validate() {
                    ExtendedDataEntity[] dataEntities;
                    for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
                        if (TripStandardSaveOp.this.handleImportData(extendedDataEntity.getDataEntity())) continue;
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8231\u4f4d\u6570\u636e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"TripStandardSaveOp_01", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    }
                }
            });
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            this.handleReimburseLevel(dataEntity);
        }
    }

    private void handleReimburseLevel(DynamicObject dataEntity) {
        String reimlevelStr;
        DynamicObjectCollection reimburselevelColl = (DynamicObjectCollection)dataEntity.get("reimburselevel");
        ArrayList<String> tmpNames = new ArrayList<String>();
        if (reimburselevelColl != null && reimburselevelColl.size() > 0) {
            for (DynamicObject reimburselevel : reimburselevelColl) {
                DynamicObject reimburselevelObject = reimburselevel.getDynamicObject("fbasedataid");
                tmpNames.add(reimburselevelObject.getLocaleString("name").getLocaleValue());
            }
        }
        if ((reimlevelStr = StringUtils.join(tmpNames, (String)",")).length() > 100) {
            reimlevelStr = reimlevelStr.substring(0, 97);
            reimlevelStr = reimlevelStr + "...";
        }
        dataEntity.set("reimburselevelstr", (Object)reimlevelStr);
    }

    private boolean handleImportData(DynamicObject dataEntity) {
        Map<String, String> cabinMap;
        if (dataEntity.getString("cabin") != null) {
            return true;
        }
        String standardType = dataEntity.getString("standardtype");
        StringBuilder cabin = new StringBuilder();
        Set cabinSet = Arrays.stream(dataEntity.getString("cabinstr").split(",")).collect(Collectors.toSet());
        switch (standardType) {
            case "air": {
                cabinMap = airCabinMap;
                break;
            }
            case "train": {
                cabinMap = trainCabinMap;
                break;
            }
            case "ship": {
                cabinMap = shipCabinMap;
                break;
            }
            default: {
                return false;
            }
        }
        for (String cabinName : cabinSet) {
            if (!cabinMap.containsKey(cabinName)) {
                return false;
            }
            cabin.append(cabinMap.get(cabinName)).append(",");
        }
        cabin.deleteCharAt(cabin.lastIndexOf(","));
        dataEntity.set("cabin", (Object)cabin.toString());
        return true;
    }
}

