/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

class payerBankCheck
extends AbstractValidator {
    payerBankCheck() {
    }

    public void validate() {
        ExtendedDataEntity[] dataEntitys;
        for (ExtendedDataEntity dataEntity : dataEntitys = this.getDataEntities()) {
            int entryRowCount;
            DynamicObject payerbank = dataEntity.getDataEntity().getDynamicObject("payerbank");
            if (payerbank != null && !payerbank.getBoolean("enable")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\u5df2\u7981\u7528\u3002", (String)"ErReapymentSubmitOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            Long companyId = ErCommonUtils.getPk((Object)dataEntity.getDataEntity().get("company"));
            DynamicObjectCollection recentryCollectoin = dataEntity.getDataEntity().getDynamicObjectCollection("recentry");
            int n = entryRowCount = !recentryCollectoin.isEmpty() ? recentryCollectoin.size() : 0;
            if (SystemParamterUtil.getRepayRelateReceive((Long)companyId) && StringUtils.equals((CharSequence)"approveandsubmit", (CharSequence)this.getOperateKey()) && entryRowCount < 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8fd8\u6b3e\u5355\u672a\u5173\u8054\u6536\u6b3e\u5355\uff0c\u8bf7\u5148\u5173\u8054\u6536\u6b3e\u5355\u3002", (String)"ErRepayMentBillPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            if (entryRowCount < 1) continue;
            for (int i = 0; i < recentryCollectoin.size(); ++i) {
                String recbillno = ((DynamicObject)recentryCollectoin.get(i)).getString("recbillno");
                Long billid = (Long)dataEntity.getDataEntity().getPkValue();
                QFilter qFilter = new QFilter("recentry.recbillno", "=", (Object)recbillno).and("id", "!=", (Object)billid);
                System.out.println("---qFilter---" + qFilter);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"er_repaymentbill", (String)"id,billno", (QFilter[])new QFilter[]{qFilter});
                if (dynamicObject != null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5173\u8054\u6536\u6b3e\u5355\uff08%1$s\uff09\u5df2\u88ab\u8fd8\u6b3e\u5355\uff08%2$s\uff09\u5173\u8054\uff0c\u8bf7\u91cd\u65b0\u5173\u8054\u6536\u6b3e\u5355\u3002", (String)"ErRepayMentBillPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]), recbillno, dynamicObject.getString("billno"));
                    this.addErrorMessage(dataEntity, msg);
                    return;
                }
                long recbillid = ((DynamicObject)recentryCollectoin.get(i)).getLong("recbillid");
                DynamicObject casRecbill = BusinessDataServiceHelper.loadSingle((Object)recbillid, (String)"cas_recbill");
                if (casRecbill == null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5173\u8054\u6536\u6b3e\u5355\uff08%1$s\uff09\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5173\u8054\u6536\u6b3e\u5355\u3002", (String)"ErRepayMentBillPlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0]), recbillno);
                    this.addErrorMessage(dataEntity, msg);
                    return;
                }
                if (casRecbill == null || "D".equals(casRecbill.getString("billstatus"))) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u5173\u8054\u6536\u6b3e\u5355\uff08%1$s\uff09\u4e0d\u662f\u5df2\u6536\u6b3e\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u5173\u8054\u6536\u6b3e\u5355\u3002", (String)"ErRepayMentBillPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]), recbillno);
                this.addErrorMessage(dataEntity, msg);
                return;
            }
            if (this.verifyBillCanbeSubmit(dataEntity)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8fd8\u6b3e\u603b\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\u4e0d\u7b49\u4e8e\u6536\u6b3e\u603b\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\u3002", (String)"ErRepayMentBillPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public boolean verifyBillCanbeSubmit(ExtendedDataEntity dataEntity) {
        Boolean canBeSubmit = false;
        DynamicObjectCollection recentryCollectoin = dataEntity.getDataEntity().getDynamicObjectCollection("recentry");
        if (recentryCollectoin != null && !recentryCollectoin.isEmpty()) {
            BigDecimal approveamount;
            double diff;
            BigDecimal totalActrecamt = BigDecimal.ZERO;
            BigDecimal totalfee = BigDecimal.ZERO;
            for (int i = 0; i < recentryCollectoin.size(); ++i) {
                BigDecimal actrecamt = ((DynamicObject)recentryCollectoin.get(i)).getBigDecimal("actrecamt");
                Long recbillid = ((DynamicObject)recentryCollectoin.get(i)).getLong("recbillid");
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)recbillid, (String)"cas_recbill");
                if (dynamicObject != null) {
                    if (dynamicObject.containsProperty("localamt") && dynamicObject.getBigDecimal("localamt").compareTo(actrecamt) != 0) {
                        actrecamt = dynamicObject.getBigDecimal("localamt");
                    }
                    if (dynamicObject.containsProperty("fee") && dynamicObject.getBigDecimal("fee") != null) {
                        totalfee = totalfee.add(dynamicObject.getBigDecimal("fee"));
                    }
                }
                totalActrecamt = totalActrecamt.add(actrecamt);
            }
            if ("true".equals(ErStdConfig.get((String)"isIncludeFee"))) {
                totalActrecamt = totalActrecamt.add(totalfee);
            }
            if ((diff = Math.abs((approveamount = dataEntity.getDataEntity().getBigDecimal("approveamount")).subtract(totalActrecamt).doubleValue())) <= 0.1) {
                canBeSubmit = true;
            }
        }
        return canBeSubmit;
    }
}

