/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web.reimctl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.OrgServiceHelper;
import kd.fi.er.business.servicehelper.ReimburseAmountServiceHelper;
import kd.fi.er.business.utils.ReimburseControlUtils;

public class PersonReimSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
        keys.add("company");
        keys.add("employee");
        keys.add("dept");
        keys.add("expenseitem");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        validators.add(new AbstractValidator(){

            public void validate() {
                DynamicObject dynamicObject;
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                Map allOrgListMap = new HashMap(dataEntities.length);
                HashMap<Long, DynamicObject> userDOMap = new HashMap<Long, DynamicObject>(dataEntities.length);
                ArrayList<Long> companySet = new ArrayList<Long>(dataEntities.length);
                ArrayList<Long> userSet = new ArrayList<Long>(dataEntities.length);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    dynamicObject = dataEntity.getDataEntity();
                    Long companyPk = (Long)dynamicObject.getDynamicObject("company").getPkValue();
                    Long userId = (Long)dynamicObject.getDynamicObject("employee").getPkValue();
                    companySet.add(companyPk);
                    userSet.add(userId);
                }
                if (!companySet.isEmpty()) {
                    allOrgListMap = OrgUnitServiceHelper.getAllSubordinateOrgMap((long)1L, companySet, (boolean)true);
                }
                if (!userSet.isEmpty()) {
                    QFilter qf = new QFilter("id", "in", userSet);
                    DynamicObject[] userDOs = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,entryentity.id,entryentity.dpt", (QFilter[])new QFilter[]{qf});
                    for (int i = 0; i < userDOs.length; ++i) {
                        userDOMap.put(userDOs[i].getLong("id"), userDOs[i]);
                    }
                }
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    dynamicObject = dataEntity.getDataEntity();
                    DynamicObject company = dynamicObject.getDynamicObject("company");
                    DynamicObject employee = dynamicObject.getDynamicObject("employee");
                    Long companyId = (Long)company.getPkValue();
                    Long userId = (Long)employee.getPkValue();
                    boolean isAllowAdd = false;
                    List allOrgList = null;
                    boolean isUserRelateWithCompany = ReimburseControlUtils.isUserRelateWithCompany((Long)companyId);
                    if (!isUserRelateWithCompany) {
                        isAllowAdd = true;
                    } else if (allOrgListMap.containsKey(companyId)) {
                        allOrgList = (List)allOrgListMap.get(companyId);
                    }
                    if (!isAllowAdd && allOrgList != null && userDOMap.containsKey(userId)) {
                        DynamicObject userDO = (DynamicObject)userDOMap.get(userId);
                        List finalAllOrgList = allOrgList;
                        isAllowAdd = userDO.getDynamicObjectCollection("entryentity").stream().anyMatch(entry -> finalAllOrgList.contains(entry.getDynamicObject("dpt").getPkValue()));
                    }
                    if (isAllowAdd) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u4e0b%2$s\u6ca1\u6709\u804c\u4f4d\uff0c\u4e0d\u5141\u8bb8\u5728\u8be5\u516c\u53f8\u65b0\u589e\u989d\u5ea6\u3002", (String)"PersonReimSaveOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]), company.getString("name"), employee.get("name")));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap allOrgListMap = new HashMap(dataEntities.length);
        HashMap<Long, DynamicObject> userDOMap = new HashMap<Long, DynamicObject>(dataEntities.length);
        ArrayList<Long> userSet = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            Long userId = (Long)dataEntity.getDynamicObject("employee").getPkValue();
            userSet.add(userId);
        }
        if (!userSet.isEmpty()) {
            QFilter qf = new QFilter("id", "in", userSet);
            DynamicObject[] userDOs = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,entryentity.id,entryentity.dpt,entryentity.ispartjob", (QFilter[])new QFilter[]{qf});
            for (int i = 0; i < userDOs.length; ++i) {
                userDOMap.put(userDOs[i].getLong("id"), userDOs[i]);
            }
        }
        for (DynamicObject dataEntity : dataEntities) {
            Long companyPk;
            if (dataEntity.getDynamicObject("dept") != null) continue;
            Long userPk = (Long)dataEntity.getDynamicObject("employee").getPkValue();
            Long deptId = companyPk = (Long)dataEntity.getDynamicObject("company").getPkValue();
            HashMap groupByIsPartJob = new HashMap(2);
            groupByIsPartJob.put(true, new ArrayList());
            groupByIsPartJob.put(false, new ArrayList());
            if (userDOMap.containsKey(userPk)) {
                DynamicObject userDO = (DynamicObject)userDOMap.get(userPk);
                userDO.getDynamicObjectCollection("entryentity").forEach(entry -> {
                    boolean isPartJob = entry.getBoolean("ispartjob");
                    ((List)groupByIsPartJob.get(isPartJob)).add(entry.getDynamicObject("dpt"));
                });
            }
            HashSet deptIds = null;
            if (allOrgListMap.containsKey(companyPk)) {
                deptIds = (HashSet)allOrgListMap.get(companyPk);
            } else {
                List allSubOrgWithoutCompany = OrgServiceHelper.getAllSubOrgWithoutCompany((List)Lists.newArrayList((Object[])new Long[]{companyPk}), (Boolean)true);
                deptIds = new HashSet(allSubOrgWithoutCompany);
                allOrgListMap.put(companyPk, deptIds);
            }
            for (DynamicObject org : (List)groupByIsPartJob.get(Boolean.FALSE)) {
                if (!deptIds.contains(org.getPkValue())) continue;
                deptId = (Long)org.getPkValue();
                break;
            }
            for (DynamicObject org : (List)groupByIsPartJob.get(Boolean.TRUE)) {
                if (!deptIds.contains(org.getPkValue())) continue;
                deptId = (Long)org.getPkValue();
                break;
            }
            dataEntity.set("dept_id", (Object)deptId);
        }
    }

    private void setDept(DynamicObject dataEntity) {
        if (dataEntity.getDynamicObject("dept") == null) {
            Long deptId = ReimburseAmountServiceHelper.getDept((DynamicObject)dataEntity);
            dataEntity.set("dept_id", (Object)deptId);
        }
    }
}

