/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web.reimctl.importdata;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.OrgServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import org.apache.commons.lang3.StringUtils;

public class DeptReimCtlImportDataOp
extends BatchImportPlugin {
    private static final Log logger = LogFactory.getLog(DeptReimCtlImportDataOp.class);
    public static final String NEW = "new";
    public static final String OVERRIDE = "override";
    public static final String OVERRIDE_NEW = "overridenew";
    private Map<String, DynamicObject> costCompanyMap = new ConcurrentHashMap<String, DynamicObject>(3);

    public ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        HashMap<String, Integer> validMap = new HashMap<String, Integer>();
        Iterator<ImportBillData> it = rowdatas.iterator();
        Set<String> costCompanyNumberSet = rowdatas.stream().map(row -> row.getData().getJSONObject("costcompany").getString("number")).collect(Collectors.toSet());
        this.QueryCostCompany(this.costCompanyMap, costCompanyNumberSet);
        while (it.hasNext()) {
            ImportBillData data = it.next();
            String validMsg = this.validBillData(data, validMap);
            if (!StringUtils.isNotBlank((CharSequence)validMsg)) continue;
            logger.log(Integer.valueOf(data.getStartIndex()), validMsg);
            logger.fail();
            it.remove();
        }
        return super.save(rowdatas, logger);
    }

    private void QueryCostCompany(Map<String, DynamicObject> costCompanyMap, Set<String> costCompanyNumberSet) {
        QFilter orgFilter = new QFilter("org.number", "in", costCompanyNumberSet);
        QFilter viewType = new QFilter("view.id", "=", (Object)10);
        DynamicObjectCollection costCompanys = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id,org.number,isfreeze", (QFilter[])new QFilter[]{orgFilter, viewType});
        for (DynamicObject costCompany : costCompanys) {
            costCompanyMap.put(costCompany.getString("org.number"), costCompany);
        }
    }

    private String validBillData(ImportBillData data, HashMap<String, Integer> validMap) {
        Object rawAmount;
        int i;
        String validMsg = "";
        String costCompanyNumber = data.getData().getJSONObject("costcompany").getString("number");
        DynamicObject costCompany = this.costCompanyMap.get(costCompanyNumber);
        if (costCompany == null) {
            validMsg = ResManager.loadKDString((String)"\u6b64\u6761\u6570\u636e\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"DeptReimCtlImportDataOp_19", (String)"fi-er-opplugin", (Object[])new Object[0]);
            logger.info("\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
            return validMsg;
        }
        if (costCompany.getBoolean("isfreeze")) {
            validMsg = ResManager.loadKDString((String)"\u6b64\u6761\u6570\u636e\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u5df2\u5c01\u5b58\u3002", (String)"DeptReimCtlImportDataOp_20", (String)"fi-er-opplugin", (Object[])new Object[0]);
            logger.info("\u6838\u7b97\u7ec4\u7ec7\u5df2\u7ecf\u5c01\u5b58, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
            return validMsg;
        }
        String expenseItemNumber = data.getData().getJSONObject("expenseitem").getString("number");
        long costCompanyPk = costCompany.getLong("org.id");
        QFilter qfilters = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)costCompanyPk).and(new QFilter("isreimburseamountctl", "=", (Object)"2")).and(new QFilter("enable", "=", (Object)true)).and(new QFilter("number", "=", (Object)expenseItemNumber));
        DynamicObject expenseItemDO = QueryServiceHelper.queryOne((String)"er_expenseitemedit", (String)"id,reimburseamountctlmethod,isreimburseamountctl", (QFilter[])new QFilter[]{qfilters});
        if (expenseItemDO == null) {
            validMsg = ResManager.loadKDString((String)"\u6b64\u6761\u6570\u636e\u4e2d\u7684\u8d39\u7528\u9879\u76ee\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\uff0c\u8bf7\u4fee\u6539\u8d39\u7528\u9879\u76ee\u7f16\u7801\u3002", (String)"DeptReimCtlImportDataOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
            logger.info("\u5bf9\u5e94\u7684\u8d39\u7528\u9879\u76ee\u4e0d\u5b58\u5728, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
            return validMsg;
        }
        if (!"2".equals(expenseItemDO.getString("isreimburseamountctl"))) {
            validMsg = ResManager.loadKDString((String)"\u6b64\u6761\u6570\u636e\u4e2d\u7684\u8d39\u7528\u9879\u76ee\u4e0d\u662f\u90e8\u95e8\u989d\u5ea6\u63a7\u5236\u3002", (String)"DeptReimCtlImportDataOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]);
            logger.info("\u8d39\u7528\u9879\u76ee\u4e0d\u662f\u90e8\u95e8\u989d\u5ea6\u63a7\u5236, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
            return validMsg;
        }
        validMsg = this.validateNumber(data, "dept", "bos_org", ResManager.loadKDString((String)"\u90e8\u95e8", (String)"DeptReimCtlImportDataOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
        if (validMsg != null) {
            return validMsg;
        }
        validMsg = this.validateNumber(data, "currency", "bd_currency", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"DeptReimCtlImportDataOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
        if (validMsg != null) {
            return validMsg;
        }
        ArrayList<Object> recorder = Lists.newArrayListWithExpectedSize((int)0);
        boolean isUpdatePartOfData = false;
        String ctrlMethod = expenseItemDO.getString("reimburseamountctlmethod");
        if (StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Yearly.getValue())) {
            if (data.getData().containsKey((Object)"month1")) {
                validMsg = ResManager.loadKDString((String)"\u6b64\u6761\u8d39\u7528\u9879\u76ee\u4e3a\u6309\u5e74\u63a7\u5236\uff0c\u8bf7\u4f7f\u7528\u201c\u989d\u5ea6\u8868\u7ef4\u62a4\uff08\u6309\u5e74\u63a7\u5236\uff09\u201d\u6a21\u677f\u5bfc\u5165\u3002", (String)"DeptReimCtlImportDataOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]);
                logger.info("\u6309\u5e74\u63a7\u5236, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
                return validMsg;
            }
            BigDecimal totalAmount = new BigDecimal(data.getData().getString("totalamount"));
            if (totalAmount.compareTo(BigDecimal.ZERO) < 0) {
                validMsg = ResManager.loadKDString((String)"\u603b\u989d\u5ea6\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"DeptReimCtlImportDataOp_5", (String)"fi-er-opplugin", (Object[])new Object[0]);
                return validMsg;
            }
        } else if (StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue()) || StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue())) {
            if (data.getData().keySet().stream().noneMatch(key -> key.contains("month"))) {
                validMsg = ResManager.loadKDString((String)"\u6b64\u6761\u8d39\u7528\u9879\u76ee\u4e3a\u6309\u6708/\u7d2f\u79ef\u63a7\u5236\uff0c\u8bf7\u4f7f\u7528\u201c\u989d\u5ea6\u8868\u7ef4\u62a4\u201d\u6a21\u677f\u5bfc\u5165\u3002", (String)"DeptReimCtlImportDataOp_6", (String)"fi-er-opplugin", (Object[])new Object[0]);
                logger.info("\u6309\u6708/\u7d2f\u79ef\u63a7\u5236, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
                return validMsg;
            }
            BigDecimal totalAmount = BigDecimal.ZERO;
            recorder = new ArrayList<Object>(12);
            for (i = 1; i <= 12; ++i) {
                rawAmount = data.getData().get((Object)("month" + i));
                recorder.add(rawAmount);
                isUpdatePartOfData = isUpdatePartOfData || rawAmount == null;
                totalAmount = totalAmount.add(rawAmount == null ? BigDecimal.ZERO : new BigDecimal(rawAmount.toString()));
            }
            if (!isUpdatePartOfData) {
                data.getData().put("totalamount", (Object)totalAmount.toString());
            }
            for (int i2 = 1; i2 <= 12; ++i2) {
                BigDecimal amount;
                String name = "month" + i2;
                Object monthAmount = data.getData().getOrDefault((Object)name, (Object)BigDecimal.ZERO);
                BigDecimal bigDecimal = amount = monthAmount != null ? new BigDecimal(monthAmount.toString()) : BigDecimal.ZERO;
                if (amount.compareTo(BigDecimal.ZERO) >= 0) continue;
                validMsg = String.format(ResManager.loadKDString((String)"%s\u989d\u5ea6\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"DeptReimCtlImportDataOp_7", (String)"fi-er-opplugin", (Object[])new Object[0]), name);
                return validMsg;
            }
        } else if (StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Quarterly.getValue())) {
            if (data.getData().keySet().stream().noneMatch(key -> key.contains("quarter"))) {
                validMsg = ResManager.loadKDString((String)"\u6b64\u6761\u8d39\u7528\u9879\u76ee\u4e3a\u6309\u5b63\u63a7\u5236\uff0c\u8bf7\u4f7f\u7528\u201c\u989d\u5ea6\u8868\u7ef4\u62a4\uff08\u6309\u5b63\u63a7\u5236\uff09\u201d\u6a21\u677f\u5bfc\u5165\u3002", (String)"DeptReimCtlImportDataOp_8", (String)"fi-er-opplugin", (Object[])new Object[0]);
                logger.info("\u6309\u5b63\u63a7\u5236, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
                return validMsg;
            }
            recorder = new ArrayList(4);
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (i = 1; i <= 4; ++i) {
                rawAmount = data.getData().getBigDecimal("quarter" + i);
                recorder.add(rawAmount);
                boolean bl = isUpdatePartOfData = isUpdatePartOfData || rawAmount == null;
                if (rawAmount != null && ((BigDecimal)rawAmount).compareTo(BigDecimal.ZERO) < 0) {
                    validMsg = String.format(ResManager.loadKDString((String)"%1$s%2$s\u989d\u5ea6\u4e0d\u80fd\u4e3a\u8d1f\u6570", (String)"PersonReimCtlImportDataOp_22", (String)"fi-er-opplugin", (Object[])new Object[0]), "quarter", i);
                    return validMsg;
                }
                totalAmount = totalAmount.add((BigDecimal)(rawAmount == null ? BigDecimal.ZERO : rawAmount));
            }
            if (!isUpdatePartOfData) {
                data.getData().put("totalamount", (Object)totalAmount.toString());
            }
        }
        String importType = (String)this.ctx.getOption().get("importtype");
        String deptNumber = this.getBasedataNumber(data, "dept");
        String currencyNumber = this.getBasedataNumber(data, "currency");
        String year = data.getData().getString("dateyear");
        String pk_key = deptNumber + expenseItemNumber + currencyNumber + year;
        if (null != validMap.get(pk_key)) {
            validMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u62a5\u9500\u989d\u5ea6\u6570\u636e\uff08\u5e74\uff1a%2$s\uff0c\u90e8\u95e8\uff1a%3$s\uff0c\u8d39\u7528\u9879\u76ee\uff1a%4$s\uff0c\u5e01\u79cd\uff1a%5$s\uff09\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u65b0\u589e\uff0c\u8bf7\u9009\u62e9\u8986\u76d6\u65b9\u5f0f\u5bfc\u5165\u3002", (String)"DeptReimCtlImportDataOp_9", (String)"fi-er-opplugin", (Object[])new Object[0]), validMap.get(pk_key), year, deptNumber, expenseItemNumber, currencyNumber);
            return validMsg;
        }
        QFilter qfDeptNumber = new QFilter("number", "=", (Object)deptNumber);
        QFilter qfDeptEnable = new QFilter("enable", "=", (Object)true);
        DynamicObject deptDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qfDeptNumber, qfDeptEnable});
        Long deptId = ErCommonUtils.getPk((Object)deptDO);
        DynamicObject companyDO = OrgServiceHelper.getCompanyBy((long)ErCommonUtils.getPk((Object)deptDO));
        if (companyDO == null) {
            validMsg = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230%s\u90e8\u95e8\u7684\u4e0a\u7ea7\u516c\u53f8\u3002", (String)"DeptReimCtlImportDataOp_10", (String)"fi-er-opplugin", (Object[])new Object[0]), deptNumber);
            return validMsg;
        }
        Long companyId = ErCommonUtils.getPk((Object)companyDO);
        data.getData().get((Object)"dept");
        JSONObject companyJson = new JSONObject();
        companyJson.put("importprop", (Object)"number");
        companyJson.put("number", (Object)companyDO.getString("number"));
        companyJson.put("name", (Object)companyDO.getLocaleString("name").toString());
        data.getData().put("company", (Object)companyJson);
        Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId((Long)companyId, (Boolean)true);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)accountOrgId);
        DynamicObject single = QueryServiceHelper.queryOne((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{baseDataFilter, QFilter.of((String)"id = ?", (Object[])new Object[]{expenseItemDO.getLong("id")})});
        if (single == null) {
            String msg = ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u201c%s\u201d\u4e0d\u5728\u5f53\u524d\u7ec4\u7ec7\u4f7f\u7528\u8303\u56f4\u5185\u3002", (String)"DeptReimCtlImportDataOp_11", (String)"fi-er-opplugin", (Object[])new Object[0]);
            return String.format(msg, expenseItemNumber);
        }
        QFilter qFilter = QFilter.of((String)"dept.number=? and expenseitem.number=? and currency.number=? and dateyear=? and auditstatus != '2'", (Object[])new Object[]{deptNumber, expenseItemNumber, currencyNumber, year});
        DynamicObjectCollection reimburseAmountDOs = QueryServiceHelper.query((String)"er_dept_reimctl", (String)"id,auditstatus,month1,month2,month3,month4,month5,month6,month7,month8,month9,month10,month11,month12,quarter1,quarter2,quarter3,quarter4", (QFilter[])new QFilter[]{qFilter});
        if (reimburseAmountDOs != null) {
            if (reimburseAmountDOs.size() > 1) {
                validMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u4e0d\u552f\u4e00\uff0c\u8bf7\u5148\u6e05\u7406\u540e\u518d\u5bfc\u5165\u3002\uff08\u6570\u636e\u5339\u914d\u7ef4\u5ea6\uff1a\u90e8\u95e8\u3001\u8d39\u7528\u9879\u76ee\u3001\u5e01\u79cd\u3001\u5e74\u5ea6\uff09", (String)"DeptReimCtlImportDataOp_12", (String)"fi-er-opplugin", (Object[])new Object[0]);
                logger.info(String.format("\u90e8\u95e8(%s)+\u8d39\u7528\u9879\u76ee(%s)+\u5e01\u79cd(%s)+\u5e74\u5ea6(%s) \u67e5\u8be2\u7ed3\u679c\u4e0d\u552f\u4e00, \u6709\u810f\u6570\u636e, \u67e5\u8be2\u7ed3\u679c\u4e3a:%s", deptNumber, expenseItemNumber, currencyNumber, year, SerializationUtils.toJsonString((Object)reimburseAmountDOs)));
                return validMsg;
            }
            if (reimburseAmountDOs.size() == 1) {
                if (StringUtils.equals((CharSequence)importType, (CharSequence)NEW)) {
                    String errorMsg;
                    validMsg = errorMsg = String.format(ResManager.loadKDString((String)"\u62a5\u9500\u989d\u5ea6\u6570\u636e\uff08\u5e74\uff1a%1$s\uff0c\u90e8\u95e8\uff1a %2$s\uff0c\u8d39\u7528\u9879\u76ee\uff1a%3$s\uff0c\u5e01\u79cd\uff1a%4$s\uff09\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u65b0\u589e\uff0c\u8bf7\u9009\u62e9\u8986\u76d6\u65b9\u5f0f\u5bfc\u5165\u3002", (String)"DeptReimCtlImportDataOp_13", (String)"fi-er-opplugin", (Object[])new Object[0]), year, deptNumber, expenseItemNumber, currencyNumber);
                    logger.info(errorMsg);
                    logger.info(String.format("%1$s%2$s", ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u6a21\u5f0f\u4e3a\u201c\u65b0\u589e\u201d\u3002\u4f46\u6570\u636e\u5e93\u4e2d\u5df2\u7ecf\u5b58\u5728\u5bf9\u5e94\u7684\u989d\u5ea6\u6570\u636e\uff0c\u65b0\u589e\u5931\u8d25\u3002", (String)"DeptReimCtlImportDataOp_14", (String)"fi-er-opplugin", (Object[])new Object[0]), SerializationUtils.toJsonString((Object)reimburseAmountDOs)));
                    return validMsg;
                }
                boolean iscover = ErStdConfig.getIsCoverAuditForReimburseAmount();
                if (!iscover && "1".equals(((DynamicObject)reimburseAmountDOs.get(0)).getString("auditstatus"))) {
                    String errorMsg;
                    validMsg = errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5e74, %2$s\u90e8\u95e8, \u8d39\u7528\u9879\u76ee\u4e3a%3$s, \u5e01\u79cd\u4e3a%4$s\u7684\u62a5\u9500\u989d\u5ea6\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838,\u4e0d\u5141\u8bb8\u8986\u76d6, \u8bf7\u53cd\u5ba1\u6838\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"DeptReimCtlImportDataOp_15", (String)"fi-er-opplugin", (Object[])new Object[0]), year, deptNumber, expenseItemNumber, currencyNumber);
                    logger.info(errorMsg);
                    return validMsg;
                }
                if (isUpdatePartOfData) {
                    int i3;
                    int size = recorder.size();
                    if (size == 12) {
                        for (i3 = 0; i3 < 12; ++i3) {
                            if (recorder.get(i3) == null) {
                                recorder.set(i3, ((DynamicObject)reimburseAmountDOs.get(0)).getBigDecimal("month" + (i3 + 1)));
                                continue;
                            }
                            recorder.set(i3, new BigDecimal(recorder.get(i3).toString()));
                        }
                    } else if (size == 4) {
                        for (i3 = 0; i3 < 4; ++i3) {
                            if (recorder.get(i3) == null) {
                                recorder.set(i3, ((DynamicObject)reimburseAmountDOs.get(0)).getBigDecimal("quarter" + (i3 + 1)));
                                continue;
                            }
                            recorder.set(i3, new BigDecimal(recorder.get(i3).toString()));
                        }
                    }
                    BigDecimal sum = recorder.stream().reduce((a, b) -> ((BigDecimal)a).add((BigDecimal)b)).orElse(BigDecimal.ZERO);
                    data.getData().put("totalamount", (Object)sum);
                }
                data.getData().put("id", (Object)((DynamicObject)reimburseAmountDOs.get(0)).getLong("id"));
            }
        }
        validMap.put(pk_key, data.getStartIndex());
        return null;
    }

    private String validateNumber(ImportBillData data, String fieldName, String entityName, String showName) {
        String validMsg = "";
        String number = data.getData().getJSONObject(fieldName).getString("number");
        QFilter qfNumber = new QFilter("number", "=", (Object)number);
        QFilter qfEnable = new QFilter("enable", "=", (Object)true);
        DynamicObject DO = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])new QFilter[]{qfNumber, qfEnable});
        if ("bos_org".equals(entityName) && DO != null) {
            QFilter isFreezeFilter = new QFilter("org", "=", (Object)DO.getLong("id")).and("isfreeze", "=", (Object)false);
            DO = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id", (QFilter[])new QFilter[]{isFreezeFilter});
        }
        if (DO == null) {
            validMsg = String.format(ResManager.loadKDString((String)"\u6b64\u6761\u6570\u636e\u4e2d\u7684%s\u7f16\u7801\u4e0d\u5b58\u5728, \u8bf7\u4fee\u6539\u6b63\u786e\u540e\u518d\u5bfc\u5165", (String)"DeptReimCtlImportDataOp_16", (String)"fi-er-opplugin", (Object[])new Object[0]), showName);
            logger.info("\u6b64\u6761\u6570\u636e\u4e2d\u7684" + showName + "\u7f16\u53f7\u4e0d\u5b58\u5728, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
            return validMsg;
        }
        return null;
    }

    private String getBasedataNumber(ImportBillData data, String fieldName) {
        return data.getData().getJSONObject(fieldName).getString("number");
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        return Lists.newArrayList((Object[])new ComboItem[]{new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"DeptReimCtlImportDataOp_18", (String)"fi-er-opplugin", (Object[])new Object[0])), "id")});
    }

    public String getDefaultKeyFields() {
        return "id";
    }

    public List<String> getDefaultLockUIs() {
        return Lists.newArrayList((Object[])new String[]{"keyfields"});
    }
}

