/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class CorpAccountSettingValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet allSubAccount = new HashSet();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCollection subAccountEntry = dynamicObject.getDynamicObjectCollection("entryentity");
            int size = 0;
            DynamicObjectCollection subAccountList = subAccountEntry;
            Map accountRelOrgMap = subAccountList.stream().collect(Collectors.groupingBy(d -> d.getString("mainaccountname"), Collectors.mapping(d -> d.getString("subaccountname"), Collectors.toSet())));
            for (Set set : accountRelOrgMap.values()) {
                allSubAccount.addAll(set);
                size += set.size();
            }
            if (!allSubAccount.isEmpty() && allSubAccount.size() < size) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e3b\u8d26\u6237\u4e0d\u540c\uff0c\u5b50\u8d26\u6237\u4e5f\u5fc5\u987b\u4e0d\u540c\u3002", (String)"CorpAccountSettingValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            allSubAccount.clear();
        }
    }
}

