/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.EntityTypeEnum;
import kd.fi.er.opplugin.daily.web.CreateImageOp;
import org.apache.commons.lang3.StringUtils;

public class ErBillCheckOrgDisableSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(CreateImageOp.class);
    private final EntityTypeEnum entityTypeEnum;

    public ErBillCheckOrgDisableSubmitValidator(EntityTypeEnum entityTypeEnum) {
        this.entityTypeEnum = entityTypeEnum;
    }

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("billno");
        preparePropertys.add("company");
        preparePropertys.add("org");
        preparePropertys.add("costdept");
        preparePropertys.add("costcompany");
        preparePropertys.add("expensesassumeshowtypes");
        preparePropertys.add("tripentry");
        preparePropertys.add("expenseentryentity");
        preparePropertys.add("writeoffapply");
        preparePropertys.add("writeoffmoney");
        preparePropertys.add("entrycostdept");
        preparePropertys.add("entrycostcompany");
        preparePropertys.add("repaymententry");
        preparePropertys.add("wbsrcbilltype");
        return preparePropertys;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            bill.getDataEntityType();
            Object company = bill.get("company");
            if (null == company) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErBillCheckOrgDisableSubmitValidator_13", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return;
            }
            Object dept = bill.get("org");
            this.checkOrgDisable(company, "company", dataEntity);
            this.checkOrgDisable(dept, "org", dataEntity);
            if (EntityTypeEnum.REIMCTLAPPLYBILL == this.entityTypeEnum) continue;
            BillType billType = BillType.getBillTypeByEntityTypeEnum(this.entityTypeEnum, bill);
            billType.volidate(this, dataEntity);
        }
    }

    private void checkOrgDisable(Object org, String propName, ExtendedDataEntity dataEntity) {
        Long orgId = ErCommonUtils.getPk((Object)org);
        boolean disableFlag = false;
        if (StringUtils.equals((CharSequence)"org", (CharSequence)propName) || StringUtils.equals((CharSequence)"company", (CharSequence)propName)) {
            disableFlag = this.orgIsFreeze(orgId);
        } else if (StringUtils.equals((CharSequence)"costdept", (CharSequence)propName) || StringUtils.equals((CharSequence)"costcompany", (CharSequence)propName)) {
            disableFlag = this.orgIsDisable(orgId);
        }
        if (this.orgIsFromUpNodeBill(dataEntity)) {
            return;
        }
        if (disableFlag) {
            switch (propName) {
                case "org": {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u5934\u201c\u90e8\u95e8\u201d\u5df2\u5c01\u5b58\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u540e\u63d0\u4ea4\u3002", (String)"ErBillCheckOrgDisableSubmitValidator_7", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    break;
                }
                case "company": {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u5934\u201c\u516c\u53f8\u201d\u5df2\u5c01\u5b58\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u540e\u63d0\u4ea4\u3002", (String)"ErBillCheckOrgDisableSubmitValidator_8", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    break;
                }
                case "costdept": {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5355\u5934\u201c\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u201d\u5df2\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u540e\u63d0\u4ea4\u3002", (String)"ErBillCheckOrgDisableSubmitValidator_9", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    break;
                }
                case "costcompany": {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErExpenseBaseEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private boolean orgIsFromUpNodeBill(ExtendedDataEntity dataEntity) {
        return this.checkPropertyAndCollectionExsit(dataEntity, "writeoffapply", "writeoffmoney", "repaymententry", "expenseentryentity");
    }

    private boolean checkPropertyAndCollectionExsit(ExtendedDataEntity dataEntity, String ... entryIds) {
        DataEntityPropertyCollection properties = dataEntity.getDataEntity().getDynamicObjectType().getProperties();
        boolean flag = false;
        for (String entryId : entryIds) {
            DynamicObjectCollection collection;
            IDataEntityProperty collectionProperty = (IDataEntityProperty)properties.get((Object)entryId);
            if (flag || collectionProperty == null || (collection = dataEntity.getDataEntity().getDynamicObjectCollection(entryId)) == null) continue;
            if (entryId.equals("expenseentryentity")) {
                EntryProp expEntryProp = (EntryProp)collectionProperty;
                DataEntityPropertyCollection expEntryProperties = expEntryProp.getDynamicCollectionItemPropertyType().getProperties();
                if (expEntryProperties.get((Object)"wbsrcbilltype") == null) break;
                flag = collection.stream().anyMatch(e -> e.getString("wbsrcbilltype") != null && !e.getString("wbsrcbilltype").equals(""));
                continue;
            }
            flag = collection.size() != 0;
        }
        return flag;
    }

    private void checkEntryOrgDisable(DynamicObjectCollection expenseEntry, String propName, ExtendedDataEntity dataEntity) {
        for (int i = 0; i < expenseEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)expenseEntry.get(i);
            Object org = row.get(propName);
            if (!this.orgIsDisable(ErCommonUtils.getPk((Object)org)).booleanValue()) continue;
            if (StringUtils.equals((CharSequence)"entrycostdept", (CharSequence)propName)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u5df2\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u540e\u63d0\u4ea4\u3002", (String)"ErBillCheckOrgDisableSubmitValidator_11", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u5df2\u7981\u7528, \u8bf7\u91cd\u65b0\u586b\u5199\u540e\u63d0\u4ea4\u3002", (String)"ErBillCheckOrgDisableSubmitValidator_12", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1));
        }
    }

    private Boolean orgIsFreeze(Long orgId) {
        String selectFields = "isfreeze";
        QFilter treeTypeFilter = new QFilter("view.number", "=", (Object)"01");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{treeTypeFilter, orgFilter};
        DynamicObject orgDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (orgDy == null) {
            return true;
        }
        return orgDy.getBoolean(selectFields);
    }

    private Boolean orgIsDisable(Long orgId) {
        String selectFields = "enable";
        QFilter orgFilter = new QFilter("id", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject orgDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)selectFields, (QFilter[])filters);
        logger.info("\u5165\u53c2orgID\uff1a" + orgId);
        if (orgDy == null) {
            return true;
        }
        return !orgDy.getBoolean(selectFields);
    }

    public static enum BillType {
        UseTripEntry("tripentry"){

            @Override
            public void volidate(ErBillCheckOrgDisableSubmitValidator validator, ExtendedDataEntity dataEntity) {
                DynamicObject bill = dataEntity.getDataEntity();
                DynamicObjectCollection tripEntry = bill.getDynamicObjectCollection("tripentry");
                validator.checkEntryOrgDisable(tripEntry, "entrycostdept", dataEntity);
                validator.checkEntryOrgDisable(tripEntry, "entrycostcompany", dataEntity);
            }
        }
        ,
        UseExpenseEntry("expenseentryentity"){

            @Override
            public void volidate(ErBillCheckOrgDisableSubmitValidator validator, ExtendedDataEntity dataEntity) {
                DynamicObject bill = dataEntity.getDataEntity();
                DynamicObjectCollection expenseEntry = bill.getDynamicObjectCollection("expenseentryentity");
                validator.checkEntryOrgDisable(expenseEntry, "entrycostdept", dataEntity);
                validator.checkEntryOrgDisable(expenseEntry, "entrycostcompany", dataEntity);
            }
        }
        ,
        UseHead(null){

            @Override
            public void volidate(ErBillCheckOrgDisableSubmitValidator validator, ExtendedDataEntity dataEntity) {
                DynamicObject bill = dataEntity.getDataEntity();
                Object costDept = bill.get("costdept");
                Object cosCompany = bill.get("costcompany");
                validator.checkOrgDisable(costDept, "costdept", dataEntity);
                validator.checkOrgDisable(cosCompany, "costcompany", dataEntity);
            }
        };

        private String entityName;

        private BillType(String entityName) {
            this.entityName = entityName;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public abstract void volidate(ErBillCheckOrgDisableSubmitValidator var1, ExtendedDataEntity var2);

        public static BillType getBillTypeByEntityTypeEnum(EntityTypeEnum typeEnum, DynamicObject bill) {
            Object company = bill.get("company");
            String showType = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)company), (String)"expensesassumeshowtypes");
            if (bill.getDataEntityType().getProperties().get((Object)"expensesassumeshowtypes") != null && StringUtils.equals((CharSequence)showType, (CharSequence)"2")) {
                switch (typeEnum) {
                    case DAILYLOANBILL: 
                    case DAILYAPPLYBILL: 
                    case DAILYREIMBURSEBILL: 
                    case PUBLICREIMBURSEBILL: {
                        return UseExpenseEntry;
                    }
                    case TRIPREQBILL: 
                    case TRIPREIMBURSEBILL: {
                        return UseTripEntry;
                    }
                }
            }
            return UseHead;
        }
    }
}

