/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import org.apache.commons.lang3.StringUtils;

public class ErReimburseAmountValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(ErReimburseAmountValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            String reimbursedAmountSign;
            String sign;
            BigDecimal reimbursedAmount;
            int i;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String srcType = (String)dynamicObject.get("wbsrcbilltype");
            if (!"er_reimctl_modify".equals(srcType)) {
                log.info("\u53ea\u6709\u989d\u5ea6\u8c03\u6574\u5355\u9700\u8981\u6821\u9a8c\u5df2\u7528");
                continue;
            }
            DynamicObject company = dynamicObject.getDynamicObject("company");
            if (!SystemParamterUtil.isEnableReimburseControlByCompany((Long)ErCommonUtils.getPk((Object)company))) {
                log.info("\u516c\u53f8:" + company.getPkValue() + "\u6ca1\u542f\u7528\u989d\u5ea6\u63a7\u5236.");
                continue;
            }
            DynamicObject employee = dynamicObject.getDynamicObject("employee");
            DynamicObject deptDO = dynamicObject.getDynamicObject("dept");
            DynamicObject expenseitem = dynamicObject.getDynamicObject("expenseitem");
            DynamicObject currency = dynamicObject.getDynamicObject("currency");
            QuotaAmountBO reimAmountBO = new QuotaAmountBO();
            reimAmountBO.setCompanyId(ErCommonUtils.getPk((Object)company));
            ArrayList<String> deptCltList = new ArrayList<String>();
            deptCltList.add("1");
            deptCltList.add("2");
            deptCltList.add("3");
            reimAmountBO.setDeptCtlBill(deptCltList);
            reimAmountBO.setEmpCtlBill(deptCltList);
            QuotaCtrlUtil.genQuotaExpItem((QuotaAmountBO)reimAmountBO, (Long)ErCommonUtils.getPk((Object)expenseitem));
            String dateyear = dynamicObject.getString("dateyear");
            int year = Integer.parseInt(dateyear);
            String amountType = dynamicObject.getString("amounttype");
            String message = null;
            if (StringUtils.equals((CharSequence)amountType, (CharSequence)"1")) {
                reimAmountBO.setUserOrDeptId(ErCommonUtils.getPk((Object)employee));
                String personCtlCurrency = SystemParamterUtil.getPersonCtlCurrency((Long)ErCommonUtils.getPk((Object)company));
                QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)personCtlCurrency, (Long)ErCommonUtils.getPk((Object)currency), (Long)ErCommonUtils.getPk((Object)currency));
                message = String.format(ResManager.loadKDString((String)"%1$s\u5e74\uff0c\u804c\u5458%2$s\u5728%3$s\uff0c\u8d39\u7528\u9879\u76ee\u4e3a%4$s\uff0c\u5e01\u79cd\u4e3a%5$s\u7684\u62a5\u9500\u989d\u5ea6\u8bb0\u5f55", (String)"ErReimburseAmountValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]), year, employee.getString("name"), company.getString("name"), expenseitem.getString("name"), currency.getString("name"));
            } else {
                reimAmountBO.setUserOrDeptId(ErCommonUtils.getPk((Object)deptDO));
                String deptCtrlCurrency = SystemParamterUtil.getDeptCtlCurrency((Long)ErCommonUtils.getPk((Object)company));
                QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)deptCtrlCurrency, (Long)ErCommonUtils.getPk((Object)currency), (Long)ErCommonUtils.getPk((Object)currency));
                message = String.format(ResManager.loadKDString((String)"%1$s\u5e74\uff0c%2$s-%3$s\uff0c\u8d39\u7528\u9879\u76ee\u4e3a%4$s\uff0c\u5e01\u79cd\u4e3a%5$s\u7684\u62a5\u9500\u989d\u5ea6\u8bb0\u5f55", (String)"ErReimburseAmountValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]), year, company.getString("name"), deptDO.getString("name"), expenseitem.getString("name"), currency.getString("name"));
            }
            StringBuilder sb = new StringBuilder();
            QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)reimAmountBO);
            if (quotaCtrlMode == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u7684\u989d\u5ea6\u63a7\u5236\u4e3a\u65e0\u63a7\u5236\uff0c\u5ba1\u6838\u4e0d\u901a\u8fc7\u3002", (String)"ErReimburseAmountValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue;
            }
            String reimburseCtlMethod = expenseitem.getString("reimburseamountctlmethod");
            if (ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue().equals(reimburseCtlMethod)) {
                String monthPrefix = "month";
                for (i = 1; i <= 12; ++i) {
                    BigDecimal monthAmount = dynamicObject.getBigDecimal(monthPrefix + i);
                    YearMonth yearMonth = YearMonth.of(year, i);
                    reimAmountBO.setHappenDate(yearMonth);
                    reimbursedAmount = quotaCtrlMode.getReimedAmount(reimAmountBO);
                    if (monthAmount.compareTo(reimbursedAmount) >= 0) continue;
                    sign = currency.getString("sign");
                    int amtprecision = currency.getInt("amtprecision");
                    String quarterAmountSign = sign + monthAmount.setScale(amtprecision, 4);
                    reimbursedAmountSign = sign + reimbursedAmount.setScale(amtprecision, 4);
                    log.info(String.format("\u6309\u6708\u63a7\u5236(%d\u6708)\u7684\u989d\u5ea6\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0: \u4fee\u6539\u540e\u7684\u989d\u5ea6(%s)\u5c0f\u4e8e\u5df2\u62a5\u9500\u7684\u91d1\u989d(%s)", i, quarterAmountSign, reimbursedAmountSign));
                    sb.append(String.format(ResManager.loadKDString((String)"\u6309\u6708\u63a7\u5236(%1$s\u6708)\u7684\u989d\u5ea6\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0: \u4fee\u6539\u540e\u7684\u989d\u5ea6(%2$s)\u5c0f\u4e8e\u5df2\u62a5\u9500\u7684\u91d1\u989d(%3$s)\uff1b ", (String)"ErReimburseAmountValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]), i, quarterAmountSign, reimbursedAmountSign));
                }
                if (sb.length() > 0) {
                    sb = sb.deleteCharAt(sb.lastIndexOf("\uff1b")).append('\u3002');
                }
            }
            if (ErExpenseItemConstant.ReimburseAmountCtlMethod.Yearly.getValue().equals(reimburseCtlMethod) || ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue().equals(reimburseCtlMethod)) {
                BigDecimal changedAmount = BigDecimal.ZERO;
                YearMonth yearMonth = YearMonth.of(year, 12);
                String monthPrefix = "month";
                LocalDate startHappenDate = LocalDate.of(yearMonth.getYear(), 1, 1);
                if (ErExpenseItemConstant.ReimburseAmountCtlMethod.Yearly.getValue().equals(reimburseCtlMethod)) {
                    changedAmount = dynamicObject.getBigDecimal("totalamount");
                } else if (ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue().equals(reimburseCtlMethod)) {
                    Month currentMonth = LocalDate.now().getMonth();
                    if (yearMonth.getYear() != Year.now().getValue()) {
                        currentMonth = LocalDate.of(yearMonth.getYear(), 12, 31).getMonth();
                    }
                    yearMonth = YearMonth.of(year, currentMonth);
                    for (int i2 = 1; i2 <= currentMonth.getValue(); ++i2) {
                        changedAmount = changedAmount.add(dynamicObject.getBigDecimal(monthPrefix + i2));
                    }
                }
                LocalDate endHappenDate = yearMonth.atEndOfMonth();
                reimAmountBO.setHappenDatePeriod(new LocalDate[]{startHappenDate, endHappenDate});
                BigDecimal reimbursedAmount2 = quotaCtrlMode.getReimedAmount(reimAmountBO);
                String sign2 = currency.getString("sign");
                int amtprecision = currency.getInt("amtprecision");
                String amountSign = sign2 + changedAmount.setScale(amtprecision, 4);
                String reimbursedAmountSign2 = sign2 + reimbursedAmount2.setScale(amtprecision, 4);
                if (changedAmount.compareTo(reimbursedAmount2) < 0 && ErExpenseItemConstant.ReimburseAmountCtlMethod.Yearly.getValue().equals(reimburseCtlMethod)) {
                    log.info(String.format("\u6309\u5e74\u63a7\u5236\u7684\u989d\u5ea6\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0: \u4fee\u6539\u540e\u7684\u989d\u5ea6(%1$s)\u5c0f\u4e8e\u5df2\u62a5\u9500\u7684\u91d1\u989d(%2$s)", amountSign, reimbursedAmountSign2));
                    sb.append(String.format(ResManager.loadKDString((String)"\u6309\u5e74\u63a7\u5236\u7684\u989d\u5ea6\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\uff1a \u4fee\u6539\u540e\u7684\u989d\u5ea6(%1$s)\u5c0f\u4e8e\u5df2\u62a5\u9500\u7684\u91d1\u989d(%2$s)\u3002", (String)"ErReimburseAmountValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]), amountSign, reimbursedAmountSign2));
                } else if (changedAmount.compareTo(reimbursedAmount2) < 0 && ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue().equals(reimburseCtlMethod)) {
                    log.info(String.format("\u7d2f\u8ba1\u63a7\u5236\u7684\u989d\u5ea6\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0: 1\u6708\u81f3%1$s\u6708\u4fee\u6539\u540e\u7684\u989d\u5ea6(%2$s)\u5c0f\u4e8e\u5df2\u62a5\u9500\u7684\u91d1\u989d(%3$s)\u3002", yearMonth.getMonth().getValue(), amountSign, reimbursedAmountSign2));
                    sb.append(String.format(ResManager.loadKDString((String)"\u7d2f\u8ba1\u63a7\u5236\u7684\u989d\u5ea6\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0\uff1a1\u6708\u81f3%1$s\u6708\u4fee\u6539\u540e\u7684\u989d\u5ea6\u201c%2$s\u201d\u5c0f\u4e8e\u5df2\u62a5\u9500\u7684\u91d1\u989d\u201c%3$s\u201d\u3002", (String)"ErReimburseAmountValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]), yearMonth.getMonth().getValue(), amountSign, reimbursedAmountSign2));
                }
            }
            if (ErExpenseItemConstant.ReimburseAmountCtlMethod.Quarterly.getValue().equals(reimburseCtlMethod)) {
                String quarterPrefix = "quarter";
                for (i = 1; i <= 4; ++i) {
                    BigDecimal quarterAmount = dynamicObject.getBigDecimal(quarterPrefix + i);
                    Map quarterPeriod = ErCommonUtils.getQuarterPeriod((int)year, (int)i);
                    reimAmountBO.setHappenDatePeriod(new LocalDate[]{(LocalDate)quarterPeriod.get("start"), (LocalDate)quarterPeriod.get("end")});
                    reimbursedAmount = quotaCtrlMode.getReimedAmount(reimAmountBO);
                    if (quarterAmount.compareTo(reimbursedAmount) >= 0) continue;
                    sign = currency.getString("sign");
                    int amtprecision = currency.getInt("amtprecision");
                    String amountSign = sign + quarterAmount.setScale(amtprecision, 4);
                    reimbursedAmountSign = sign + reimbursedAmount.setScale(amtprecision, 4);
                    log.info(String.format("\u6309\u5b63\u63a7\u5236(\u7b2c%1d\u5b63\u5ea6)\u7684\u989d\u5ea6\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0: \u4fee\u6539\u540e\u7684\u989d\u5ea6(%2$s)\u5c0f\u4e8e\u5df2\u62a5\u9500\u7684\u91d1\u989d(%3$s) ", i, amountSign, reimbursedAmountSign));
                    sb.append(String.format(ResManager.loadKDString((String)"\u6309\u5b63\u63a7\u5236(\u7b2c%1d\u5b63\u5ea6)\u7684\u989d\u5ea6\u4fee\u6539\u5931\u8d25\uff0c\u539f\u56e0: \u4fee\u6539\u540e\u7684\u989d\u5ea6(%2$s)\u5c0f\u4e8e\u5df2\u62a5\u9500\u7684\u91d1\u989d(%3$s)\uff1b", (String)"ErReimburseAmountValidator_6", (String)"fi-er-opplugin", (Object[])new Object[0]), i, amountSign, reimbursedAmountSign));
                }
                if (sb.length() > 0) {
                    sb = sb.deleteCharAt(sb.lastIndexOf("\uff1b")).append('\u3002');
                }
            }
            if (sb.length() <= 0) continue;
            this.addFatalErrorMessage(dataEntity, sb.insert(0, " ").insert(0, message).toString());
        }
    }
}

