/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.utils.FilterConditionUtil;
import org.apache.commons.lang3.StringUtils;

public class ImageTplSaveOpValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObjectCollection collect = dataEntity.getDataEntity().getDynamicObjectCollection("print_tpl_entry");
            List collection = collect.stream().filter(m -> !Objects.isNull(m.get("entitymeta.id"))).collect(Collectors.toList());
            Map<Object, List<DynamicObject>> map = collection.stream().collect(Collectors.groupingBy(m -> m.get("entitymeta.id")));
            for (Map.Entry<Object, List<DynamicObject>> entry : map.entrySet()) {
                if (entry.getValue().size() == 1) continue;
                List<DynamicObject> values = entry.getValue();
                int size = values.size();
                for (int i = 0; i < size; ++i) {
                    for (int j = i + 1; j < size; ++j) {
                        DynamicObject d2;
                        DynamicObject d1;
                        if (j >= size || !this.check(dataEntity, d1 = values.get(i), d2 = values.get(j))) continue;
                        return;
                    }
                }
            }
            if (map.size() == 0) {
                return;
            }
            QFilter qFilter = new QFilter("id", "!=", dataEntity.getDataEntity().getPkValue());
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
            qFilterList.add(qFilter);
            QFilter orQfilter = null;
            for (Map.Entry<Object, List<DynamicObject>> entry : map.entrySet()) {
                DynamicObject d = entry.getValue().get(0);
                QFilter q = new QFilter("createorg", "=", dataEntity.getDataEntity().get("createorg.id"));
                q.and(new QFilter("ctrlstrategy", "=", dataEntity.getDataEntity().get("ctrlstrategy"))).and(new QFilter("print_tpl_entry.entitymeta", "=", d.get("entitymeta.id")));
                if (orQfilter == null) {
                    orQfilter = q;
                    continue;
                }
                orQfilter = orQfilter.or(q);
            }
            if (orQfilter == null) {
                return;
            }
            qFilterList.add(orQfilter);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"er_image_tpl", (String)"print_tpl_entry.entitymeta.name as entitymeta.name,print_tpl_entry.entitymeta.id as entitymeta.id,print_tpl_entry.condition_tag as condition_tag,print_tpl_entry.entitymeta.number  as entitymeta.number,print_tpl_entry.condition as condition", (QFilter[])qFilterList.toArray(new QFilter[0]));
            if (coll.size() == 0) {
                return;
            }
            Map<Object, List<DynamicObject>> oldMap = coll.stream().collect(Collectors.groupingBy(m -> m.get("entitymeta.id")));
            for (Map.Entry<Object, List<DynamicObject>> entry : map.entrySet()) {
                for (DynamicObject d1 : entry.getValue()) {
                    List<DynamicObject> olds = oldMap.get(d1.getString("entitymeta.id"));
                    if (CollectionUtils.isEmpty(olds)) continue;
                    for (DynamicObject d2 : olds) {
                        if (this.check(dataEntity, d1, d2)) break;
                    }
                }
            }
        }
    }

    private boolean check(ExtendedDataEntity dataEntity, DynamicObject d1, DynamicObject d2) {
        QFilter qFilter2;
        String tag1 = d1.getString("condition_tag");
        String tag2 = d2.getString("condition_tag");
        String msg = ResManager.loadKDString((String)"\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u3001\u201c\u63a7\u5236\u7b56\u7565\u201d\u3001\u201c\u5355\u636e\u201d\u548c\u201c\u6761\u4ef6\u201d\u7684\u7ec4\u5408\u503c\u4e0e\u5176\u4ed6\u8868\u5355\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"ImageTplSaveOpValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)tag1) && StringUtils.isEmpty((CharSequence)tag2) || tag1 != null && tag1.equals(tag2)) {
            this.addErrorMessage(dataEntity, msg);
            return true;
        }
        if (StringUtils.isBlank((CharSequence)tag1) && StringUtils.isNotBlank((CharSequence)tag2) || StringUtils.isNotBlank((CharSequence)tag1) && StringUtils.isBlank((CharSequence)tag2)) {
            return false;
        }
        QFilter qFilter1 = FilterConditionUtil.convertStringToQFilter((String)tag1, (String)d1.getString("entitymeta.number")).getQFilter();
        if (!this.compare(d1, qFilter1, qFilter2 = FilterConditionUtil.convertStringToQFilter((String)tag2, (String)d2.getString("entitymeta.number")).getQFilter())) {
            this.addErrorMessage(dataEntity, msg);
            return true;
        }
        return false;
    }

    private boolean compare(DynamicObject d1, QFilter qFilter1, QFilter qFilter2) {
        if (qFilter1.getNests(false).size() == 0 || qFilter2.getNests(false).size() == 0) {
            boolean zero;
            Set s1 = this.splitQfilter(qFilter1);
            Set s2 = this.splitQfilter(qFilter2);
            boolean size = s1.size() == s2.size();
            s1.removeAll(s2);
            boolean bl = zero = s1.size() == 0;
            return !size || !zero;
        }
        QFilter q11 = new QFilter(qFilter1.getProperty(), qFilter1.getCP(), qFilter1.getValue());
        QFilter q21 = new QFilter(qFilter2.getProperty(), qFilter2.getCP(), qFilter2.getValue());
        QFilter q22 = ((QFilter.QFilterNest)qFilter2.getNests(false).get(0)).getFilter();
        String op1 = ((QFilter.QFilterNest)qFilter1.getNests(false).get(0)).getOp();
        String op2 = ((QFilter.QFilterNest)qFilter2.getNests(false).get(0)).getOp();
        if (op1 == null || !op1.equals(op2)) {
            return true;
        }
        boolean r1 = this.compare(d1, q11, q21);
        boolean r2 = this.compare(d1, q11, q22);
        if (!r1 && !r2) {
            return false;
        }
        if (r1) {
            return this.compare(d1, ((QFilter.QFilterNest)qFilter1.getNests(false).get(0)).getFilter(), ((QFilter.QFilterNest)qFilter2.getNests(false).get(0)).getFilter());
        }
        if (r2) {
            return this.compare(d1, ((QFilter.QFilterNest)qFilter1.getNests(false).get(0)).getFilter(), q21);
        }
        return true;
    }

    private Set splitQfilter(QFilter qFilter) {
        HashSet set = Sets.newHashSetWithExpectedSize((int)10);
        StringBuilder sb = new StringBuilder().append(qFilter.getProperty()).append("_").append(qFilter.getCP()).append("_").append(qFilter.getValue());
        set.add(sb.toString());
        while (qFilter.getNests(false).size() > 0) {
            qFilter = ((QFilter.QFilterNest)qFilter.getNests(false).get(0)).getFilter();
            sb = new StringBuilder().append(qFilter.getProperty()).append("_").append(qFilter.getCP()).append("_").append(qFilter.getValue());
            set.add(sb.toString());
        }
        return set;
    }
}

