/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;

public class LoanAndAccountCurrencyUniqueValidator
extends AbstractValidator {
    private String entryName;

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (bill.getDynamicObject("company") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErReimburseBaseBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.isNeedValidate(bill)) continue;
            String name = bill.getDataEntityType().getName();
            this.entryName = ErEntityTypeUtils.isDailyReimburseBill((String)name) || ErEntityTypeUtils.isPublicReimburseBill((String)name) ? "writeoffmoney" : "clearloanentry";
            Set loanCurrency = bill.getDynamicObjectCollection(this.entryName).stream().map(loanEntry -> ErCommonUtils.getPk((Object)loanEntry.getDynamicObject("loancurrency"))).collect(Collectors.toSet());
            Set accountCurrency = bill.getDynamicObjectCollection("accountentry").stream().map(accountEntry -> ErCommonUtils.getPk((Object)accountEntry.getDynamicObject("accountcurrency"))).collect(Collectors.toSet());
            HashSet set = new HashSet();
            set.addAll(loanCurrency);
            set.addAll(accountCurrency);
            if (set.size() <= 1) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0e\u661f\u7a7a\u96c6\u6210\uff0c\u6536\u6b3e\u5e01\u79cd\u4e0e\u51b2\u9500\u501f\u6b3e\u5e01\u79cd\u9700\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"LoanAndAccountCurrencyUniqueValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isNeedValidate(DynamicObject bill) {
        DynamicObject company = bill.getDynamicObject("company");
        Long companyId = ErCommonUtils.getPk((Object)company);
        Object isiscxk = ErCommonUtils.getEMParameter((long)companyId, (String)"isiscxk");
        return "1".equals(isiscxk);
    }
}

