/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;

public class PrepayBillSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(PrepayBillSubmitValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntitys;
        for (ExtendedDataEntity dataEntity : dataEntitys = this.getDataEntities()) {
            DynamicObjectCollection contractList;
            Set idList;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            if (!ErEntityTypeUtils.isPrePayBill((String)dynamicObject.getDataEntityType().getName())) continue;
            String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
            boolean frameworkcontract = dynamicObject.getBoolean("frameworkcontract");
            DynamicObjectCollection expenseEntrys = dynamicObject.getDynamicObjectCollection("expenseentryentity");
            DynamicObjectCollection contractEntrys = dynamicObject.getDynamicObjectCollection("contractentry");
            if (expenseEntrys != null && !expenseEntrys.isEmpty()) {
                DynamicObjectCollection contractList2;
                Set idList2;
                Long wbsrcbillid = ((DynamicObject)expenseEntrys.get(0)).getLong("wbsrcbillid");
                String wbsrcbilltype = ((DynamicObject)expenseEntrys.get(0)).getString("wbsrcbilltype");
                if (wbsrcbillid != 0L && "er_applyprojectbill".equals(wbsrcbilltype)) {
                    DynamicObjectCollection applyprojectList;
                    BigDecimal payAmount = BigDecimal.ZERO;
                    BigDecimal availableamount = BigDecimal.ZERO;
                    Set idList3 = expenseEntrys.stream().map(exp -> exp.getLong("wbsrcbillid")).collect(Collectors.toSet());
                    if (idList3 != null && idList3.size() > 0 && (applyprojectList = QueryServiceHelper.query((String)"er_applyprojectbill", (String)"id,nonpayamount,notpayamount,billno,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", idList3)})) != null && applyprojectList.size() > 0) {
                        for (DynamicObject applyproject : applyprojectList) {
                            BigDecimal notpayamount;
                            availableamount = applyproject.getBigDecimal("availableamount");
                            payAmount = expenseEntrys.stream().filter(m -> m.getLong("wbsrcbillid") == applyproject.getLong("id")).map(n -> n.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                            logger.info("---availableamount---" + availableamount + "---payAmount---" + payAmount);
                            if ("2".equals(applyprojectbillRelated)) {
                                if (payAmount.compareTo(availableamount) <= 0) continue;
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7acb\u9879\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u7533\u8bf7\u91d1\u989d\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u7acb\u9879\u5355\u53ef\u7528\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]), applyproject.get("billno")));
                                continue;
                            }
                            if ("3".equals(applyprojectbillRelated) || payAmount.compareTo(notpayamount = applyproject.getBigDecimal("notpayamount")) <= 0) continue;
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7acb\u9879\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u7533\u8bf7\u91d1\u989d\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u7acb\u9879\u5355\u672a\u4ed8\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_21", (String)"fi-er-opplugin", (Object[])new Object[0]), applyproject.get("billno")));
                        }
                    }
                } else if (wbsrcbillid != 0L && "er_contractbill".equals(wbsrcbilltype) && !frameworkcontract && (idList2 = expenseEntrys.stream().map(exp -> exp.getLong("wbsrcbillid")).collect(Collectors.toSet())) != null && idList2.size() > 0 && (contractList2 = QueryServiceHelper.query((String)"er_contractbill", (String)"id,nonpayamount,notpayamount,billno,contractcode,availableamount,billcanloanamount,balanceamount,oricanloanamount,orinotpayamount,orinonpayamount,oriavailableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", idList2)})) != null && contractList2.size() > 0) {
                    for (DynamicObject contract2 : contractList2) {
                        BigDecimal billcanloanamount;
                        BigDecimal payAmount = expenseEntrys.stream().filter(m -> m.getLong("wbsrcbillid") == contract2.getLong("id")).map(n -> n.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal availableAmount = contract2.getBigDecimal("availableamount");
                        availableAmount = availableAmount.compareTo(billcanloanamount = contract2.getBigDecimal("billcanloanamount")) < 0 ? availableAmount : billcanloanamount;
                        BigDecimal oripayAmount = expenseEntrys.stream().filter(m -> m.getLong("wbsrcbillid") == contract2.getLong("id")).map(n -> n.getBigDecimal("expeapproveamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal oriavailableAmount = contract2.getBigDecimal("oriavailableamount");
                        BigDecimal oricanloanamount = contract2.getBigDecimal("oricanloanamount");
                        availableAmount = availableAmount.compareTo(billcanloanamount) < 0 ? availableAmount : billcanloanamount;
                        logger.info("---payAmount---" + payAmount + "---availableAmount---" + availableAmount + "---billcanloanamount---" + billcanloanamount + "---oripayAmount---" + oripayAmount + "---oriavailableAmount---" + oriavailableAmount + "---oricanloanamount---" + oricanloanamount);
                        if ("2".equals(applyprojectbillRelated)) {
                            if (payAmount.compareTo(availableAmount) > 0) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f0\u8d26\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u7533\u8bf7\u91d1\u989d\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u5408\u540c\u53f0\u8d26\u5355\u53ef\u7528\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_19", (String)"fi-er-opplugin", (Object[])new Object[0]), contract2.get("contractcode")));
                                continue;
                            }
                            if (oripayAmount.compareTo(oriavailableAmount) <= 0) continue;
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f0\u8d26\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u7533\u8bf7\u91d1\u989d\u539f\u5e01\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u5408\u540c\u53f0\u8d26\u5355\u53ef\u7528\u91d1\u989d\u539f\u5e01\u3002", (String)"RelationContractAmountValidator_20", (String)"fi-er-opplugin", (Object[])new Object[0]), contract2.get("contractcode")));
                            continue;
                        }
                        BigDecimal notpayamount = contract2.getBigDecimal("notpayamount");
                        if (payAmount.compareTo(notpayamount) <= 0) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f0\u8d26\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u7533\u8bf7\u91d1\u989d\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u5408\u540c\u53f0\u8d26\u5355\u672a\u4ed8\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_22", (String)"fi-er-opplugin", (Object[])new Object[0]), contract2.get("contractcode")));
                    }
                }
            }
            if (contractEntrys == null || contractEntrys.isEmpty() || frameworkcontract || (idList = contractEntrys.stream().map(contract -> contract.getLong("contractsid")).collect(Collectors.toSet())) == null || idList.size() <= 0 || (contractList = QueryServiceHelper.query((String)"er_contractbill", (String)"id,nonpayamount,notpayamount,billno,contractcode,availableamount,billcanloanamount,balanceamount,oricanloanamount,orinotpayamount,orinonpayamount,oriavailableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)})) == null || contractList.size() <= 0) continue;
            for (DynamicObject contract3 : contractList) {
                BigDecimal billcanloanamount;
                BigDecimal payAmount = contractEntrys.stream().filter(m -> m.getLong("contractsid") == contract3.getLong("id")).map(n -> n.getBigDecimal("contractcurrwriteoff")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal availableAmount = contract3.getBigDecimal("availableamount");
                availableAmount = availableAmount.compareTo(billcanloanamount = contract3.getBigDecimal("billcanloanamount")) < 0 ? availableAmount : billcanloanamount;
                BigDecimal oripayAmount = contractEntrys.stream().filter(m -> m.getLong("contractsid") == contract3.getLong("id")).map(n -> n.getBigDecimal("contractwriteoff")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal oriavailableAmount = contract3.getBigDecimal("oriavailableAmount");
                BigDecimal oricanloanamount = contract3.getBigDecimal("oricanloanamount");
                oriavailableAmount = oriavailableAmount.compareTo(oricanloanamount) < 0 ? oriavailableAmount : oricanloanamount;
                logger.info("---payAmount---" + payAmount + "---availableAmount---" + availableAmount + "---billcanloanamount---" + billcanloanamount + "---oripayAmount---" + oripayAmount + "---oriavailableAmount---" + oriavailableAmount + "---oricanloanamount---" + oricanloanamount);
                if ("2".equals(applyprojectbillRelated)) {
                    if (payAmount.compareTo(availableAmount) > 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f0\u8d26\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u7533\u8bf7\u91d1\u989d\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u5408\u540c\u53f0\u8d26\u5355\u53ef\u7528\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_19", (String)"fi-er-opplugin", (Object[])new Object[0]), contract3.get("contractcode")));
                        continue;
                    }
                    if (oripayAmount.compareTo(oriavailableAmount) <= 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f0\u8d26\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u7533\u8bf7\u91d1\u989d\u539f\u5e01\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u5408\u540c\u53f0\u8d26\u5355\u53ef\u7528\u91d1\u989d\u539f\u5e01\u3002", (String)"RelationContractAmountValidator_20", (String)"fi-er-opplugin", (Object[])new Object[0]), contract3.get("contractcode")));
                    continue;
                }
                BigDecimal notpayamount = contract3.getBigDecimal("notpayamount");
                if (payAmount.compareTo(notpayamount) <= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f0\u8d26\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u7533\u8bf7\u91d1\u989d\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u5408\u540c\u53f0\u8d26\u5355\u672a\u4ed8\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_22", (String)"fi-er-opplugin", (Object[])new Object[0]), contract3.get("contractcode")));
            }
        }
    }
}

