/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import org.apache.commons.lang3.StringUtils;

public class TripAreaSaveValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(TripAreaSaveValidator.class);
    private static final String DATE_GRID = "dateentry";
    private static final String START_MONTH = "startmonth";
    private static final String START_DAY = "startday";
    private static final String END_MONTH = "endmonth";
    private static final String END_DAY = "endday";
    private static final Set<String> LUNAR_MONTH = Collections.unmodifiableSet(Arrays.stream(new String[]{"4", "6", "9", "11"}).collect(Collectors.toSet()));

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject bills;
            DynamicObject data = dataEntity.getDataEntity();
            String name = data.getString("name");
            QFilter filter = new QFilter("name", "=", (Object)name);
            filter.and(new QFilter("id", "!=", dataEntity.getBillPkId()));
            Long createOrgId = data.getLong("createorg.id");
            QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_triparea", (Long)createOrgId);
            if (null != baseFilter) {
                filter.and(baseFilter);
            }
            if ((bills = QueryServiceHelper.queryOne((String)"er_triparea", (String)"id", (QFilter[])new QFilter[]{filter})) != null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u7ec4\u7ec7\u4e0d\u80fd\u521b\u5efa\u76f8\u540c\u540d\u79f0\u7684\u51fa\u5dee\u5730\u57df\u3002", (String)"TripAreaSaveValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            if (data.getDynamicObjectCollection("entryentity") != null && !data.getDynamicObjectCollection("entryentity").isEmpty()) {
                List ids = data.getDynamicObjectCollection("entryentity").stream().filter(v -> v.getDynamicObject("city") != null).map(v -> v.getDynamicObject("city").get("id")).collect(Collectors.toList());
                Set idSet = ids.stream().map(v -> (Long)v).collect(Collectors.toSet());
                if (idSet.size() != ids.size()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u57ce\u5e02\u91cd\u590d", (String)"TripAreaSaveValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
                Long fnumber = data.getLong("id");
                IErDao dao = ErDaoFactory.getInstance((String)"er_triparea");
                DynamicObject[] result = dao.query(new QFilter("id", "!=", (Object)fnumber).and(new QFilter("entryentity.city.id", "in", ids).and(new QFilter("createorg", "=", (Object)createOrgId))));
                if (result != null && result.length > 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u57ce\u5e02\u91cd\u590d\uff01\uff01", (String)"TripAreaSaveValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
            this.validateDate(dataEntity);
        }
    }

    private void validateDate(ExtendedDataEntity dataEntitie) {
        String dateTemplate = "yyyy-MM-dd";
        DynamicObject data = dataEntitie.getDataEntity();
        DynamicObjectCollection dateEntry = data.getDynamicObjectCollection(DATE_GRID);
        for (int i = 0; i < dateEntry.size(); ++i) {
            DynamicObject row = (DynamicObject)dateEntry.get(i);
            String startMonth = row.getString(START_MONTH);
            String startDay = row.getString(START_DAY);
            String endMonth = row.getString(END_MONTH);
            String endDay = row.getString(END_DAY);
            try {
                if (StringUtils.equals((CharSequence)"31", (CharSequence)startDay) && LUNAR_MONTH.contains(startMonth) || StringUtils.equals((CharSequence)"31", (CharSequence)endDay) && LUNAR_MONTH.contains(endMonth)) {
                    this.addErrorMessage(dataEntitie, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6708\u4efd\u4e0d\u5b58\u572831\u53f7\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u3002", (String)"TripAreaSaveValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1));
                }
                if (StringUtils.equalsAny((CharSequence)startDay, (CharSequence[])new CharSequence[]{"30", "31"}) && StringUtils.equals((CharSequence)startMonth, (CharSequence)"2") || StringUtils.equalsAny((CharSequence)endDay, (CharSequence[])new CharSequence[]{"30", "31"}) && StringUtils.equals((CharSequence)endMonth, (CharSequence)"2")) {
                    this.addErrorMessage(dataEntitie, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c2\u6708\u6700\u591a\u53ea\u80fd\u9009\u62e9\u523029\u53f7\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u3002", (String)"TripAreaSaveValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1));
                    return;
                }
                if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{startMonth, startDay, endMonth, endDay})) {
                    return;
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateTemplate);
                Date startDate = dateFormat.parse("2020" + "-" + startMonth + "-" + startDay);
                Date endDate = dateFormat.parse("2020" + "-" + endMonth + "-" + endDay);
                if (endDate.before(startDate)) {
                    this.addErrorMessage(dataEntitie, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5f00\u59cb\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u3002", (String)"TripAreaSaveValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1));
                    return;
                }
                ArrayList<Integer> conflictRows = new ArrayList<Integer>();
                if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{startMonth, startDay, endMonth, endDay})) {
                    return;
                }
                for (int j = 0; j < dateEntry.size(); ++j) {
                    if (i == j) continue;
                    DynamicObject otherRow2 = (DynamicObject)dateEntry.get(j);
                    String rowStartMonth = otherRow2.getString(START_MONTH);
                    String rowStartDay = otherRow2.getString(START_DAY);
                    String rowEndMonth = otherRow2.getString(END_MONTH);
                    String rowEndDay = otherRow2.getString(END_DAY);
                    Date rowStartDate = dateFormat.parse("2020" + "-" + rowStartMonth + "-" + rowStartDay);
                    Date rowEndDate = dateFormat.parse("2020" + "-" + rowEndMonth + "-" + rowEndDay);
                    if ((rowStartDate.getTime() != startDate.getTime() || rowEndDate.getTime() != endDate.getTime()) && (rowStartDate.getTime() > endDate.getTime() || rowEndDate.getTime() < startDate.getTime())) continue;
                    conflictRows.add(j + 1);
                }
                if (conflictRows.isEmpty()) continue;
                String msg = conflictRows.stream().map(otherRow -> otherRow.toString()).collect(Collectors.joining(","));
                this.addErrorMessage(dataEntitie, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e0e\u7b2c%2$s\u884c\u65f6\u95f4\u51b2\u7a81\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u3002", (String)"TripAreaSaveValidator_6", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1, msg));
                return;
            }
            catch (ParseException e) {
                StringWriter out = new StringWriter();
                e.printStackTrace(new PrintWriter((Writer)out, true));
                String errMsg = out.toString();
                log.error(errMsg);
            }
        }
    }
}

