/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ControlMethodEnum;
import kd.fi.er.common.Recorder;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;

public class TripReimburseSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            String message;
            String msg;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Long companyId = (Long)dynamicObject.getDynamicObject("company").getPkValue();
            DynamicObjectCollection tripEntrys = dynamicObject.getDynamicObjectCollection("tripentry");
            if (StringUtils.equals((CharSequence)dynamicObject.getString("billkind"), (CharSequence)"0") && SystemParamterUtil.isEnableTripStandard((Long)companyId) && SystemParamterUtil.getTripStandardControlLevel((long)companyId) != ControlMethodEnum.NO_CONTROL && !StringUtils.isBlank((CharSequence)(msg = IntStream.range(0, tripEntrys.size()).filter(idx -> ((DynamicObject)tripEntrys.get(idx)).getDynamicObject("tripentryarea") == null).mapToObj(idx -> String.valueOf(idx + 1)).collect(Collectors.joining(","))))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u884c\u7a0b\u5361\u7247\u5206\u5f55\u7b2c%s\u884c\u51fa\u5dee\u5730\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TripReimburseSubmitValidator_22", (String)"fi-er-opplugin", (Object[])new Object[0]), msg));
                return;
            }
            boolean isFlag = SystemParamterUtil.isReimburseAmountLargerZero((Long)companyId);
            BigDecimal approveAmount = dynamicObject.getBigDecimal("approveamount");
            if (isFlag && (approveAmount == null || approveAmount.compareTo(BigDecimal.ZERO) <= 0)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TripReimburseSubmitValidator_20", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return;
            }
            int tripEntrySize = tripEntrys.size();
            for (int index = 0; index < tripEntrySize; ++index) {
                String billKind = dynamicObject.getString("billkind");
                if ("0".equals(billKind) && (((DynamicObject)tripEntrys.get(index)).getDate("enddate") == null || null == ((DynamicObject)tripEntrys.get(index)).getDate("startdate"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u6bb5\u884c\u7a0b\u5f00\u59cb\u65f6\u95f4\uff0c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TripReimburseSubmitValidator_19", (String)"fi-er-opplugin", (Object[])new Object[0]), index + 1));
                    return;
                }
                Boolean isMonthSettlement = Boolean.FALSE;
                BigDecimal totalEntryAmount = BigDecimal.ZERO;
                DynamicObjectCollection entrys = ((DynamicObject)tripEntrys.get(index)).getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entrys) {
                    BigDecimal exchangeRate = entry.getBigDecimal("exchangerate");
                    if (exchangeRate == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a", (String)"TripReimburseSubmitValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject expenseitem = entry.getDynamicObject("expenseitem");
                    String monthType = entry.getString("settlementtype");
                    if (expenseitem != null && !"2".equalsIgnoreCase(monthType) && "002".equalsIgnoreCase(expenseitem.getString("number"))) {
                        BigDecimal taxAmount;
                        BigDecimal oriEntryAmount = entry.getBigDecimal("orientryamount");
                        if (oriEntryAmount == null) {
                            oriEntryAmount = BigDecimal.ZERO;
                        }
                        if ((taxAmount = entry.getBigDecimal("taxamount")) == null) {
                            taxAmount = BigDecimal.ZERO;
                        }
                        if (taxAmount.compareTo(oriEntryAmount.abs()) > 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u7a0e\u989d\u3002", (String)"TripReimburseSubmitValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                    if ("2".equals(entry.getString("settlementtype"))) {
                        isMonthSettlement = Boolean.TRUE;
                    }
                    BigDecimal entryAmount = entry.getBigDecimal("entryamount");
                    totalEntryAmount = totalEntryAmount.add(entryAmount);
                }
                BigDecimal tripAmount = BigDecimal.ZERO;
                if (null != tripEntrys.get(index)) {
                    tripAmount = ((DynamicObject)tripEntrys.get(index)).getBigDecimal("tripamount");
                }
                if (!(isMonthSettlement.booleanValue() || tripAmount != null && tripAmount.compareTo(BigDecimal.ZERO) != 0)) {
                    String tripInfo = null;
                    if (!this.isInvoiceAmoutZero(dynamicObject, tripEntrys, index)) {
                        tripInfo = DailyBillServiceHelper.isNewTripReim((DynamicObject)dynamicObject) ? String.format(ResManager.loadKDString((String)"\u5168\u90e8\u5dee\u65c5\u660e\u7ec6\u91d1\u989d\u5747\u4e3a0\uff0c\u9700\u81f3\u5c11\u4e00\u9879\u4e0d\u4e3a0\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u3002", (String)"TripReimburseSubmitValidator_14", (String)"fi-er-opplugin", (Object[])new Object[0]), index + 1) : String.format(ResManager.loadKDString((String)"\u7b2c%s\u6bb5\u884c\u7a0b\u91d1\u989d\u4e3a0\uff0c\u8bf7\u4fee\u6539\u6216\u5220\u9664\u540e\u518d\u63d0\u4ea4\u3002", (String)"TripReimburseSubmitValidator_12", (String)"fi-er-opplugin", (Object[])new Object[0]), index + 1);
                        if (!ErStdConfig.getBoolean((String)"validate.cancel.amountlargezero")) {
                            this.addErrorMessage(dataEntity, tripInfo);
                        }
                        return;
                    }
                }
                if (null == tripAmount || tripAmount.compareTo(totalEntryAmount) == 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u884c\u7a0b\u91d1\u989d\u5e94\u7b49\u4e8e\u660e\u7ec6\u91d1\u989d\u4e4b\u548c\u3002", (String)"TripReimburseSubmitValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal accAmounts = BigDecimal.ZERO;
            BigDecimal encashAmount = dynamicObject.getBigDecimal("encashamount");
            ArrayList<Integer> indexs = new ArrayList<Integer>();
            DynamicObjectCollection accountEntrys = dynamicObject.getDynamicObjectCollection("accountentry");
            if (accountEntrys == null || accountEntrys.isEmpty()) {
                if (encashAmount.compareTo(accAmounts) != 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4fe1\u606f\u3002", (String)"TripReimburseSubmitValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                int index = 1;
                for (DynamicObject accountEntry : accountEntrys) {
                    if (accountEntry.getDynamicObject("accountcurrency") == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4fe1\u606f\u5e01\u79cd\u3002", (String)"TripReimburseSubmitValidator_8", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    accAmounts = accAmounts.add(accountEntry.getBigDecimal("receiveamount"));
                    DynamicObject payerbank = accountEntry.getDynamicObject("payerbank");
                    if (payerbank != null && !payerbank.getBoolean("enable")) {
                        indexs.add(index);
                    }
                    ++index;
                }
            }
            if (encashAmount.compareTo(accAmounts) != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u672c\u4f4d\u5e01\u4e4b\u548c\u5e94\u7b49\u4e8e\u4ed8\u73b0\u91d1\u989d\u3002", (String)"TripReimburseSubmitValidator_9", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return;
            }
            if (!indexs.isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u7b2c%s\u884c\u4e2d\u7684\u5f00\u6237\u94f6\u884c\u5df2\u88ab\u7981\u7528\u3002", (String)"TripReimburseSubmitValidator_21", (String)"fi-er-opplugin", (Object[])new Object[]{((Object)indexs).toString().replaceAll("[^\\d|,]", "").replaceAll(",", "\uff0c")}));
                return;
            }
            if (DailyBillServiceHelper.isNewTripReim((DynamicObject)dataEntity.getDataEntity())) {
                this.newTripReimMustInputValidator(dataEntity);
            }
            if (null != (message = TripNotReimbursedOrderUtil.getOrderExistReim((DynamicObject)dynamicObject))) {
                this.addErrorMessage(dataEntity, message);
                return;
            }
            this.validatWriteOffApply(dataEntity);
            this.validateTravelersRelationTripReq(dataEntity);
        }
    }

    private void validateTravelersRelationTripReq(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObject company = bill.getDynamicObject("company");
        boolean travelersRelationTripReq = SystemParamterUtil.getBoolParamResult((Long)ErCommonUtils.getPk((Object)company), (String)"travelersrelationtripreq");
        DynamicObjectCollection writeOffApply = bill.getDynamicObjectCollection("writeoffapply");
        if (travelersRelationTripReq && CollectionUtils.isNotEmpty((Collection)writeOffApply)) {
            Set travelerIds = writeOffApply.stream().flatMap(w -> w.getDynamicObjectCollection("applytravelers").stream().map(a -> a.getDynamicObject("fbasedataid").getPkValue())).collect(Collectors.toSet());
            DynamicObjectCollection tripentries = bill.getDynamicObjectCollection("tripentry");
            Recorder tripIndex = new Recorder((Object)1);
            tripentries.forEach(tripentry -> {
                Recorder entryIndex = new Recorder((Object)1);
                tripentry.getDynamicObjectCollection("entryentity").forEach(entryentity -> {
                    entryentity.getDynamicObjectCollection("trip2travelers").forEach(traveler -> {
                        if (!travelerIds.contains(traveler.getDynamicObject("fbasedataid").getPkValue())) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u6bb5\u884c\u7a0b\uff0c\u7b2c%2$s\u884c\u660e\u7ec6\u5b58\u5728\u51fa\u5dee\u4eba\u4e0d\u5728\u5173\u8054\u51fa\u5dee\u7533\u8bf7\u5355\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TripReimburseSubmitValidator_25", (String)"fi-er-opplugin", (Object[])new Object[0]), tripIndex.getRecord(), entryIndex.getRecord()));
                        }
                    });
                    entryIndex.setRecord((Object)((Integer)entryIndex.getRecord() + 1));
                });
                tripIndex.setRecord((Object)((Integer)tripIndex.getRecord() + 1));
            });
        }
    }

    private void newTripReimMustInputValidator(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObjectCollection tripEntrys = bill.getDynamicObjectCollection("tripentry");
        if (!tripEntrys.isEmpty()) {
            for (DynamicObject tripEntry : tripEntrys) {
                DynamicObjectCollection entrys = tripEntry.getDynamicObjectCollection("entryentity");
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    DynamicObject expenseitem = entry.getDynamicObject("expenseitem");
                    if (expenseitem == null || BigDecimal.ZERO.compareTo(entry.getBigDecimal("orientryamount")) >= 0) continue;
                    boolean isVehicle = this.vehicleAttibute(expenseitem);
                    boolean isOther = this.otherAttibute(expenseitem);
                    if (entry.get("trip2from") == null && isVehicle) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u7b2c%s\u884c\u5f55\u5165\u201c\u51fa\u53d1\u5730\u201d\u3002", (String)"TripReimburseSubmitValidator_16", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1));
                    }
                    if (entry.get("trip2to") == null && !isOther) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u5f55\u5165\u201c\u76ee\u7684\u5730\u201d\u3002", (String)"TripReimburseSubmitValidator_17", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1));
                    }
                    if (entry.get("trip2startdate") != null && entry.get("trip2enddate") != null || isOther) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u5f55\u5165\u201c\u884c\u7a0b\u671f\u95f4\u201d\u3002", (String)"TripReimburseSubmitValidator_18", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1));
                }
            }
        }
    }

    private boolean vehicleAttibute(DynamicObject expenseitem) {
        return ErTripExpenseItemConstant.Attribute.getVehicleLst().contains(expenseitem.get("attribute"));
    }

    protected boolean otherAttibute(DynamicObject expenseitem) {
        return ErTripExpenseItemConstant.Attribute.getOtherLst().contains(expenseitem.get("attribute"));
    }

    protected boolean subsidyAttribute(DynamicObject expenseitem) {
        return ErTripExpenseItemConstant.Attribute.getSubsidyLst().contains(expenseitem.get("attribute"));
    }

    private boolean isInvoiceAmoutZero(DynamicObject dataEntity, DynamicObjectCollection tripEntry, int index) {
        DynamicObjectCollection items = ((DynamicObject)tripEntry.get(index)).getDynamicObjectCollection("entryentity");
        if (items.stream().allMatch(v -> StringUtils.equals((CharSequence)v.getString("itemfrom"), (CharSequence)ItemFrom.InvoiceCloud.getValue()))) {
            Set itemIdSet = items.stream().map(v -> (Long)v.getPkValue()).filter(v -> v != null && v != 0L).collect(Collectors.toSet());
            Set invoiceIdSet = dataEntity.getDynamicObjectCollection("invoiceitementry").stream().filter(v -> itemIdSet.contains(v.get("itementryid"))).map(v -> v.getLong("invoiceheadentryid")).collect(Collectors.toSet());
            BigDecimal invoiceTotal = dataEntity.getDynamicObjectCollection("invoiceentry").stream().filter(v -> invoiceIdSet.contains(v.getPkValue())).map(v -> v.getBigDecimal("totalamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            return invoiceTotal.compareTo(BigDecimal.ZERO) == 0;
        }
        return false;
    }

    private Boolean validatWriteOffApply(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        int reqbilltoreimbursecount = SystemParamterUtil.getloancheckparam((long)ErCommonUtils.getPk((Object)bill.get("company")), (String)"reqbilltoreimbursecount");
        if (reqbilltoreimbursecount > 0) {
            return true;
        }
        DynamicObjectCollection writeOffApply = bill.getDynamicObjectCollection("writeoffapply");
        if (writeOffApply == null || writeOffApply.isEmpty()) {
            return true;
        }
        Set applyBillNo = writeOffApply.stream().map(v -> v.getString("applybillno")).collect(Collectors.toSet());
        if (applyBillNo.isEmpty()) {
            return true;
        }
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", applyBillNo)});
        Set applyBillId = bills.stream().map(v -> (Long)v.get("id")).collect(Collectors.toSet());
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"er_tripreqbill", (Long[])((Long[])applyBillId.stream().toArray(Long[]::new)));
        if (targetBills != null && targetBills.containsKey("er_tripreimbursebill")) {
            Set targetBillId = (Set)targetBills.get("er_tripreimbursebill");
            Object id = bill.get("id");
            if (id != null) {
                targetBillId.remove(ErCommonUtils.getPk((Object)id));
            }
            QFilter qFilter = new QFilter("id", "in", (Object)targetBillId);
            qFilter.and("billstatus", "!=", (Object)Character.valueOf('H'));
            DynamicObjectCollection targetBill = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (targetBill.size() > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51b2\u7533\u8bf7\u5206\u5f55\u5173\u8054\u5355\u636e\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u6e05\u7406\u540e\u64cd\u4f5c\u3002", (String)"TripReimburseSubmitValidator_24", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }
}

