/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.servicehelper.LoanBalanceServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ErBillStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class TripReqSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        block0: for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            if (dynamicObject.getDynamicObject("applier") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"TripReqSubmitValidator_20", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return;
            }
            String billStatus = dynamicObject.getString("billstatus");
            boolean isLoan = dynamicObject.getBoolean("isloan");
            boolean istravelers = dynamicObject.getBoolean("istravelers");
            if (!ErBillStatusEnum.A.toString().equals(billStatus) && !ErBillStatusEnum.D.toString().equals(billStatus)) {
                if (!isLoan) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355\u9700\u5148\u6682\u5b58\u540e\u624d\u80fd\u63d0\u4ea4\u3002", (String)"TripReqSubmitValidator_10", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue;
                }
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6682\u5b58\u7684\u51fa\u5dee\u7533\u8bf7\u5355(\u501f)\u624d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"TripReqSubmitValidator_11", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (isLoan) {
                Object accountEntry2;
                Date repaydate = dynamicObject.getDate("repaymentdate");
                Date bizdate = dynamicObject.getDate("bizdate");
                if (repaydate == null || repaydate.before(bizdate)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u8ba1\u8fd8\u6b3e\u65e5\u671f\u5e94\u665a\u4e8e\u7533\u8bf7\u65e5\u671f\u3002", (String)"TripReqSubmitValidator_12", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection accountEntrys = dynamicObject.getDynamicObjectCollection("accountentry");
                if (accountEntrys == null || accountEntrys.isEmpty()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4fe1\u606f\u3002", (String)"TripReqSubmitValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<Integer> indexs = new ArrayList<Integer>();
                int index = 1;
                for (Object accountEntry2 : accountEntrys) {
                    DynamicObject payerbank = accountEntry2.getDynamicObject("payerbank");
                    if (payerbank != null && !payerbank.getBoolean("enable")) {
                        indexs.add(index);
                    }
                    ++index;
                }
                if (!indexs.isEmpty()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u7b2c%s\u884c\u4e2d\u7684\u5f00\u6237\u94f6\u884c\u5df2\u88ab\u7981\u7528\u3002", (String)"TripReqSubmitValidator_14", (String)"fi-er-opplugin", (Object[])new Object[]{((Object)indexs).toString().replaceAll("[^\\d|,]", "").replaceAll(",", "\uff0c")}));
                    return;
                }
                BigDecimal totalReceiveAmount = BigDecimal.ZERO;
                accountEntry2 = accountEntrys.iterator();
                while (accountEntry2.hasNext()) {
                    DynamicObject accountEntry3 = (DynamicObject)accountEntry2.next();
                    BigDecimal receiveAmount = accountEntry3.getBigDecimal("receiveamount");
                    totalReceiveAmount = totalReceiveAmount.add(receiveAmount);
                    if (accountEntry3.getDynamicObject("accountcurrency") != null) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4fe1\u606f\u5e01\u79cd\u3002", (String)"TripReqSubmitValidator_13", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return;
                }
                BigDecimal encashamount = dynamicObject.getBigDecimal("encashamount");
                if (totalReceiveAmount.compareTo(encashamount) != 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u73b0\u91d1\u989d\u548c\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0d\u76f8\u7b49\uff0c\u8bf7\u6838\u5bf9\u7533\u8bf7\u91d1\u989d\u3001\u6536\u6b3e\u91d1\u989d\u3002", (String)"TripReqSubmitValidator_7", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return;
                }
                Set itemSet = dynamicObject.getDynamicObjectCollection("tripentry").stream().map(row -> ErCommonUtils.getPk((Object)row.getDynamicObject("tripexpenseitem"))).filter(pk -> pk != null).collect(Collectors.toSet());
                String msg = LoanBalanceServiceHelper.getloanBillMsg((DynamicObject)dynamicObject.getDynamicObject("company"), (DynamicObject)dynamicObject.getDynamicObject("applier"), itemSet);
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    this.addFatalErrorMessage(dataEntity, msg);
                    continue;
                }
            }
            if (!isLoan && !istravelers) continue;
            DynamicObjectCollection tripentrys = dynamicObject.getDynamicObjectCollection("tripentry");
            for (DynamicObject tripentry : tripentrys) {
                if (tripentry.get("tripexpenseitem") != null) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8d39\u7528\u9879\u76ee\u201d\u3002", (String)"TripReqSubmitValidator_9", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue block0;
            }
        }
    }
}

