/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.tripstd.model.TripStandardDetail;

public class TripStandardSaveValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(TripStandardSaveValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            QFilter baseDataProFilter;
            QFilter filter;
            String entityNumber = dataEntity.getDataEntity().getDataEntityType().getName();
            if (!this.checkMustInput(dataEntity)) {
                return;
            }
            this.checkReimburseLevel(dataEntity, entityNumber);
            DynamicObject tripStandard = dataEntity.getDataEntity();
            String standardName = tripStandard.getString("name");
            if (standardName == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540d\u79f0\u5fc5\u586b", (String)"TripStandardSaveValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject createOrg = (DynamicObject)dataEntity.getValue("createorg");
            if (createOrg == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"TripStandardSaveValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection bills = null;
            if ("er_tripstand_accmodation".equals(entityNumber)) {
                filter = new QFilter("name", "=", (Object)standardName);
                filter.and(new QFilter("id", "!=", dataEntity.getBillPkId()));
                baseDataProFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripstand_accmodation", (Long)createOrg.getLong("id"));
                if (null != baseDataProFilter) {
                    filter.and(baseDataProFilter);
                }
                bills = QueryServiceHelper.query((String)"er_tripstand_accmodation", (String)"id", (QFilter[])new QFilter[]{filter});
            } else if ("er_tripstandard_vehicle".equals(entityNumber)) {
                filter = new QFilter("name", "=", (Object)standardName);
                filter.and(new QFilter("id", "!=", dataEntity.getBillPkId()));
                baseDataProFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripstandard_vehicle", (Long)createOrg.getLong("id"));
                if (null != baseDataProFilter) {
                    filter.and(baseDataProFilter);
                }
                bills = QueryServiceHelper.query((String)"er_tripstandard_vehicle", (String)"id", (QFilter[])new QFilter[]{filter});
            }
            if (bills == null || bills.size() <= 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u7ec4\u7ec7\u4e0b\uff0c\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\u3002", (String)"TripStandardSaveValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkMustInput(ExtendedDataEntity dataEntity) {
        boolean result = true;
        DataEntityPropertyCollection tripStandardProperties = dataEntity.getDataEntity().getDynamicObjectType().getProperties();
        if (!tripStandardProperties.containsKey((Object)"entryentity")) {
            return result;
        }
        DynamicObject tripStandard = dataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = tripStandard.getDynamicObjectCollection("entryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                Object currency;
                Object triparea;
                DynamicObject v = (DynamicObject)entryEntity.get(i);
                Object tripstandardtype = v.get("tripstandardtype");
                if (tripstandardtype == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6807\u51c6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TripStandardSaveValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    result = false;
                }
                if ((triparea = v.get("triparea")) == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fa\u5dee\u5730\u57df\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TripStandardSaveValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    result = false;
                }
                if ((currency = v.get("currency")) != null) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a", (String)"TripStandardSaveValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
                result = false;
            }
        }
        return result;
    }

    private void checkReimburseLevel(ExtendedDataEntity dataEntity, String entityNumber) {
        DynamicObject tripStandard = dataEntity.getDataEntity();
        DynamicObjectCollection coll = tripStandard.getDynamicObjectCollection("reimburselevel");
        List pkIds = coll.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        IErDao erDao = ErDaoFactory.getInstance((String)entityNumber);
        DynamicObject createOrg = (DynamicObject)dataEntity.getValue("createorg");
        if (createOrg == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"TripStandardSaveValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("id", "!=", dataEntity.getBillPkId());
        qFilter = qFilter.and(new QFilter("createorg", "=", createOrg.getPkValue()));
        if ("er_tripstandard_vehicle".equalsIgnoreCase(entityNumber)) {
            qFilter = qFilter.and(new QFilter("standardtype", "=", dataEntity.getValue("standardtype")));
            if (erDao.isExist(qFilter = qFilter.and(new QFilter("reimburselevel.fbasedataid_id", "in", pkIds)))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u516c\u53f8\u62a5\u9500\u7ea7\u522b\u3001\u6807\u51c6\u7c7b\u578b\u4e0d\u80fd\u91cd\u590d\u3002", (String)"TripStandardSaveValidator_6", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        } else if ("er_tripstand_accmodation".equalsIgnoreCase(entityNumber)) {
            DynamicObjectCollection entryEntity = tripStandard.getDynamicObjectCollection("entryentity");
            HashSet details = Sets.newHashSet();
            for (DynamicObject entry : entryEntity) {
                TripStandardDetail detail = new TripStandardDetail();
                detail.setCurrency(((DynamicObject)entry.get("currency")).getPkValue().toString());
                detail.setTripArea(((DynamicObject)entry.get("triparea")).getPkValue().toString());
                detail.setTripstandardtype(((DynamicObject)entry.get("tripstandardtype")).getPkValue().toString());
                details.add(detail);
            }
            if (details.size() < entryEntity.size()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u51fa\u5dee\u5730\u57df\u3001\u6807\u51c6\u7c7b\u578b\u548c\u5e01\u79cd\u5fc5\u987b\u552f\u4e00\u3002", (String)"TripStandardSaveValidator_7", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            block3: for (Object pkId : pkIds) {
                for (DynamicObject entry : entryEntity) {
                    QFilter lastQFilter = qFilter.copy().and("reimburselevel.fbasedataid_id", "=", pkId).and("entryentity.tripstandardtype", "=", ((DynamicObject)entry.get("tripstandardtype")).getPkValue()).and("entryentity.triparea", "=", ((DynamicObject)entry.get("triparea")).getPkValue()).and("entryentity.currency", "=", ((DynamicObject)entry.get("currency")).getPkValue());
                    if (!erDao.isExist(lastQFilter)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u516c\u53f8\u62a5\u9500\u7ea7\u522b\u3001\u51fa\u5dee\u5730\u57df\u3001\u6807\u51c6\u7c7b\u578b\u548c\u5e01\u79cd\u5fc5\u987b\u552f\u4e00\u3002", (String)"TripStandardSaveValidator_8", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    break block3;
                }
            }
        }
        try {
            logger.info("\u5dee\u65c5\u6807\u51c6\u4fdd\u5b58\u6821\u9a8c\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a" + JSONUtils.toString((Object)qFilter));
        }
        catch (IOException e) {
            logger.info(e.getMessage());
        }
    }
}

