/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.invoicecloud.billingpool;

import com.google.common.collect.ArrayListMultimap;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.billingpool.model.BillingPoolConfigModel;
import kd.fi.er.business.billingpool.util.BillingPoolConfigUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class BillingPoolControlValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(BillingPoolControlValidator.class);
    private Function<ExtendedDataEntity, List<BillingPoolControlValidatorArgs>> function;
    private boolean hadCheckOverValidator = false;
    private ArrayListMultimap<Long, String> billingRelationMap = null;
    private List<Long> billingIds = null;

    public BillingPoolControlValidator(Function<ExtendedDataEntity, List<BillingPoolControlValidatorArgs>> function) {
        this.function = function;
    }

    public void validate() {
        ExtendedDataEntity[] billEntitys = this.getDataEntities();
        this.hadCheckOverValidator = String.valueOf(true).equals(this.getOption().getVariableValue("hadCheckOverValidator", ""));
        for (int i = 0; i < billEntitys.length; ++i) {
            ExtendedDataEntity billEntity = billEntitys[i];
            this.validateOver(billEntity, this.function);
        }
    }

    private List<Long> getBillingIds(List<BillingPoolControlValidatorArgs> invoiceDateList) {
        if (this.billingIds == null) {
            this.billingIds = invoiceDateList.stream().filter(v -> v.getBillingId() != null && !v.getBillingId().equals(0L) && !((BillingPoolControlValidatorArgs)v).ismutilreimburse).map(v -> v.getBillingId()).collect(Collectors.toList());
        }
        return this.billingIds;
    }

    private ArrayListMultimap<Long, String> queryBillingRelation(List<Long> billingIds) {
        if (this.billingRelationMap == null) {
            DynamicObjectCollection query;
            this.billingRelationMap = ArrayListMultimap.create();
            if (!billingIds.isEmpty() && !(query = QueryServiceHelper.query((String)"er_billingpool", (String)"id,voucherentity.relbills,voucherentity.relbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", billingIds)})).isEmpty()) {
                for (DynamicObject billingpool : query) {
                    this.billingRelationMap.put((Object)billingpool.getLong("id"), (Object)billingpool.getString("voucherentity.relbills"));
                }
            }
        }
        return this.billingRelationMap;
    }

    private void validateOver(ExtendedDataEntity billEntity, Function<ExtendedDataEntity, List<BillingPoolControlValidatorArgs>> function) {
        List<BillingPoolControlValidatorArgs> invoiceDateList = function.apply(billEntity);
        for (int i = 0; i < invoiceDateList.size(); ++i) {
            BillingPoolConfigModel config;
            List billingPoolConfigModels = BillingPoolConfigUtils.queryPoolConfigs((Long)invoiceDateList.get(i).getAccountOrg());
            if (billingPoolConfigModels.isEmpty() || !(config = (BillingPoolConfigModel)billingPoolConfigModels.get(0)).canManualAdd() && !config.canImport() || this.hadCheckOverValidator) continue;
            this.checkOver(billEntity, invoiceDateList, i, config);
        }
    }

    private void checkOver(ExtendedDataEntity billEntity, List<BillingPoolControlValidatorArgs> invoiceDateList, int i, BillingPoolConfigModel config) {
        Date invoiceDate = invoiceDateList.get(i).getInvoiceDate();
        if (invoiceDate == null) {
            return;
        }
        String ctltype = config.getCtlType();
        int periodDay = config.getPeriod();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime start = now.minusDays(periodDay);
        if ("STRICT_CONTROL".equals(ctltype) || "TIP_CONTROL".equals(ctltype)) {
            Date startDate = ErCommonUtils.getDateFromLocalDate((LocalDate)start.toLocalDate());
            if (invoiceDate.compareTo(startDate) < 0) {
                this.addTip(billEntity, invoiceDateList.get(i).getInvoiceNo(), "overDue", ctltype);
            }
            int currentYear = now.getYear();
            Calendar calendar = DateUtils.toCalendar((Date)invoiceDate);
            int invoiceYear = calendar.get(1);
            if (invoiceYear < currentYear) {
                if (config.isCrossYear()) {
                    LocalDateTime end;
                    int month = config.getUpToMonth();
                    if (month == 12) {
                        month = 0;
                        ++currentYear;
                    }
                    if (now.isAfter(end = LocalDateTime.of(currentYear, month + 1, 1, 0, 0))) {
                        this.addTip(billEntity, invoiceDateList.get(i).getInvoiceNo(), "overMonth", ctltype);
                    }
                } else {
                    this.addTip(billEntity, invoiceDateList.get(i).getInvoiceNo(), "overYear", ctltype);
                }
            }
        }
    }

    private void addTip(ExtendedDataEntity billEntity, String ctltype, String message) {
        if ("STRICT_CONTROL".equals(ctltype)) {
            this.addErrorMessage(billEntity, message);
        }
        if ("TIP_CONTROL".equals(ctltype)) {
            this.addWarningMessage(billEntity, message);
        }
    }

    private void addTip(ExtendedDataEntity billEntity, String invoiceNo, String type, String level) {
        String tip = "";
        switch (type) {
            case "overYear": {
                tip = ResManager.loadKDString((String)"\u53d1\u7968(%s)\u8de8\u5e74\u62a5\u9500\u3002", (String)"BillingPoolSubmitValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]);
                tip = String.format(tip, invoiceNo);
                break;
            }
            case "overMonth": {
                tip = ResManager.loadKDString((String)"\u53d1\u7968(%s)\u8d85\u622a\u6b62\u6708\u4efd\u62a5\u9500\u3002", (String)"BillingPoolSubmitValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]);
                tip = String.format(tip, invoiceNo);
                break;
            }
            case "overDue": {
                tip = ResManager.loadKDString((String)"\u53d1\u7968(%s)\u8d85\u671f\u62a5\u9500\u3002", (String)"BillingPoolSubmitValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]);
                tip = String.format(tip, invoiceNo);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)tip)) {
            if ("STRICT_CONTROL".equals(level)) {
                this.addErrorMessage(billEntity, tip);
            }
            if ("TIP_CONTROL".equals(level)) {
                tip = tip.replaceAll("[\u3002.]+$", "");
                this.addWarningMessage(billEntity, tip);
            }
        }
    }

    public static class BillingPoolControlValidatorArgs {
        private Long accountOrg;
        private Date invoiceDate;
        private String invoiceNo;
        private Long billingId;
        private boolean ismutilreimburse;

        public BillingPoolControlValidatorArgs(Long accountOrg, Date invoiceDate, String invoiceNo, Long billingId, boolean ismutilreimburse) {
            this.accountOrg = accountOrg;
            this.invoiceDate = invoiceDate;
            this.invoiceNo = invoiceNo;
            this.billingId = billingId;
            this.ismutilreimburse = ismutilreimburse;
        }

        public String getInvoiceNo() {
            return this.invoiceNo;
        }

        public Date getInvoiceDate() {
            return this.invoiceDate;
        }

        public Long getAccountOrg() {
            return this.accountOrg;
        }

        public Long getBillingId() {
            return this.billingId;
        }

        public boolean isIsmutilreimburse() {
            return this.ismutilreimburse;
        }

        public void setIsmutilreimburse(boolean ismutilreimburse) {
            this.ismutilreimburse = ismutilreimburse;
        }
    }
}

