/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.invoicecloud.billingpool;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.billingpool.model.BillingPoolConfigModel;
import kd.fi.er.business.billingpool.util.BillingPoolConfigUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class BillingPoolSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(BillingPoolSubmitValidator.class);
    private static final String TOTAL_AMOUNT = "totalamount";

    public void validate() {
        ExtendedDataEntity[] billEntitys = this.getDataEntities();
        this.setAddBillNoForContent(false);
        for (int i = 0; i < billEntitys.length; ++i) {
            String tip;
            DynamicObject billpooltype;
            ExtendedDataEntity billEntity = billEntitys[i];
            DynamicObject srcBill = billEntity.getDataEntity();
            BigDecimal total = srcBill.getBigDecimal(TOTAL_AMOUNT);
            if ((null == total || BigDecimal.ZERO.compareTo(srcBill.getBigDecimal(TOTAL_AMOUNT)) == 0) && CollectionUtils.isEmpty((Collection)srcBill.getDynamicObjectCollection("entryentity"))) {
                this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u884c\u8d26\u5355\u660e\u7ec6\u3002", (String)"BillingPoolGenericValidator_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if ((billpooltype = srcBill.getDynamicObject("billpooltype")) == null || !billpooltype.getBoolean("isinvoice")) continue;
            String strConfig = ErStdConfig.get((String)"billingpool.mustinput.config");
            JSONObject config = new JSONObject();
            if (StringUtils.isNotBlank((CharSequence)strConfig)) {
                config = JSONObject.parseObject((String)strConfig);
            } else {
                config.put("noInvoiceNo", (Object)"24,11");
                config.put("noInvoiceDate", (Object)"24,11,14");
            }
            String noInvoiceNo = config.getString("noInvoiceNo");
            String noInvoiceDate = config.getString("noInvoiceDate");
            List<String> noInvoiceNos = Arrays.asList(noInvoiceNo.split(","));
            List<String> noInvoiceDates = Arrays.asList(noInvoiceDate.split(","));
            String invoiceNo = srcBill.getString("invoiceno");
            Date invoiceDate = srcBill.getDate("invoicedate");
            DynamicObject invoiceType = srcBill.getDynamicObject("invoicetype");
            if (null == invoiceType) {
                String tip2 = ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u8d26\u5355\u6c60,\u201c\u53d1\u7968\u7c7b\u578b\u201d\u5fc5\u586b\u3002", (String)"BillingPoolSubmitValidator_9", (String)"fi-er-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(billEntity, tip2);
                return;
            }
            String typeNum = invoiceType.getString("number");
            String billNo = billEntity.getBillNo();
            boolean isPass = true;
            if (!noInvoiceNos.contains(typeNum) && (StringUtils.isBlank((CharSequence)invoiceNo) || "-".equals(invoiceNo))) {
                tip = ResManager.loadKDString((String)"\u8d26\u5355%1$s\u53d1\u7968\u7c7b\u578b\u4e3a%2$s,\u201c\u53d1\u7968\u53f7\u7801\u201d\u5fc5\u586b\u3002", (String)"BillingPoolSubmitValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(billEntity, String.format(tip, billNo, invoiceType.getString("name")));
                isPass = false;
            }
            if (!noInvoiceDates.contains(typeNum) && null == invoiceDate) {
                tip = ResManager.loadKDString((String)"\u8d26\u5355%1$s\u53d1\u7968\u7c7b\u578b\u4e3a%2$s,\u201c\u53d1\u7968/\u8d26\u5355\u65e5\u671f\u201d\u5fc5\u586b\u3002", (String)"BillingPoolSubmitValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(billEntity, String.format(tip, billNo, invoiceType.getString("name")));
                isPass = false;
            }
            if (isPass) continue;
            return;
        }
        this.checkDup(billEntitys);
    }

    private void checkDup(ExtendedDataEntity[] billEntitys) {
        Object[] existFromDB;
        List lists = Stream.of(billEntitys).filter(v -> {
            DynamicObject billpooltype = v.getDataEntity().getDynamicObject("billpooltype");
            if (billpooltype != null) {
                return billpooltype.getBoolean("isinvoice");
            }
            return false;
        }).collect(Collectors.toList());
        ArrayListMultimap multimap = ArrayListMultimap.create();
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)lists.size());
        HashMap validatorMap = Maps.newHashMapWithExpectedSize((int)lists.size());
        for (Object[] billEntity : lists) {
            String uniquecondition;
            DynamicObject invoicetype;
            Long pk;
            List billingPoolConfigModels;
            boolean uniqueCon = false;
            DynamicObject costCompany = billEntity.getDataEntity().getDynamicObject("costcompany");
            if (null != costCompany && !(billingPoolConfigModels = BillingPoolConfigUtils.queryPoolConfigs((Long)(pk = ErCommonUtils.getPk((Object)costCompany)))).isEmpty()) {
                uniqueCon = ((BillingPoolConfigModel)billingPoolConfigModels.get(0)).isUniqueCon();
            }
            if (!uniqueCon || billEntity.getDataEntity().get("invoicetype") == null || (invoicetype = billEntity.getDataEntity().getDynamicObject("invoicetype")) != null && StringUtils.isBlank((CharSequence)(uniquecondition = invoicetype.getString("uniquecondition")))) continue;
            UniQueDimensionMonster uniQueDimension = new UniQueDimensionMonster(billEntity.getDataEntity());
            multimap.put((Object)uniQueDimension.getDimensionValue(), this.genVal(billEntity.getDataEntity()));
            qFilters.add(uniQueDimension.getDBFilter());
            validatorMap.put(billEntity, uniQueDimension);
        }
        for (Object existBilling : existFromDB = this.getExistBillingFromDB(qFilters)) {
            DynamicObject billEntity = (DynamicObject)existBilling;
            Set entries = validatorMap.entrySet();
            for (Map.Entry entry : entries) {
                String[] uniqueDimension = ((UniQueDimensionMonster)entry.getValue()).getUniqueDimension();
                if (!this.matchingDimension(uniqueDimension, billEntity, (ExtendedDataEntity)entry.getKey())) continue;
                multimap.put((Object)((UniQueDimensionMonster)entry.getValue()).getDimensionValue(), this.genVal(billEntity));
            }
        }
        Set entries = validatorMap.entrySet();
        for (Map.Entry entry : entries) {
            Set<ImmutablePair<String, String>> dupBillSet;
            String dimensionValue = ((UniQueDimensionMonster)entry.getValue()).getDimensionValue();
            List dupBillNos = multimap.get((Object)dimensionValue);
            if (dupBillNos.size() <= 1 || (dupBillSet = this.removeSelf(dupBillNos, this.genVal(((ExtendedDataEntity)entry.getKey()).getDataEntity()))).isEmpty()) continue;
            boolean isExpenseSync = ((ExtendedDataEntity)entry.getKey()).getDataEntity().getBoolean("isexpensesync");
            String bills = dupBillSet.stream().map(ImmutablePair::getLeft).collect(Collectors.joining(","));
            if (isExpenseSync) {
                String invoiceNos = dupBillSet.stream().map(ImmutablePair::getRight).distinct().collect(Collectors.joining(","));
                String tip = ResManager.loadKDString((String)"\u53d1\u7968\uff08%1$s\uff09\u5df2\u751f\u6210\u8d26\u5355\uff08%2$s\uff09\uff0c\u8bf7\u4ece\u8d26\u5355\u6c60\u5bfc\u5165\u3002", (String)"BillingPoolSubmitValidator_10", (String)"fi-er-opplugin", (Object[])new Object[0]);
                tip = String.format(tip, invoiceNos, bills);
                this.addErrorMessage((ExtendedDataEntity)entry.getKey(), tip + "\r\n");
                continue;
            }
            String tip = ResManager.loadKDString((String)"\u53d1\u7968\u6216\u6d88\u8d39\u8d26\u5355\u7591\u4f3c\u5df2\u751f\u6210\u8d26\u5355(%s)\u3002", (String)"BillingPoolBaseValidator_checkDup", (String)"fi-er-opplugin", (Object[])new Object[0]);
            this.addErrorMessage((ExtendedDataEntity)entry.getKey(), String.format(tip, bills) + "\r\n");
        }
    }

    private ImmutablePair<String, String> genVal(DynamicObject bill) {
        String billno = bill.getString("billno");
        String invoiceno = bill.getString("invoiceno");
        return ImmutablePair.of((Object)billno, (Object)invoiceno);
    }

    private boolean matchingDimension(String[] uniqueDimension, DynamicObject matchEntityFromDB, ExtendedDataEntity srcEntity) {
        DynamicObject srcDataEntity = srcEntity.getDataEntity();
        for (String dimension : uniqueDimension) {
            if (this.equals(dimension, srcDataEntity, matchEntityFromDB)) continue;
            return false;
        }
        return true;
    }

    private boolean equals(String dimension, DynamicObject srcDataEntity, DynamicObject matchEntityFromDB) {
        DynamicProperty srcProp = srcDataEntity.getDynamicObjectType().getProperty(dimension);
        DynamicProperty matchProp = matchEntityFromDB.getDynamicObjectType().getProperty(dimension);
        if (srcProp != null && matchProp != null) {
            Object srcValue = srcProp.getValueFast((Object)srcDataEntity);
            Object matchValue = matchProp.getValueFast((Object)matchEntityFromDB);
            if (srcValue == null || StringUtils.isBlank((CharSequence)srcValue.toString())) {
                return true;
            }
            if (srcValue instanceof DynamicObject && matchValue instanceof DynamicObject) {
                return ((DynamicObject)srcValue).getPkValue().equals(((DynamicObject)matchValue).getPkValue());
            }
            return srcValue.equals(matchValue);
        }
        return false;
    }

    private Set<ImmutablePair<String, String>> removeSelf(List<ImmutablePair<String, String>> dupBillNos, ImmutablePair<String, String> billNo) {
        HashSet dupBills = Sets.newHashSetWithExpectedSize((int)8);
        for (ImmutablePair<String, String> dupBillNo : dupBillNos) {
            if (((String)dupBillNo.left).equals(billNo.left)) continue;
            dupBills.add(dupBillNo);
        }
        return dupBills;
    }

    private Object[] getExistBillingFromDB(List<QFilter[]> qFilters) {
        ArrayList pks = Lists.newArrayListWithExpectedSize((int)qFilters.size());
        for (QFilter[] qfilter : qFilters) {
            pks.addAll(this.getPkByFilter(qfilter));
        }
        if (!pks.isEmpty()) {
            return BusinessDataServiceHelper.load((Object[])pks.toArray(), (IDataEntityType)this.getDataEntities()[0].getDataEntity().getDataEntityType());
        }
        return new Object[0];
    }

    private List<Object> getPkByFilter(QFilter[] qfilter) {
        if (qfilter == null) {
            return Collections.EMPTY_LIST;
        }
        return QueryServiceHelper.queryPrimaryKeys((String)"getBillingPkByFilter", (String)"er_billingpool", (QFilter[])qfilter, (String)"id", (int)100);
    }

    private static class UniQueDimensionMonster {
        private String[] uniqueDimension;
        private String dimensionValue;
        private QFilter[] DBFilter;

        private UniQueDimensionMonster(DynamicObject billingPool) {
            String uniquecondition;
            DynamicObject invoicetype = billingPool.getDynamicObject("invoicetype");
            if (invoicetype != null && StringUtils.isNotBlank((CharSequence)(uniquecondition = invoicetype.getString("uniquecondition")))) {
                this.uniqueDimension = uniquecondition.split(",");
                this.dimensionValue = this.getDimensionValue(billingPool, invoicetype, this.uniqueDimension);
                this.DBFilter = this.getDBFilter(billingPool, invoicetype, this.uniqueDimension);
            }
        }

        private QFilter[] getDBFilter(DynamicObject dataEntity, DynamicObject invoicetype, String[] uniqueDimension) {
            QFilter[] qfilter = new QFilter[uniqueDimension.length + 3];
            int rowIndex = 0;
            qfilter[rowIndex++] = new QFilter("invoicetype", "=", invoicetype.getPkValue());
            qfilter[rowIndex++] = new QFilter("billcreatetime", "<=", (Object)LocalDateTime.now());
            qfilter[rowIndex++] = new QFilter("billcreatetime", ">=", (Object)LocalDate.now().minusYears(1L));
            DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
            for (String dimension : uniqueDimension) {
                Object valueFast;
                DynamicProperty property = dynamicObjectType.getProperty(dimension);
                if (property == null || (valueFast = property.getValueFast((Object)dataEntity)) == null) continue;
                qfilter[rowIndex++] = new QFilter(dimension, "=", this.toObj(valueFast));
            }
            return qfilter;
        }

        private Object toObj(Object obj) {
            if (obj instanceof DynamicObject) {
                return ((DynamicObject)obj).getPkValue();
            }
            return obj;
        }

        private String getDimensionValue(DynamicObject dataEntity, DynamicObject invoicetype, String[] uniqueDimension) {
            DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
            Object[] values = new Object[uniqueDimension.length];
            int index = 0;
            for (String dimension : uniqueDimension) {
                DynamicProperty property = dynamicObjectType.getProperty(dimension);
                if (property == null) continue;
                Object valueFast = property.getValueFast((Object)dataEntity);
                values[index++] = valueFast;
            }
            return this.toString(invoicetype, values);
        }

        private String toString(DynamicObject invoicetype, Object[] values) {
            StringBuilder sb = new StringBuilder(invoicetype.getPkValue().toString());
            sb.append(",");
            for (Object obj : values) {
                sb.append(this.toString(obj)).append(",");
            }
            return sb.toString();
        }

        private Object toString(Object obj) {
            if (obj instanceof DynamicObject) {
                return ((DynamicObject)obj).getPkValue();
            }
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }

        public String getDimensionValue() {
            return this.dimensionValue;
        }

        public QFilter[] getDBFilter() {
            return this.DBFilter;
        }

        public String[] getUniqueDimension() {
            return this.uniqueDimension;
        }
    }
}

