/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.publicbiz.bill;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;

public class CostestimateBillSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(CostestimateBillSubmitValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntitys;
        for (ExtendedDataEntity dataEntity : dataEntitys = this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection expenseEntrys = bill.getDynamicObjectCollection("expenseentryentity");
            if (expenseEntrys == null || expenseEntrys.isEmpty() || !ErEntityTypeUtils.isCostEstimateBill((String)bill.getDataEntityType().getName())) continue;
            String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
            if (expenseEntrys == null || expenseEntrys.isEmpty() || !"2".equals(applyprojectbillRelated)) continue;
            Long wbsrcbillid = ((DynamicObject)expenseEntrys.get(0)).getLong("wbsrcbillid");
            String wbsrcbilltype = ((DynamicObject)expenseEntrys.get(0)).getString("wbsrcbilltype");
            if (wbsrcbillid == 0L || !"er_applyprojectbill".equals(wbsrcbilltype)) continue;
            BigDecimal payAmount = BigDecimal.ZERO;
            BigDecimal availableamount = BigDecimal.ZERO;
            Set idList = expenseEntrys.stream().map(exp -> exp.getLong("wbsrcbillid")).collect(Collectors.toSet());
            if (idList == null || idList.size() <= 0) continue;
            DynamicObjectCollection applyprojectList = QueryServiceHelper.query((String)"er_applyprojectbill", (String)"id,nonpayamount,notpayamount,billno,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
            for (DynamicObject applyproject : applyprojectList) {
                availableamount = applyproject.getBigDecimal("availableamount");
                payAmount = expenseEntrys.stream().filter(m -> m.getLong("wbsrcbillid") == applyproject.getLong("id")).map(n -> n.getBigDecimal("expeapprovecurramount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                logger.info("---availableamount---" + availableamount + "---payAmount---" + payAmount);
                if (payAmount.compareTo(availableamount) <= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7acb\u9879\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u7533\u8bf7\u91d1\u989d\u5408\u8ba1\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u7acb\u9879\u5355\u53ef\u7528\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]), applyproject.get("billno")));
            }
        }
    }
}

