/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.trip.usergrant;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class TripUserGrantValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap userNoAndServerMap = Maps.newHashMapWithExpectedSize((int)16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Object grantservers;
            Object userNo;
            if (!this.checkMustInput(dataEntity) || (userNo = dataEntity.getValue("grantuserno")) == null || (grantservers = dataEntity.getValue("grantservers")) == null) continue;
            userNoAndServerMap.put(userNo.toString(), grantservers.toString());
        }
        if (!userNoAndServerMap.isEmpty()) {
            DynamicObjectCollection existGrantDatas = QueryServiceHelper.query((String)"er_trip_usergrant", (String)"grantservers,grantuserno", (QFilter[])new QFilter[]{new QFilter("grantuserno", "in", userNoAndServerMap.keySet())});
            if (CollectionUtils.isEmpty((Collection)existGrantDatas)) {
                return;
            }
            Map<String, List<DynamicObject>> existDataMap = existGrantDatas.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getString("grantuserno")));
            Set entries = userNoAndServerMap.entrySet();
            ArrayList errorUserNos = Lists.newArrayListWithCapacity((int)entries.size());
            for (Map.Entry entry : entries) {
                List<DynamicObject> dynamicObjects;
                Set servers;
                String key = (String)entry.getKey();
                if (!existDataMap.containsKey(key) || !(servers = (dynamicObjects = existDataMap.get(key)).stream().map(dynamicObject -> dynamicObject.getString("grantservers")).collect(Collectors.toSet())).contains(entry.getValue())) continue;
                errorUserNos.add(key);
            }
            if (CollectionUtils.isEmpty((Collection)errorUserNos)) {
                return;
            }
            for (ExtendedDataEntity dataEntity : dataEntities) {
                Object userNo = dataEntity.getValue("grantuserno");
                if (userNo == null || !errorUserNos.contains(userNo.toString())) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u670d\u52a1\u5546\u5df2\u6388\u6743\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u670d\u52a1\u5546\u3002", (String)"TripUserGrantValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private boolean checkMustInput(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String grantservers = dynamicObject.getString("grantservers");
        if (StringUtils.isEmpty((String)grantservers)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6388\u6743\u670d\u52a1\u5546\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TripUserGrantValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

