/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.web.openapi;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.kuep.capp.model.card.DataPanelCard;
import kd.kuep.capp.sdk.DataPanelCardProxy;

public class ErCloudAppMainPageOpenApi
implements IBillWebApiPlugin {
    public static final Log logger = LogFactory.getLog(ErCloudAppMainPageOpenApi.class);
    private static final String LINK_TYPE = "webview";

    public ApiResult doCustomService(Map<String, Object> params) {
        logger.info("ErCloudAppMainPageOpenApi request parameters\uff1a" + params);
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        try {
            Long currentUserID = CommonServiceHelper.getCurrentUserID();
            logger.info("the operator : " + currentUserID);
            Map countMap = CommonServiceHelper.getNotReimburseCountUsedByEmPage((Long)currentUserID);
            int tripNotReimburseCount = (Integer)countMap.get("tripNotReimburseCount");
            logger.info("the travel request : " + tripNotReimburseCount);
            BigDecimal amount = CommonServiceHelper.getTripReimburseOutStandingAmount((Long)currentUserID);
            logger.info("the travel reimbursement :" + amount);
            BigDecimal notArrivedBankAmount = CommonServiceHelper.getReceivableInDailyReimburse((Long)currentUserID);
            logger.info("the expense reimbursement :" + notArrivedBankAmount);
            String tripNotReimburseCountStr = String.format(ResManager.loadKDString((String)"%s\u7b14", (String)"ErCloudAppMainPageOpenApi_1", (String)"fi-er-webapi", (Object[])new Object[0]), tripNotReimburseCount);
            String amountStr = amount.toString();
            String notArrivedBankAmountStr = notArrivedBankAmount.toString();
            DynamicObject currency = BaseCurrencyServiceHelper.getBaseCurrencyObject((Long)RequestContext.get().getOrgId());
            if (currency != null) {
                amountStr = ErCommonUtils.getMoneyStringWithSymbol((BigDecimal)amount, (CurrencyBO)new CurrencyBO((Long)currency.getPkValue()));
                notArrivedBankAmountStr = ErCommonUtils.getMoneyStringWithSymbol((BigDecimal)notArrivedBankAmount, (CurrencyBO)new CurrencyBO((Long)currency.getPkValue()));
            }
            String linkUrl = UrlService.getDomainContextUrl() + "/mobile.html";
            String travelApplyPath = linkUrl + "?form=er_tripreqlisttemplate&billFormId=er_tripreqbill&type=mobilelist&tabKey=noReimburse";
            String travelReimbursementPath = linkUrl + "?form=er_billtemplate&billFormId=er_tripreimbursebill&type=mobilelist";
            String expenseReimbursementPath = linkUrl + "?form=er_reimbursebill_moblist&billFormId=er_dailyreimbursebill&type=mobilelist";
            logger.info(String.format("travelApplyPath: %s, travelReimbursementPath: %s, expenseReimbursementPath: %s", travelApplyPath, travelReimbursementPath, expenseReimbursementPath));
            DataPanelCardProxy dataPanelCardProxy = new DataPanelCardProxy();
            DataPanelCard dataPanelCard = dataPanelCardProxy.getDataPanelCard();
            dataPanelCard.setCardTitle(ResManager.loadKDString((String)"\u6211\u7684\u8d39\u7528", (String)"ErCloudAppMainPageOpenApi_0", (String)"fi-er-webapi", (Object[])new Object[0]));
            dataPanelCardProxy.addDataList(ResManager.loadKDString((String)"\u5f85\u62a5\u9500(\u51fa\u5dee\u7533\u8bf7)", (String)"ErCloudAppMainPageOpenApi_2", (String)"fi-er-webapi", (Object[])new Object[0]), tripNotReimburseCountStr, null, null, LINK_TYPE, travelApplyPath, null, null);
            dataPanelCardProxy.addDataList(ResManager.loadKDString((String)"\u5f85\u6536\u6b3e(\u5dee\u65c5\u62a5\u9500)", (String)"ErCloudAppMainPageOpenApi_3", (String)"fi-er-webapi", (Object[])new Object[0]), amountStr, null, null, LINK_TYPE, travelReimbursementPath, null, null);
            dataPanelCardProxy.addDataList(ResManager.loadKDString((String)"\u5f85\u6536\u6b3e(\u8d39\u7528\u62a5\u9500)", (String)"ErCloudAppMainPageOpenApi_4", (String)"fi-er-webapi", (Object[])new Object[0]), notArrivedBankAmountStr, null, null, LINK_TYPE, expenseReimbursementPath, null, null);
            result.setData((Object)dataPanelCard);
        }
        catch (Exception exception) {
            logger.error("ErCloudAppMainPageOpenApi handle failed ", (Throwable)exception);
            result.setErrorCode("6000");
            result.setMessage("data parsing failed");
        }
        return result;
    }
}

